;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Integrate/ctn.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 14:10:09 1995                          */
;*    Last change :  Fri Jun 28 16:05:26 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of `Cn' and `Ct'.                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_ctn
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    integrate_info
	    integrate_a)
   (export  (Cn&Ct! <a-set>)))

;*---------------------------------------------------------------------*/
;*    Cn&Ct! ...                                                       */
;*    -------------------------------------------------------------    */
;*    This function returns the list of the globalized functions due   */
;*    to the Cn property.                                              */
;*---------------------------------------------------------------------*/
(define (Cn&Ct! A)
   (let loop ((As    A)
	      (G/cn '()))
      (if (null? As)
	  (begin
	     (trace-ctn)
	     G/cn)
	  (let* ((A  (car As))
		 (f  (car A))
		 (g  (cadr A))
		 (k  (caddr A))
		 (fi (variable-value f))
		 (gi (variable-value g)))
	     (cond
		((global? g)
		 (loop (cdr As) G/cn))
		((eq? k 'tail)
		 (sfun/Iinfo-Ct-set! fi (cons g (sfun/Iinfo-Ct fi)))
		 (if (and (not (eq? f g))
			  (not (memq g (sfun/Iinfo-kont fi))))
		     (sfun/Iinfo-kont-set! fi (cons g (sfun/Iinfo-kont fi))))
		 (loop (cdr As) G/cn))
		((eq? k 'escape)
		 (if (not (memq g (sfun/Iinfo-kont fi)))
		     (sfun/Iinfo-kont-set! fi (cons g (sfun/Iinfo-kont fi))))
		 (loop (cdr As) G/cn))
		((sfun/Iinfo-U gi)
		 (sfun/Iinfo-Ct-set! fi (cons g (sfun/Iinfo-Ct fi)))
		 (if (not (memq g (sfun/Iinfo-kont fi)))
		     (sfun/Iinfo-kont-set! fi (cons g (sfun/Iinfo-kont fi))))
		 (loop (cdr As) G/cn))
		(else
		 (sfun/Iinfo-Cn-set! fi (cons g (sfun/Iinfo-Cn fi)))
		 (if (not (sfun/Iinfo-G? gi))
		     (begin
			(sfun/Iinfo-G?-set! gi #t)
			(loop (cdr As) (cons g G/cn)))
		     (loop (cdr As) G/cn))))))))

;*---------------------------------------------------------------------*/
;*    trace-ctn ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-ctn)
   (trace (integrate 2)
	  (begin
	     (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
	     (fprint *trace-port* "C: " #\Newline)
	     (for-each (lambda (p)
			  (let ((ifun (variable-value p)))
			     (fprint *trace-port*
				     " --> " (shape p) #\: #\Newline
				     "   Cn        : "
				     (shape (sfun/Iinfo-Cn ifun))
				     #\Newline
				     "   Ct        : "
				     (shape (sfun/Iinfo-Ct ifun))
				     #\Newline
				     "   Cont      : "
				     (shape (sfun/Iinfo-kont ifun)))))
		       *phi*)
	     "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
	  #\Newline))

