;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Integrate/a.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 14 10:52:56 1995                          */
;*    Last change :  Fri Jul 12 17:17:12 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the A relation.
;*    -------------------------------------------------------------    */
;*    We don't have problem with `celled' because such variables       */
;*    are now set as only readed (which is a great idea :-).           */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_a
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    type_type
	    ast_var
	    ast_node
	    integrate_info)
   (export  (A ::global ::node)
	    *phi*))

;*---------------------------------------------------------------------*/
;*    *phi* ...                                                        */
;*---------------------------------------------------------------------*/
(define *phi* #unspecified)

;*---------------------------------------------------------------------*/
;*    A ...                                                            */
;*    -------------------------------------------------------------    */
;*    We compute the A property (see Seniak's thesis) and for          */
;*    each function, we compute the set of its free variables.         */
;*---------------------------------------------------------------------*/
(define (A global node)
   ;; the setups
   (set! *phi*  (list global))
   (set! *kont* 0)
   (initialize-fun! global global)
   ;; we start the A computation
   (let ((A (node-A node global 'tail '())))
      (trace-A A)
      A))

;*---------------------------------------------------------------------*/
;*    initialize-fun! ...                                              */
;*---------------------------------------------------------------------*/
(define (initialize-fun! fun::variable owner::variable)
   (widen!::sfun/Iinfo (variable-value fun)
      (owner owner)
      (G? (global? fun)))
   (for-each (lambda (x)
		(widen!::svar/Iinfo (local-value x)))
	     (sfun-args (variable-value fun))))

;*---------------------------------------------------------------------*/
;*    *kont* ...                                                       */
;*---------------------------------------------------------------------*/
(define *kont* #unspecified)

;*---------------------------------------------------------------------*/
;*    get-new-kont ...                                                 */
;*---------------------------------------------------------------------*/
(define (get-new-kont)
   (set! *kont* (+fx 1 *kont*))
   *kont*)

;*---------------------------------------------------------------------*/
;*    trace-A ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-A A)
   (trace (integrate 2)
	  "- - - - - - - - - - - - - - - - "
	  #\Newline
	  "PHI: " (shape *phi*) #\newline
	  (begin
	     (for-each (lambda (a) 
			  (fprint *trace-port*
				  "A( " (shape (car a)) ", "
				  (shape (cadr a)) ", "
				  (caddr a) " )"))
		       A)
	     "- - - - - - - - - - - - - - - - ")
	  #\Newline))

;*---------------------------------------------------------------------*/
;*    node-A ...                                                       */
;*---------------------------------------------------------------------*/
(define-generic (node-A node::node host::variable k::obj A))

;*---------------------------------------------------------------------*/
;*    node-A ::atom ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-A node::atom host k A)
   A)

;*---------------------------------------------------------------------*/
;*    node-A ::kwote ...                                               */
;*---------------------------------------------------------------------*/
(define-method (node-A node::kwote host k A)
   A)

;*---------------------------------------------------------------------*/
;*    node-A ::var ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (node-A node::var host k A)
   A)

;*---------------------------------------------------------------------*/
;*    node-A ::closure ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-A node::closure host k A)
   (internal-error "node-A" "Unexpected closure" (shape node)))

;*---------------------------------------------------------------------*/
;*    node-A ::sequence ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-A node::sequence host k A)
   (with-access::sequence node (nodes) 
      (if (null? nodes)
	  A
	  (let liip ((nds nodes)
		     (A     A))
	     (if (null? (cdr nds))
		 (node-A (car nds) host k A)
		 (liip (cdr nds)
		       (node-A (car nds) host (get-new-kont) A)))))))

;*---------------------------------------------------------------------*/
;*    node-A ::app ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (node-A node::app host k A)
   (with-access::app node (fun)
      (let ((callee (var-variable fun)))
	 ;; we manage the actuals
	 (let liip ((args (app-args node))
		    (A    A))
	    (if (null? args)
		(cond
		   ((local? callee)
		    (cons `(,host ,callee ,k) A))
		   (else
		    A))
		(liip (cdr args)
		      (node-A (car args)
			      host
			      (get-new-kont)
			      A)))))))

;*---------------------------------------------------------------------*/
;*    node-A ::app-ly ...                                               */
;*---------------------------------------------------------------------*/
(define-method (node-A node::app-ly host k A)
   (with-access::app-ly node (fun arg)
      (node-A fun host (get-new-kont) (node-A arg host (get-new-kont) A))))

;*---------------------------------------------------------------------*/
;*    node-A ::funcall ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-A node::funcall host k A)
   (with-access::funcall node (fun args)
      (node-A fun
	      host
	      (get-new-kont)
	      (let liip ((args args)
			 (A    A))
		 (if (null? args)
		     A
		     (liip (cdr args)
			   (node-A (car args) host (get-new-kont) A)))))))

;*---------------------------------------------------------------------*/
;*    node-A ::pragma ...                                              */
;*---------------------------------------------------------------------*/
(define-method (node-A node::pragma host k A)
   (with-access::pragma node (args)
      (let liip ((asts args)
		 (A    A))
	 (if (null? asts)
	     A
	     (liip (cdr asts)
		   (node-A (car asts) host (get-new-kont) A))))))

;*---------------------------------------------------------------------*/
;*    node-A ::cast ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-A node::cast host k A)
   (with-access::cast node (arg)
      (node-A arg host (get-new-kont) A)))

;*---------------------------------------------------------------------*/
;*    node-A ::setq ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-A node::setq host k A)
   (with-access::setq node (value)
      (node-A value host (get-new-kont) A)))

;*---------------------------------------------------------------------*/
;*    node-A ::conditional ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-A node::conditional host k A)
   (with-access::conditional node (test true false)
      (let ((A (node-A test host (get-new-kont) A)))
	 (node-A true host k (node-A false host k A)))))

;*---------------------------------------------------------------------*/
;*    node-A ::fail ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-A node::fail host k A)
   (with-access::fail node (proc msg obj)
      (node-A proc
	      host
	      (get-new-kont)
	      (node-A msg
		      host
		      (get-new-kont)
		      (node-A obj host (get-new-kont) A)))))      

;*---------------------------------------------------------------------*/
;*    node-A ::select ...                                              */
;*---------------------------------------------------------------------*/
(define-method (node-A node::select host k A)
   (with-access::select node (test)
      (let liip ((clauses (select-clauses node))
		 (A       (node-A test
				  host
				  (get-new-kont)
				  A)))
	 (if (null? clauses)
	     A
	     (liip (cdr clauses)
		   (node-A (cdr (car clauses)) host k A))))))

;*---------------------------------------------------------------------*/
;*    node-A ::let-fun ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-A node::let-fun host k A)
   (with-access::let-fun node (body)
      ;; we initialize all the local definitions
      (for-each (lambda (f)
		   (initialize-fun! f host)
		   (set! *phi* (cons f *phi*)))
		(let-fun-locals node))
      ;; now, we scan the locals definitions and the body
      (let liip ((locals (let-fun-locals node))
		 (A      A))
	 (if (null? locals)
	     (node-A body host k A)
	     (liip (cdr locals)
		   (node-A (sfun-body (local-value (car locals)))
			   (car locals)
			   'tail
			   A))))))

;*---------------------------------------------------------------------*/
;*    node-A ::let-var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-A node::let-var host k A)
   (with-access::let-var node (body)
      (let liip ((bindings (let-var-bindings node))
		 (A        A))
	 (if (null? bindings)
	     (node-A body host k A)
	     (let* ((binding (car bindings))
		    (var (car binding))
		    (val (cdr binding)))
		(widen!::svar/Iinfo (local-value var))
		(liip (cdr bindings)
		      (node-A val host (get-new-kont) A)))))))
 
;*---------------------------------------------------------------------*/
;*    node-A ::set-ex-it ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-A node::set-ex-it host k A)
   (with-access::set-ex-it node (var body)
      ;; in order to be sure that `set-ex-it' handler
      ;; are always globalized we simulate to two-non tail
      ;; call to them if the handler is not detached
      ;; (see globalize pass)
      (let* ((exit (var-variable var))
	     (hdlg (sexit-handler (local-value exit))))
	 (widen!::sexit/Iinfo (local-value exit))
	 (if (not (sexit-detached? (local-value exit)))
	     (let ((call-1 `(,hdlg ,hdlg ,(get-new-kont)))
		   (call-2 `(,hdlg ,hdlg ,(get-new-kont))))
		(node-A body
			host
			(get-new-kont)
			(cons call-1 (cons call-2 A))))
	     A))))

;*---------------------------------------------------------------------*/
;*    node-A ::jump-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-A node::jump-ex-it host k A)
   (with-access::jump-ex-it node (exit value)
      (node-A exit host (get-new-kont) (node-A value host (get-new-kont) A))))

;*---------------------------------------------------------------------*/
;*    node-A ::make-box ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-A node::make-box host k A)
   (with-access::make-box node (value)
      (node-A value host (get-new-kont) A)))

;*---------------------------------------------------------------------*/
;*    node-A ::box-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-A node::box-set! host k A)
   (with-access::box-set! node (var value)
      (node-A value host (get-new-kont) A)))

;*---------------------------------------------------------------------*/
;*    node-A ::box-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node-A node::box-ref host k A)
   A)

		
	    
