;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Inline/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  9 19:15:23 1995                          */
;*    Last change :  Thu Aug 15 07:58:34 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inlining pass                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_walk
   (include "Engine/pass.sch"
	    "Tools/trace.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_error
	    module_module
	    engine_param
	    ast_remove
	    (inline-sfun! inline_inline))
   (export  (inline-walk! <globals> ::symbol)
	    (inline-setup! ::symbol)
	    *kfactor*
	    *inlined-calls*
	    *non-inlined-calls*))

;*---------------------------------------------------------------------*/
;*    inline-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inline-walk! globals what)
   [assert (what) (memq what '(all reducer))]
   (pass-prelude "Inlining" reset-stat!)
   ;; we setup the inlining
   (inline-setup! what)
   ;; we scan all the local definitions to inline there body
   (for-each (lambda (g)
		(let ((kfactor (if (eq? (sfun-class (global-value g)) 'sifun)
				   1
				   *kfactor*)))
		   ;; I think that it is useless to inline the body of
		   ;; inline definitions. It only looses a little when this
		   ;; inline is used as values but I think this is rare.
		   (enter-function (global-id g))
		   (inline-sfun! g kfactor '())
		   (leave-function)))
	     globals)
   ;; and we just return the reachable variables
   (let loop ((globals     globals)
	      (new-globals '()))
      (cond
	 ((null? globals)
	  (pass-postlude (remove-var 'inline (reverse! new-globals))
			 show-stat!))
	 ((eq? (global-module (car globals)) *module*)
	  (loop (cdr globals) (cons (car globals) new-globals)))
	 (else
	  (loop (cdr globals) new-globals)))))

;*---------------------------------------------------------------------*/
;*    Statistics variables                                             */
;*---------------------------------------------------------------------*/
(define *inlined-calls* 0)
(define *non-inlined-calls* 0))

;*---------------------------------------------------------------------*/
;*    reset-stat! ...                                                  */
;*---------------------------------------------------------------------*/
(define (reset-stat!)
   (set! *inlined-calls* 0)
   (set! *non-inlined-calls* 0))

;*---------------------------------------------------------------------*/
;*    show-stat! ...                                                   */
;*---------------------------------------------------------------------*/
(define (show-stat!)
   (verbose 2 "      (inlined calls     : " *inlined-calls* #")\n")
   (verbose 2 "      (non inlined calls : " *non-inlined-calls* #")\n"))
   
   
;*---------------------------------------------------------------------*/
;*    inline-setup! ...                                                */
;*---------------------------------------------------------------------*/
(define (inline-setup! what)
   ;; we set the kfactor
   (case what
      ((all)
       (set! *kfactor* (*inlining-kfactor* *optim*)))
      ((reducer)
       (set! *kfactor* 1))
      (else
       (internal-error "inline-setup!" "Illegal mode" what))))

;*---------------------------------------------------------------------*/
;*    *kfactor* ...                                                    */
;*---------------------------------------------------------------------*/
(define *kfactor* 1)



