;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Init/parse-args.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Aug  7 11:47:46 1994                          */
;*    Last change :  Fri Jan  8 15:05:12 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The command line arguments parsing                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_parse-args
   (include "Init/args.sch"
	    "Tools/trace.sch")
   (export  (parse-args args))
   (import  engine_param
	    init_main
	    init_extend
	    init_setrc
	    module_module
	    (make-library-name module_alibrary)
	    write_version
	    tools_trace
	    tools_speek
	    tools_license
	    read_access))

;*---------------------------------------------------------------------*/
;*    Global parse args parameters ...                                 */
;*---------------------------------------------------------------------*/
(define *extended-done?*  #f)
(define *library-init*    '())
(define *trace-level*     0)

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args args)
   (set! *bigloo-cmd-name* (car args))
   (set! *bigloo-args*     args)
   (do-parse-args (cdr args))
   (let ((pres (if *extended-done?*
		   #t
		   (let ((auto-mode (let loop ((sfiles *src-files*))
				       (if (null? sfiles)
					   #f
					   (let ((cell (and
							(string? (car sfiles))
							(assoc
							 (suffix (car sfiles))
							 *auto-mode*))))
					      (if (pair? cell)
						  (cdr cell)
						  (loop (cdr sfiles))))))))
		      (if auto-mode
			  (begin
			     (set! *src-files* '())
			     (do-parse-args `("-extend"
					      ,auto-mode
					      ,@(cdr args))))
			  #t)))))
      ;; we are done for the parsing, we invert all the lists
      (set! *src-files*       (reverse! *src-files*))
      (set! *o-files*         (reverse! *o-files*))
      (set! *load-path*       (reverse! *load-path*))
      (set! *bigloo-user-lib* (reverse! *bigloo-user-lib*))
      (set! *rest-args*       (reverse! *rest-args*))
      (set! *lib-dir*         (reverse! *lib-dir*))
      ;; we clean the optimization flags
      (if (not (boolean? *optim-stack?*))
	  (set! *optim-stack?* #f))
      (if (not (boolean? *optim-unroll-loop?*))
	  (set! *optim-unroll-loop?* #f))
      (if (not (boolean? *optim-inline-method?*))
	  (set! *optim-inline-method?* #f))
      (if (>fx *bdb-debug* 0)
	  (begin
	     (set! *inlining?* #f)
	     (if (>fx *optim* 0)
		 (begin
		    (warning "Incompatible options"
			     "-O / -gbdb"
			     "disabling debug")
		    (set! *bdb-debug* 0)))))
      ;; we start the trace if the level is > 0
      (if (>fx *trace-level* 0)
	  (let ((passes (trace get-pass-names)))
	     (if (memq *pass* passes)
		 (start-trace *trace-level* *pass*)
		 (warning "parse-args" "No trace for this pass -- " *pass*))
	     (for-each (lambda (pass)
			  (if (not (memq pass passes))
			      (warning "parse-args"
				       "No trace for this pass -- "
				       pass)))
		       *additional-traces*)))
      ;; we init the libraries
      (for-each setup-library-values *library-init*)
      ;; and we are done for the arguments parsing
      pres))
 
;*---------------------------------------------------------------------*/
;*    do-parse-args ...                                                */
;*---------------------------------------------------------------------*/
(define (do-parse-args args)
   (define (environment-usage manual?)
      (print "Shell Variables:")
      (newline)
      (for-each (lambda (var)
		   (if manual?
		       (begin
			  (print "   - " (car var))
			  (print "     " (cdr var)))
		       (print "   - " (car var) ": " (cdr var))))
		'(("TMPDIR" . "tmp directory (default \"/tmp\")")
		  ("BIGLOOLIB" . "libraries' directory")
		  ("BIGLOOHEAP" . "the initial heap size in megabytes (4 Mo by default)")
		  ("BIGLOOSTACKDEPTH" . "the error stack depth printing")))
      (newline)
      (print "Runtime Command file:")
      (print "   - ~/.bigloorc"))
   (define (usage args-parse-usage level manual?)
      (version)
      (print "usage: bigloo [options] [name.suf]")
      (newline)
      (args-parse-usage manual?)
      (newline)
      (print " * : only available in developing mode")
      (print " + : not always available")
      (print " . : option enabled from -O3 mode")
      (newline)
      (newline)
      (environment-usage manual?)
      (if (> level 1)
	  (begin
	     (newline)
	     (print "Bigloo Control Variables:")
	     (bigloo-variables-usage manual?)))
      (if *bigloo-licensing?*
	  (begin
	     (newline)
	     (newline)
	     (print (bigloo-license))))
      (exit-bigloo 0))
   (args-parse args

;*--- misc ------------------------------------------------------------*/
      (section "Misc")
      ;; priliminary test
      (("-" (synopsis "Read source code on current input channel"))
       (set! *src-files* (cons 'stdin *src-files*)))
      ;; help
      (("?")
       (usage args-parse-usage 1 #f))
      (("-help" (synopsis "This help message"))
       (usage args-parse-usage 1 #f))
      (("-help2" (synopsis "The exhaustive help message"))
       (usage args-parse-usage 2 #f))
      (("-help-manual" (synopsis "The help message formatted for the manual"))
       (usage args-parse-usage 2 #t))
      ;; output name
      (("-o" ?dst (synopsis "Name the output file <dst>"))
       (set! *dest* dst))
      ;; output to current output port
      (("--to-stdout" (synopsis "Write C code on current output channel"))
       (set! *verbose* -1)
       (set! *dest* '--to-stdout))
      ;; stop after .o production
      (("-c" (synopsis "Suppress linking and produce a .o file"))
       (set! *pass* 'cc))
      ;; suffixes
      (("-suffix" ?suffix (synopsis "Recognize suffix as Scheme source"))
       (set! *src-suffix* (cons suffix *src-suffix*)))
      ;; interperter
      (("-i" (synopsis "Don't compile but interprete a src-file"))
       (set! *interpreter* #t))
      ;; access file name
      (("-afile" ?file (synopsis "Set name of the access file"))
       (set! *access-file* file))
      ;; one access
      (("-access" ?module ?file 
		  (synopsis "Set access between module and file"))
       (add-access! (string->symbol (string-upcase module)) (list file)))
      ;; main function
      (("-main" ?fun (synopsis "Set the main function"))
       (set! *main* (string->symbol (string-upcase fun))))
      ;; Bigloo libary
      (("-library" ?library (synopsis "Compile (and link) with additional library"))
       (let* ((lib-name  (make-library-name library))
	      (heap-name (string-append lib-name ".heap")))
	  (set! *library-init* (cons library *library-init*))
	  (set! *additional-bigloo-libraries*
		(cons lib-name *additional-bigloo-libraries*))
	  (set! *additional-heap-names*
		(cons heap-name *additional-heap-names*))))
      (("-heapsize" ?size (synopsis "Set the initial heap size value (in megabyte)"))
       (set! *user-heap-size* (string->integer size)))
      
;*--- Optimization ----------------------------------------------------*/
      (section "Optimization")
      ;; benchmarking
      (("-Obench" (synopsis "Benchmarking mode (also consider -fstack option)"))
       (set! the-remaining-args
	     (append '("-O5" "-unsafe" "-copt" "-O3" "-static-bigloo")
		     the-remaining-args)))
      ;; optimization
      (("-O?opt" (synopsis "-O[2..6]" "Optimization modes"))
       (parse-optim-args opt))
      ;; stack allocation
      (("-fstack" (synopsis "Enable Heap->stack optimization"))
       (set! *optim-stack?* #t))
      (("-fno-stack" (synopsis "Disable Heap->stack optimization"))
       (set! *optim-stack?* #f))
      (("-finline-method" (synopsis "Enable methods inlining (enabled from -O3)"))
       (set! *optim-inline-method?* #t))
      (("-fno-inline-method" (synopsis "Disable methods inlining"))
       (set! *optim-inline-method?* #f))
      (("-funroll-loop" (synopsis "Enable loop unrolling (enabled from -O3)"))
       (set! *optim-unroll-loop?* #t))
      (("-fno-unroll-loop" (synopsis "Disable loop unrolling"))
       (set! *optim-unroll-loop?* #f))
      (("-fno-loop-inlining" (synopsis "Disable loop inlining"))
       (set! *optim-loop-inlining?* #f)) 
      (("-floop-inlining" (synopsis "Enable loop inlining (default)"))
       (set! *optim-loop-inlining?* #t)) 
      (("-fno-inlining" (synopsis "Disable inline optimization"))
       (set! *inlining?* #f))
      (("-fO-macro" (synopsis "Enable Optimization macro (default)"))
       (set! *optim-O-macro?* #t))
      (("-fno-O-macro" (synopsis "Disable Optimization macro"))
       (set! *optim-O-macro?* #f))

;*--- Compilation modes -----------------------------------------------*/
      (section "Compilation modes")
      ;; remove temporary files
      (("-rm" (synopsis "<-/+>rm" "Don't or force removing C file"))
       (set! *rm-c-files* #f))
      (("+rm")
       (set! *rm-c-files* #t))
      ;; Extended compiler
      (("-extend" ?name (synopsis "Extend the compiler"))
       (set! *extended-done?* #t)
       (load-extend name)
       (if (procedure? *extend-entry*)
	   (set! the-remaining-args (*extend-entry* the-remaining-args))))
      (("-fsharing" (synopsis "Attempt to share constant data"))
       (set! *shared-cnst?* #t))
      (("-fno-sharing" (synopsis "Do not attempt to share constant data"))
       (set! *shared-cnst?* #f))
      (("-fmco" (synopsis "Produce an .mco file"))
       (set! *module-checksum-object?* #t))
      
;*--- Safety ----------------------------------------------------------*/
      (section "Safety")
      ;; unsafe
      (("-unsafe?opt"
	(synopsis "-unsafe[atrsvl]"
		  "Don't check [type/arity/range/struct/version]"))
       (parse-unsafe-args opt))

;*--- Debug -----------------------------------------------------------*/
      (section "Debug")
      ;; -g
      (("-g" (synopsis "-g[234]" "Produce Bigloo debug informations"))
       (set! *compiler-debug* 1))
      (("-g2")
       (set! *compiler-debug* 2))
      (("-g3")
       ;; -g3 and -call/cc are incompatible
       (if (not *call/cc?*)
	   (set! *compiler-debug* 3)))
      (("-g4")
       (set! *compiler-debug* 4))
      (("-cg" (synopsis "Compile C files with debug option"))
       (set! *rm-c-files* #f)
       (set! *c-debug* #t)
       (set! *strip* #f))
      (("-gbdb" (synopsis "-gbdb[2]" "Compile with bdb debug informations"))
       (set! *additional-heap-names* (cons "bdb.heap" *additional-heap-names*))
       (set! *user-heap-size* 1)
       (set! *bdb-debug* 1))
      (("-gbdb2")
       (set! *additional-heap-names* (cons "bdb.heap" *additional-heap-names*))
       (set! *user-heap-size* 1)
       (set! *bdb-debug* 2))
      
;*--- Profiling -------------------------------------------------------*/
      (section "Profiling")
      ;; -pg
      (("-p" (synopsis "-p[2]" "Compile files for profiling (+)"))
       (set! *strip* #f)
       (set! *cc-options* (string-append *cc-options* " -pg"))
       (set! *profile-mode* 1))
      (("-p2")
       (set! *strip* #f)
       (set! *profile-library* #t)
       (set! *cc-options* (string-append *cc-options* " -pg"))
       (set! *profile-mode* 1)
       (set! the-remaining-args
	     (cons "-static-bigloo" the-remaining-args)))
      (("-pg" (synopsis "Compile files with profiling option (+)"))
       (set! *strip* #f)
       (set! *profile-library* #t)
       (set! *cc-options* (string-append *cc-options* " -pg")))
	        
;*--- Configuration and version ---------------------------------------*/
      (section "Configuration and path")
      ;; version
      (("-version" (synopsis "The current release"))
       (short-version)
       (exit-bigloo 0))
      ;; revision
      (("-revision" (synopsis "The current release (short format)"))
       (revision)
       (exit-bigloo 0))
      ;; query
      (("-query" (synopsis "Dump the current configuration"))
       (query))
      ;; -q
      (("-q" (synopsis "Do not load any rc file"))
       'nothing-to-do)
      ;; -eval
      (("-eval" ?string (synopsis "Evaluate <string>"))
       (let ((port (open-input-string string)))
	  (let laap ((exp (read port)))
	     (if (eof-object? exp)
		 'done
		 (begin
		    (eval exp)
		    (laap (read port)))))))
      ;; load path
      (("-I" ?name (synopsis "Add <name> to the load path"))
       (set! *load-path* (cons name *load-path*)))
      ;; library path
      (("-lib-dir" ?name (synopsis "Set lib-path to <name>"))
       (set! *lib-dir* (list name)))
      (("-L" ?name (synopsis "Set additional library path"))
       (set! *lib-dir* (cons name *lib-dir*)))

;*--- Dialect options -------------------------------------------------*/
      (section "Dialect")
      ;; nil
      (("-nil" (synopsis "Evaluate '() as #f in `if' expression"))
       (set! *nil* #f))
      (("-call/cc" (synopsis "Enable call/cc function"))
       ;; -g3 and -call/cc are incompatible
       (if (>fx *compiler-debug* 2)
	   (set! *compiler-debug* 2))
       (set! *call/cc?* #t))
      (("-hygien" (synopsis "Enable r5rs macros"))
       (set! *hygien?* #t))
      ;; reflection
      (("-fno-reflection" (synopsis "Disable reflection code production"))
       (set! *reflection?* #f))
      (("+fno-reflection" (synopsis "Enable reflection code production"))
       (set! *reflection?* #t))
      ;; arithmetic
      (("-farithmetic"
	(synopsis "Suppress genericity of arithmetic operators"))
       (set! *genericity* #f))

;*--- verbosity -------------------------------------------------------*/
      (section "Verbosity")
      ;; silence
      (("-s" (synopsis "Be silent"))
       (set! *verbose* -1))
      ;; verbose
      (("-v" (synopsis "-v[23]" "Be verbose"))
       (set! *verbose* 1))
      (("-v2")
       (set! *verbose* 2))
      (("-v3")
       (set! *verbose* 3))
      (("-no-hello" (synopsis "Dont' say hello even in verbose mode"))
       (set! *hello* #f))
      (("-w" (synopsis "Inhibit all warning messages"))
       (set! *warning* #f))
      ;; warning
      (("-Wall" (synopsis "warn about all possible type errors"))
       (set! *warning* 2))

;*--- Back-end compilation and link -----------------------------------*/
      (section "Back-end and link")
      ;; The C compiler
      (("-cc" ?compiler (synopsis "Specify the C compiler"))
       (set! *cc* compiler))
      ;; ISO C
      (("-stdc" (synopsis "Generate strict ISO C code"))
       (set! *stdc* #t))
      ;; cc options
      (("-copt" ?string (synopsis "Invoke cc with <string>"))
       (set! *cc-options* (string-append *cc-options* " " string)))
      ;; link options
      (("-ldopt" ?string (synopsis "Invoke ld with <string>"))
       (set! *ld-options* (string-append string " " *ld-options*)))
      ;; static Bigloo library
      (("-static-bigloo"
	(synopsis "Link with the static bigloo library"))
       (set! *static-bigloo?* #t))
      ;; C library linking
      (("-l?library" (synopsis "Link with host library"))
       (set! *bigloo-user-lib* (cons (string-append "-l" library)
				     *bigloo-user-lib*)))

;*--- trace options ---------------------------------------------------*/
      (section "Traces")
      ;; traces
      (("-t" (synopsis "-t[2|3|4]" "Generate a trace file (*)"))
       (set! *trace-level* 1))
      (("-t2")
       (set! *trace-level* 2))
      (("-t3")
       (set! *trace-level* 3))
      (("-t4")
       (set! *trace-level* 4))
      (("+t?pass" (synopsis "Force pass to be traced"))
       (set! *additional-traces* (cons (string->symbol (string-upcase pass))
				       *additional-traces*)))
      ;; shape
      (("-shape?opt" (synopsis "-shape[mktalu]"
			       "Some debugging tools (private)"))
       (parse-shape-args opt))
      
;*--- Compiler stages -------------------------------------------------*/
      (section "Compilation stages")
      (("-syntax" (synopsis "Stop after the syntax stage (see -hygien)"))
       (set! *pass* 'syntax))
      (("-expand" (synopsis "Stop after the preprocessing stage"))
       (set! *pass* 'expand))
      (("-ast" (synopsis "Stop after the ast construction stage"))
       (set! *pass* 'ast))
      (("-bdb-spread-obj" (synopsis "Stop after the bdb obj spread stage"))
       (set! *pass* 'bdb-spread-obj))
      (("-trace" (synopsis "Stop after the trace pass"))
       (set! *pass* 'trace))
      (("-callcc" (synopsis "Stop after the callcc pass"))
       (set! *pass* 'callcc))
      (("-bivalue" (synopsis "Stop after the bivaluation stage"))
       (set! *pass* 'bivalue))
      (("-inline" (synopsis "Stop after the inlining stage"))
       (set! *pass* 'inline))
      (("-inline+" (synopsis "Stop after the 2nd inlining stage"))
       (set! *pass* 'inline+))
      (("-fail" (synopsis "Stop after the failure replacement stage"))
       (set! *pass* 'fail))
      (("-fuse" (synopsis "Stop after the fuse stage"))
       (set! *pass* 'fuse)) 
      (("-user" (synopsis "Stop after the user pass"))
       (set! *pass* 'user))
      (("-coerce" (synopsis "Stop after the type coercing stage"))
       (set! *pass* 'coerce))
      (("-effect" (synopsis "Stop after the effect stage"))
       (set! *pass* 'effect))
      (("-reduce" (synopsis "Stop after the reduction optimizations stage"))
       (set! *pass* 'reduce))
      (("-assert" (synopsis "Stop after the assertions stage"))
       (set! *pass* 'assert))
      (("-cfa" (synopsis "Stop after the cfa stage"))
       (set! *pass* 'cfa))
      (("-globalize" (synopsis "Stop after the globalization stage"))
       (set! *pass* 'globalize))
      (("-recovery" (synopsis "Stop after the type recovery stage"))
       (set! *pass* 'recovery))
      (("-bdb" (synopsis "Stop after the Bdb code production"))
       (set! *pass* 'bdb))
      (("-cnst" (synopsis "Stop after the constant allocation"))
       (set! *pass* 'cnst))
      (("-integrate" (synopsis "Stop after the integration stage"))
       (set! *pass* 'integrate))
      (("-hgen" (synopsis "Produce a C header file with class definitions"))
       (set! *pass* 'hgen))
      (("-cgen" (synopsis "Do not C compile and produce a .c file"))
       (set! *pass* 'cgen))
      (("-indent" (synopsis "Produce an indented .c file"))
       (set! *pass* 'cindent))
      (("-mco" (synopsis "Stop after .mco production"))
       (set! *module-checksum-object?* #t)
       (set! *pass* 'mco))

;*--- Constant initialization -----------------------------------------*/
      (section "Constant initialization")
      (("-init-lib" (synopsis "-init-<lib/read/intern>"
			      "Constants initialization mode"))
       (set! *init-mode* 'lib))
      (("-init-read")
       (set! *init-mode* 'read))
      (("-init-intern")
       (set! *init-mode* 'intern))

;*--- Private options -------------------------------------------------*/
      (section "Bootstrap and setup")
      ;; library construction
      (("-mklib" (synopsis "Compile a library module"))
       (set! *lib-mode* #t)
       (set! *init-mode* 'lib))
      ;; additional library construction
      (("-mkaddlib" (synopsis "Compile an additional library module"))
       (set! *init-mode* 'lib))
      ;; heap compilation
      (("-mkheap" (synopsis "Build an heap file"))
       (set! *pass* 'make-heap))
      ;; heap compilation
      (("-mkaddheap" (synopsis "Build an additional heap file"))
       (set! *pass* 'make-add-heap))
      ;; distribution compilation
      (("-mkdistrib" (synopsis "Compile a main file for a distribution"))
       (set! *pass* 'distrib))
      ;; Bigloo license
      (("-LICENSE" (synopsis "Add the license to the generated C files"))
       (set! *bigloo-licensing?* #t))
      ;; heap name
      (("-heap" ?name
		(synopsis "Specify an heap file (or #f to not load heap)"))
       (set! *heap-name* name))
      ;; additinal heap name
      (("-addheap" ?name (synopsis "Specify an additional heap file"))
       (set! *additional-heap-name* name))
      ;; the reader option
      (("-fread-internal" (synopsis "Read source from binary interned file"))
       (set! *reader* 'intern))
      (("-fread-plain" (synopsis "Read source from plain text file"))
       (set! *reader* 'plain))
      
;*--- Unknown arguments -----------------------------------------------*/
      (("-?dummy")
       (set! *rest-args* (cons the-arg *rest-args*)))
      
;*--- The source file -------------------------------------------------*/
      (else
       (let ((suf (suffix else)))
	  (cond 
	     ((and (string? suf)
		   (=fx (string-length suf) 0)
		   (null? *src-files*))
	      (set! *src-files* (list else)))
	     ((member suf *src-suffix*)
	      (set! *src-files* (cons else *src-files*)))
	     (*interpreter*
	      'ignore)
	     ((member suf *obj-suffix*)
	      (set! *o-files*  (cons else *o-files*)))
	     (else
	      (set! *rest-args* (cons else *rest-args*))))))))

;*---------------------------------------------------------------------*/
;*    parse-shape-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-shape-args string)
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (begin
	     (set! *module-shape?*   #t)
	     (set! *key-shape?*      #t)
	     (set! *type-shape?*     #t)
	     (set! *access-shape?*   #t)
	     (set! *location-shape?* #t)
	     (set! *user-shape?*     #t))
	  (let liip ((i 0))
	     (if (=fx i len)
		 'done
		 (begin
		    (case (string-ref string i)
		       ((#\m)
			(set! *module-shape?* #t))
		       ((#\k)
			(set! *key-shape?* #t))
		       ((#\t)
			(set! *type-shape?* #t))
		       ((#\a)
			(set! *access-shape?* #t))
		       ((#\l)
			(set! *location-shape?* #t))
		       ((#\u)
			(set! *user-shape?* #t))
		       (else
			(error "parse-arg" "Illegal -shape option" string)))
		    (liip (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    parse-unsafe-args ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-unsafe-args string)
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (begin
	     (set! *unsafe-library* #t)
	     (set! *unsafe-arity*   #t)
	     (set! *unsafe-type*    #t)
	     (set! *unsafe-struct*  #t)
	     (set! *unsafe-range*   #t)
	     (set! *unsafe-version* #t))
	  (let liip ((i 0))
	     (if (=fx i len)
		 'done
		 (begin
		    (case (string-ref string i)
		       ((#\r)
			(set! *unsafe-range* #t))
		       ((#\a)
			(set! *unsafe-arity* #t))
		       ((#\t)
			(set! *unsafe-type* #t))
		       ((#\s)
			(set! *unsafe-struct* #t))
		       ((#\v)
			(set! *unsafe-version* #t))
		       ((#\l)
			(set! *unsafe-library* #t))
		       (else
			(error "parse-arg" "Illegal -unsafe option" string)))
		    (liip (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    parse-optim-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-optim-args string)
   (define (-O2!)
      (if (not *c-debug*)
	  (set! *cc-options* (string-append *cc-options* " -O2")))
      '(set! *rgc-optim* #t))
   (define (-O3!)
      (-O2!)
      (if (not (boolean? *optim-inline-method?*))
	  (set! *optim-inline-method?* #t))
      (if (not (boolean? *optim-unroll-loop?*))
	  (set! *optim-unroll-loop?* #t)))
   (set! *optim* 1)
;*    (set! *rgc-optim* #f)                                            */
   (if (> (string-length string) 0)
       (case (string-ref string 0)
	  ((#\2)
	   (-O2!)
	   (set! *optim* 2))
	  ((#\3)
	   (-O3!)
	   (set! *optim* 3))
	  ((#\4 #\5 #\6)
	   (-O3!)
	   (set! *optim* (-fx (char->integer (string-ref string 0))
			      (char->integer #\0))))
	  (else
	   (error "parse-arg" "Illegal -O option" string)))
       (if (not *c-debug*)
	   (set! *cc-options* (string-append *cc-options* " -O")))))

;*---------------------------------------------------------------------*/
;*    query ...                                                        */
;*---------------------------------------------------------------------*/
(define (query)
   (version)
   (newline)
   (print "setups:")
   (newline)
   (print "*cc*                   : " *cc*)
   (print "*cc-options*           : " *cc-options*)
   (print "*ld-options*           : " *ld-options*)
   (print "*bigloo-lib*           : " *bigloo-lib*)
   (print "*bigloo-user-lib*      : " *bigloo-user-lib*)
   (print "*default-lib-dir*      : " *default-lib-dir*)
   (print "*lib-dir*              : " *lib-dir*)
   (print "*include-foreign*      : " *include-foreign*)
   (print "*heap-name*            : " *heap-name*)
   (newline)
   (print "Too see all variables enter the interpreter")
   (print "or use the -help2 option.")
   (exit-bigloo 0))
