;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Init/main.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:51:40 1993                          */
;*    Last change :  Wed Jun  3 13:13:00 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The main entry point.                                            */
;*=====================================================================*/
  
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_main
   (main main)
   (import init_setrc
	   init_parse-args
	   engine_engine
	   tools_trace)
   (export (exit-bigloo value)))

;*---------------------------------------------------------------------*/
;*    *exit-bigloo* ...                                                */
;*    -------------------------------------------------------------    */
;*    The default value of this variable is some kind of suicide       */
;*    value, an absolute emergency exit.                               */
;*---------------------------------------------------------------------*/
(define *exit-bigloo* (lambda (x) (exit x)))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   ;; Pour le moment il n'y a pas de error handler. Si une
   ;; erreur survient avant l'installation de celui-ci, on
   ;; quit bigloo
   (if (not (member "-q" argv)) (setup-default-values))
   (bind-exit (exit)
      (set! *exit-bigloo* exit)
      (unwind-protect
	 (if (parse-args argv)
	     (engine)
	     -1)
	 (stop-trace))))

;*---------------------------------------------------------------------*/
;*    exit-bigloo ...                                                  */
;*---------------------------------------------------------------------*/
(define (exit-bigloo value)
   (*exit-bigloo* value))

		       
