;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Heap/restore.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:53:23 1994                          */
;*    Last change :  Tue Dec 22 15:37:51 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We restore an heap                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module heap_restore
   (include "Engine/pass.sch")
   (export  (restore-heap)
	    (restore-additional-heaps))
   (import  engine_param
	    engine_engine
	    init_main
	    tools_file
	    tools_error
	    ast_env
	    type_type
	    type_env
	    ast_var))

;*---------------------------------------------------------------------*/
;*    restore-heap ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-heap)
   (if (string? *heap-name*)
       (begin
	  (pass-prelude "Heap")
	  (let ((fname (find-file/path *heap-name* *lib-dir*)))
	     (if (string? fname)
 		 (let* ((port    (open-input-binary-file fname))
			(handler (lambda (escape proc mes obj)
				    (notify-error proc mes obj)
				    (close-binary-port port)
				    (exit-bigloo -5))))
		    (if (not (binary-port? port))
			(begin
			   (error "restore-heap" "Cannot open heap file" fname)
			   (exit-bigloo -5))
			(begin
			   (verbose 2 "      [reading "
				    fname
				    "]" #\Newline)
			   (try (let* ((Envs (input-obj port))
				       (Genv (car Envs))
				       (Tenv (cdr Envs)))
				   (close-binary-port port)
				   (set-Genv! Genv)
				   (set-Tenv! Tenv)
				   (if (not *call/cc?*)
				       (unbind-call/cc!))
				   #t)
				handler))))
		 (begin
		    (error "restore-heap" "Cannot find heap file" *heap-name*)
		    (exit-bigloo -5)))))
       #f))

;*---------------------------------------------------------------------*/
;*    unbind-call/cc! ...                                              */
;*---------------------------------------------------------------------*/
(define (unbind-call/cc!)
   (if (find-global 'call/cc '__r4_control_features_6_9)
       (unbind-global! 'call/cc '__r4_control_features_6_9))
   (if (find-global 'call-with-current-continuation
		    '__r4_control_features_6_9)
       (unbind-global! 'call-with-current-continuation
		       '__r4_control_features_6_9)))

;*---------------------------------------------------------------------*/
;*    restore-additional-heaps ...                                     */
;*---------------------------------------------------------------------*/
(define (restore-additional-heaps)
   (if (pair? *additional-heap-names*)
       (pass-prelude "Library"))
   (for-each restore-additional-heap *additional-heap-names*))

;*---------------------------------------------------------------------*/
;*    restore-additional-heap ...                                      */
;*---------------------------------------------------------------------*/
(define (restore-additional-heap heap)
   (let ((fname (find-file/path heap *lib-dir*)))
      (if (string? fname)
	  (let* ((port    (open-input-binary-file fname))
		 (handler (lambda (escape proc mes obj)
			     (notify-error proc mes obj)
			     (close-binary-port port)
			     (exit-bigloo -6))))
	     (if (not (binary-port? port))
		 (begin
		    (error "restore-additional-heap"
			   "Cannot open heap file"
			   fname)
		    (exit-bigloo -6))
		 (begin
		    (verbose 2 "      [reading "
			     fname
			     "]" #\Newline)
		    (try (let* ((Envs     (input-obj port))
				(Genv     (vector-ref Envs 0))
				(Tenv     (vector-ref Envs 1))
				(includes (vector-ref Envs 2)))
			    (close-binary-port port)
			    (add-Tenv! Tenv)
			    (add-Genv! Genv)
			    (set! *additional-include-foreign*
				  (append *additional-include-foreign*
					  includes))
			    #t)
			 handler))))
	  (begin
	     (error "restore-additional-heap" "Cannot find heap file" heap)
	     (exit-bigloo -6)))))


