;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Heap/make.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  8 08:44:08 1995                          */
;*    Last change :  Sat Dec 19 14:50:58 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The creation of a library heap                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module heap_make
   (include "Engine/pass.sch")
   (import  engine_param
	    tools_error
	    type_type
	    type_env
	    ast_var
	    ast_env)
   (import  tools_shape)
   (export  (make-heap)
	    (make-add-heap)))

;*---------------------------------------------------------------------*/
;*    make-heap ...                                                    */
;*---------------------------------------------------------------------*/
(define (make-heap)
   (pass-prelude "Heap" prepare-globals!)
   (set-obj-string-mode! 'pair)
   (if (not (string? *heap-name*))
       (user-error "make-heap" "Illegal heap's name" *heap-name*)
       (let ((hname (make-file-name (car *lib-dir*) *heap-name*)))
	  (let ((port (open-output-binary-file hname)))
	     (if (not (binary-port? port))
		 (error "make-heap" "Can't open output port" hname)
		 (begin
		    (output-obj port (cons (get-Genv) (get-Tenv)))
		    (close-binary-port port)))))))

;*---------------------------------------------------------------------*/
;*    prepare-globals! ...                                             */
;*    -------------------------------------------------------------    */
;*    Before making a heap, we reset all the occurrence slots and for  */
;*    each exported variable, we declare it as imported. We remove     */
;*    static variables.                                                */
;*---------------------------------------------------------------------*/
(define (prepare-globals!)
   (for-each-global! (lambda (g)
			;; we set importation slots
			(cond
			   ((eq? (global-import g) 'static)
			    (unbind-global! (global-id g) (global-module g)))
			   ((eq? (global-import g) 'export)
			    (global-import-set! g 'import))
			   (else
			    #unspecified))
			;; and occurrence ones
			(global-occurrence-set! g 0)))
   #t)

;*---------------------------------------------------------------------*/
;*    make-add-heap ...                                                */
;*---------------------------------------------------------------------*/
(define (make-add-heap)
   (pass-prelude "Library heap" prepare-additional-globals!)
   (set-obj-string-mode! 'pair)
   (if (not (string? *additional-heap-name*))
       (user-error "make-add-heap"
		   "Illegal heap's name"
		   *additional-heap-name*)
       (let ((hname *additional-heap-name*))
	  (let ((port (open-output-binary-file hname)))
	     (if (not (binary-port? port))
		 (error "make-addd-heap" "Can't open output port" hname)
		 (begin
		    (output-obj port (vector (get-Genv)
					     (get-Tenv)
					     *additional-include-foreign*))
		    (close-binary-port port)))))))

;*---------------------------------------------------------------------*/
;*    prepare-additional-globals! ...                                  */
;*    -------------------------------------------------------------    */
;*    Before making an additional heap, we reset all the occurrence    */
;*    slots and for each exported variable, we declare it as imported. */
;*    We remove static variables and library variables.                */
;*---------------------------------------------------------------------*/
(define (prepare-additional-globals!)
   (for-each-global! (lambda (g)
			;; we set importation slots
			(cond
			   ((or (eq? (global-import g) 'static)
				(global-library? g))
			    (unbind-global! (global-id g) (global-module g)))
			   ((eq? (global-import g) 'export)
			    (global-import-set! g 'import))
			   (else
			    #unspecified))
			;; and occurrence ones
			(global-occurrence-set! g 0)))
   #t)
