;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Globalize/ginfo.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 21 09:03:24 1996                          */
;*    Last change :  Mon Jun 24 08:58:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The definition of the info structures for the globalization      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_ginfo
   
   (include "Ast/node.sch")
   
   (export  (wide-class sfun/Ginfo::sfun
	       ;; is a function globalized
	       (G?::bool (default #f))
	       ;; the list of called by functions
	       (cfrom (default '()))
	       ;; transitive closure of cfrom
	       (cfrom* (default #f))
	       ;; the list of called functions
	       (cto (default '()))
	       ;; transitive closure of cto
	       (cto* (default #f))
	       ;; the list of E functions
	       (cfunction (default '()))
	       ;; a place to be integrated
	       (integrator (default '()))
	       ;; a list a integrated functions
	       (integrated (default '()))
	       ;; where is it plugged
	       (plugged-in (default '()))
	       ;; a mark for the integration
	       (mark::long (default -10))
	       ;; a free search mark
	       (free-mark (default '()))
	       ;; the globalized function
	       (the-global (default #f))
	       ;; the kaptured variables
	       (kaptured (default #f))
	       ;; a globalized new-body
	       (new-body (default #f))
	       ;; used in `globalize_new-body'
	       (bmark::long (default -10))
	       ;; union mark
	       (umark::long (default -10))
	       ;; the free variable list
	       (free (default #unspecified))
	       ;; the bound variable list
	       (bound (default '())))

	    (wide-class svar/Ginfo::svar
	       ;; is the variable kaptured
	       (kaptured?::bool (default #f))
	       ;; a free-mark
	       (free-mark::long (default -10))
	       ;; a mark
	       (mark::long (default -10))
	       ;; celled ?
	       (celled?::bool (default #f)))

	    (wide-class sexit/Ginfo::sexit
	       ;; is a function globalized
	       (G?::bool (default #f))
	       ;; is the variable kaptured
	       (kaptured?::bool (default #f))
	       ;; a free-mark
	       (free-mark::long (default -10))
	       ;; a mark
	       (mark::long (default -10)))

	    (wide-class local/Ginfo::local
	       ;; is the local function escaping ?
	       (escape?::bool (default #f)))
	    
	    (wide-class global/Ginfo::global
	       ;; is the global function escaping ?
	       (escape?::bool (default #f))
	       ;; associated closure
	       (global-closure (default #f)))))
	    
   
	       
