;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Globalize/escape.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 21 09:02:16 1996                          */
;*    Last change :  Thu Apr  9 08:23:00 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The escape property computation                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_escape
   (import  tools_shape
	    type_type
	    engine_param
	    ast_var 
	    ast_node
	    globalize_ginfo)
   (export  (generic escape-fun! ::variable)))

;*---------------------------------------------------------------------*/
;*    define-generic ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (escape-fun! variable::variable)
   (let ((fun (variable-value variable)))
      (for-each (lambda (local)
		   (widen!::svar/Ginfo (local-value local)))
		(sfun-args fun))
      (widen!::sfun/Ginfo fun)
      (escape! (sfun-body fun))))

;*---------------------------------------------------------------------*/
;*    escape-fun! ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (escape-fun! variable::global)
   (if (not (global/Ginfo? variable))
       (widen!::global/Ginfo variable
	  (escape? (eq? (global-import variable) 'export))))
   (call-next-method))

;*---------------------------------------------------------------------*/
;*    escape-fun! ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (escape-fun! variable::local)
   (if (not (local/Ginfo? variable))
       (widen!::local/Ginfo variable))
   (call-next-method))

;*---------------------------------------------------------------------*/
;*    set-escaping-fun! ::variable ...                                 */
;*---------------------------------------------------------------------*/
(define-generic (set-escaping-fun! variable::variable)
   (error "set-escaping-fun!"
	  "Illegal variable"
	  (cons variable (shape variable))))

;*---------------------------------------------------------------------*/
;*    set-escaping-fun! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (set-escaping-fun! variable::global)
   (widen!::global/Ginfo variable (escape? #t)))

;*---------------------------------------------------------------------*/
;*    set-escaping-fun! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (set-escaping-fun! variable::global/Ginfo)
   (global/Ginfo-escape?-set! variable #t))

;*---------------------------------------------------------------------*/
;*    set-escaping-fun! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (set-escaping-fun! variable::local/Ginfo)
   (local/Ginfo-escape?-set! variable #t))

;*---------------------------------------------------------------------*/
;*    escape! ...                                                      */
;*---------------------------------------------------------------------*/
(define-generic (escape! node::node))

;*---------------------------------------------------------------------*/
;*    escape! ::atom ...                                               */
;*---------------------------------------------------------------------*/
(define-method (escape! node::atom)
   'done)

;*---------------------------------------------------------------------*/
;*    escape! ::kwote ...                                              */
;*---------------------------------------------------------------------*/
(define-method (escape! node::kwote)
   'done)

;*---------------------------------------------------------------------*/
;*    escape! ::var ...                                                */
;*---------------------------------------------------------------------*/
(define-method (escape! node::var)
   'done)

;*---------------------------------------------------------------------*/
;*    escape! ::closure ...                                            */
;*---------------------------------------------------------------------*/
(define-method (escape! node::closure)
   (set-escaping-fun! (closure-variable node)))

;*---------------------------------------------------------------------*/
;*    escape! ::sequence ...                                           */
;*---------------------------------------------------------------------*/
(define-method (escape! node::sequence)
   (escape*! (sequence-nodes node)))

;*---------------------------------------------------------------------*/
;*    escape! ::app ...                                                */
;*---------------------------------------------------------------------*/
(define-method (escape! node::app)
   (with-access::app node (args)
      (escape*! args)))
 
;*---------------------------------------------------------------------*/
;*    escape! ::app-ly ...                                              */
;*---------------------------------------------------------------------*/
(define-method (escape! node::app-ly)
   (with-access::app-ly node (fun arg)
      (escape! fun)
      (escape! arg)))

;*---------------------------------------------------------------------*/
;*    escape! ::funcall ...                                            */
;*---------------------------------------------------------------------*/
(define-method (escape! node::funcall)
   (with-access::funcall node (fun args)
      (escape! fun)
      (escape*! args)))

;*---------------------------------------------------------------------*/
;*    escape! ::pragma ...                                             */
;*---------------------------------------------------------------------*/
(define-method (escape! node::pragma)
   (escape*! (pragma-args node)))

;*---------------------------------------------------------------------*/
;*    escape! ::cast ...                                               */
;*---------------------------------------------------------------------*/
(define-method (escape! node::cast)
   (escape! (cast-arg node)))

;*---------------------------------------------------------------------*/
;*    escape! ::setq ...                                               */
;*---------------------------------------------------------------------*/
(define-method (escape! node::setq)
   (with-access::setq node (value)
      (escape! value)))

;*---------------------------------------------------------------------*/
;*    escape! ::conditional ...                                        */
;*---------------------------------------------------------------------*/
(define-method (escape! node::conditional)
   (with-access::conditional node (test true false)
       (escape! test)
       (escape! true)
       (escape! false)))

;*---------------------------------------------------------------------*/
;*    escape! ::fail ...                                               */
;*---------------------------------------------------------------------*/
(define-method (escape! node::fail)
   (with-access::fail node (proc msg obj)
      (escape! proc)
      (escape! msg)
      (escape! obj)))

;*---------------------------------------------------------------------*/
;*    escape! ::select ...                                             */
;*---------------------------------------------------------------------*/
(define-method (escape! node::select)
   (with-access::select node (clauses test)
      (escape! test)
      (for-each (lambda (clause)
		   (escape! (cdr clause)))
		clauses)))

;*---------------------------------------------------------------------*/
;*    escape! ::let-fun ...                                            */
;*    -------------------------------------------------------------    */
;*    We cannot use the `escape-fun!' function because all the         */
;*    functions need to be widened before we scan the bodies. Hence,   */
;*    a fully ad-hoc function is preferable.                           */
;*---------------------------------------------------------------------*/
(define-method (escape! node::let-fun)
   (with-access::let-fun node (body locals)
      ;; first, we enlarge all defined functions
      (for-each (lambda (local)
		   (widen!::local/Ginfo local)
		   (let ((fun (local-value local)))
		      (widen!::sfun/Ginfo fun)
		      (for-each (lambda (local)
				   (widen!::svar/Ginfo (local-value local)))
				(sfun-args fun))))
		locals)
      ;; then, we scan the bodies
      (for-each (lambda (local)
		   (let ((fun (local-value local)))
		      (escape! (sfun-body fun))))
		locals)
      ;; and we scan the body of the labels.
      (escape! body)))

;*---------------------------------------------------------------------*/
;*    escape! ::let-var ...                                            */
;*---------------------------------------------------------------------*/
(define-method (escape! node::let-var)
   (with-access::let-var node (body bindings)
      (escape! body)
      (for-each (lambda (binding)
		   (widen!::svar/Ginfo (local-value (car binding)))
		   (escape! (cdr binding)))
		bindings)))

;*---------------------------------------------------------------------*/
;*    escape! ::set-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (escape! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (widen!::sexit/Ginfo (local-value (var-variable var)))
      (escape! body)))

;*---------------------------------------------------------------------*/
;*    escape! ::jump-ex-it ...                                         */
;*---------------------------------------------------------------------*/
(define-method (escape! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (escape! exit) 
      (escape! value)))

;*---------------------------------------------------------------------*/
;*    escape! ::make-box ...                                           */
;*---------------------------------------------------------------------*/
(define-method (escape! node::make-box)
   (escape! (make-box-value node)))

;*---------------------------------------------------------------------*/
;*    escape! ::box-set! ...                                           */
;*---------------------------------------------------------------------*/
(define-method (escape! node::box-set!)
   (with-access::box-set! node (value)
      (escape! value)))

;*---------------------------------------------------------------------*/
;*    escape! ::box-ref ...                                            */
;*---------------------------------------------------------------------*/
(define-method (escape! node::box-ref)
   (with-access::box-ref node (var)
      (escape! var)))

;*---------------------------------------------------------------------*/
;*    escape*! ...                                                     */
;*---------------------------------------------------------------------*/
(define (escape*! node*)
   (for-each escape! node*))


