;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Globalize/clocto.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 23 14:03:24 1996                          */
;*    Last change :  Wed Apr  1 13:35:34 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The transitive closure of the `cto' property.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_clocto
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    globalize_ginfo
	    globalize_kapture)
   (export  (cto-transitive-closure! ::local)))

;*---------------------------------------------------------------------*/
;*    cto-transitive-closure ...                                       */
;*    -------------------------------------------------------------    */
;*    In this function, we use the cto* field in two different         */
;*    ways:                                                            */
;*       a- for the host function, this field will contain the list    */
;*          of the called function.                                    */
;*       b- for the callee function non globalized function, this      */
;*          field is used as a mark in order to not enter twice in     */
;*          the same function.                                         */
;*---------------------------------------------------------------------*/
(define (cto-transitive-closure! host)
   (let* ((info      (local-value host))
	  (cto       (append (sfun/Ginfo-cto info)
			     (sfun/Ginfo-cfunction info)))
	  (cto*-orig (list cto)))
      (let loop ((cto  cto)
		 (cto* cto*-orig))
	 (cond
	    ((null? cto)
	     (sfun/Ginfo-cto*-set! info
				  (if (eq? cto* cto*-orig)
				      (car cto*-orig)
				      (union cto*))))
	    ((eq? (car cto) local)
	     (loop (cdr cto) cto*))
	    ((sfun/Ginfo-G? (local-value (car cto)))
	     (loop (cdr cto) cto*))
	    ((sfun/Ginfo-cto* (local-value (car cto)))
	     ;; we have already processed this function
	     (loop (cdr cto) cto*))
	    (else
	     (let ((callee (append
			    (sfun/Ginfo-cto (local-value (car cto)))
			    (sfun/Ginfo-cfunction (local-value (car cto))))))
		;; we mark the function has processed
		(sfun/Ginfo-cto*-set! (local-value (car cto)) #t)
		;; and we loop
		(loop (append (cdr cto) callee)
		      (cons callee cto*))))))))
