;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Foreign/cenum.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun  6 12:23:13 1996                          */
;*    Last change :  Thu Apr  3 16:22:24 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C enum accessors creations                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module foreign_cenum
   (import tools_misc
	   type_tools
	   type_type
	   foreign_ctype
	   foreign_access
	   module_module))
   
;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cenum ...                                 */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cenum who::type)
   (let* ((btype       (cenum-btype what))
	  (id          (type-id who))
	  (wid         (type-id what))
	  (bid         (type-id btype))
	  (id->bid     (symbol-append id '-> bid))
	  (bid->id     (symbol-append bid '-> id))
	  (bid?        (symbol-append id '?))
	  (bid?-bool   (symbol-append bid? '::bool))
	  (name        (type-name who))
	  (name-sans-$ (string-sans-$ name))
	  (literals    (cenum-literals what)))

      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (mk-id->bid)
	 `(macro ,bid ,id->bid (symbol ,id) "cobj_to_foreign"))

      (define (mk-bid->id)
	 (let ((mname (string-append "(" name-sans-$ ")FOREIGN_TO_COBJ")))
	    `(macro ,id ,bid->id (,bid) ,mname)))

      ;; the predicate
      (define (mk-bid?)
	 `(define-inline (,bid?-bool o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bid)
		 #f)))

      ;; equality (using ==)
      (define (mk-=id)
	 `(define-inline (,(symbol-append '= id '?::bool)
			  ,(symbol-append 'o1 4dots id)
			  ,(symbol-append 'o2 4dots id))
	     (pragma::bool "($1 == $2)" o1 o2)))
      
      ;; literals accessors
      (define (literal-accessors)
	 (let loop ((literals literals)
		    (res      '()))
	    (if (null? literals)
		res
		(let* ((literal      (car literals))
		       (literal-id   (car literal))
		       (literal-name (cadr literal))
		       (access-id    (symbol-append id '- literal-id))
		       (access       `(define-inline (,(symbol-append
							access-id
							4dots
							wid))
					 (,(symbol-append 'pragma 4dots wid)
					  ,literal-name))))
		   (loop (cdr literals)
			 (cons access res))))))

      ;; we declare the coercion operations ...
      (produce-module-clause! `(foreign ,(mk-id->bid) ,(mk-bid->id)))
      ;; and the predicate
      (produce-module-clause! `(static (inline ,bid?-bool ::obj)))
      (produce-module-clause! `(pragma (,bid? (predicate-of ,wid))))

      ;; and we return the built code
      (cons* (mk-=id) (mk-bid?) (literal-accessors))))


