;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/syntax.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 14:56:58 1994                          */
;*    Last change :  Sat Feb 28 18:58:54 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The r5rs syntax expansion.                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_syntax-case
   (include "Tools/trace.sch"
	    "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  tools_speek
	    tools_error)
   (export  (syntax-expand-units ::obj)))

;*---------------------------------------------------------------------*/
;*    syntax-expand-units ...                                          */
;*    -------------------------------------------------------------    */
;*    We expand the user code and the produced codes.                  */
;*---------------------------------------------------------------------*/
(define (syntax-expand-units units)
   (pass-prelude "Syntax")
   (define handler (lambda (escape proc mes obj)
		      (user-error proc mes obj ''())))
   ;; we scan all units
   (for-each (lambda (unit)
		(if (procedure? (unit-sexp* unit))
		    ;; a freezed unit (such as the eval unit)
		    ;; cannot be macro expanser.
		    'nothing
		    (let loop ((src (unit-sexp* unit))
			       (res '()))
		       (if (null? src)
			   (unit-sexp*-set! unit (reverse! res))
			   (let ((new-body (try (expand-syntax (car src))
						handler)))
			      (loop (cdr src) (cons new-body res)))))))
	     units)
   (pass-postlude units))
      
