;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/let.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 19 08:29:58 1992                          */
;*    Last change :  Fri Apr 10 16:54:21 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Let expansions.                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_let
   (import  tools_progn
	    tools_args
	    tools_misc
	    expand_lambda
	    expand_eps)
   (export  (expand-let*   ::obj ::procedure)
	    (expand-let    ::obj ::procedure)
	    (expand-letrec ::obj ::procedure)
	    (expand-labels ::obj ::procedure)))
 
;*---------------------------------------------------------------------*/
;*    expand-let* ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-let* x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e `(let () ,(normalize-progn body)) e))
		     ((?- ?bindings . (and ?body (not ())))
		      (e `(let (,(car bindings))
			     (let* ,(cdr bindings)
				,(normalize-progn body))) e))
		     (else
		      (error #f "Illegal `let*' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-let ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-let x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      ;; we must let the construction (to uses with
		      ;; traces).
		      `(let () ,(e (normalize-progn body) e)))
		     ((?- (and (? symbol?) ?loop)
			  ?bindings . (and ?body (not ())))
		      (if (not (or (null? bindings)
				   (pair? bindings)))
			  (error #f "Illegal `let' form" x)
			  (e `(labels ((,loop ,(map
						(lambda (b)
						   (if (pair? b)
						       (car b)
						       (error
							#f
							"Illegal `let' form"
							x)))
						bindings)
					      ,@body))
				 (,loop ,@(map (lambda (b)
						  (normalize-progn (cdr b)))
					       bindings)))
			     e)))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      `(let ,(let loop ((bindings bindings)
					(acc      '()))
				(if (null? bindings)
				    (reverse! acc)
				    (let ((pr (car bindings)))
				       (cond
					  ((not (pair? pr))
					   (loop (cdr bindings)
						 (cons (list
							pr
							'(unspecified))
						       acc)))
					  ((not (and (pair? (cdr pr))
						     (null? (cddr pr))))
					   (error #f "Illegal `let' form" x))
					  (else
					   (let ((bd (list 
						      (car pr)
						      (e (normalize-progn
							  (cdr pr))
							 e))))
					      (replace! pr bd)
					      (loop (cdr bindings)
						    (cons pr acc))))))))
			  ,(with-lexical
			    (map (lambda (v) (if (pair? v) (car v) v))
				 bindings)
			    '_
			    (lambda ()
			       (e (normalize-progn body) e)))))
		     (else
		      (error #f "Illegal `let' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-letrec ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-letrec x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (set-car! x 'let)
		      (e x e))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map (lambda (v) (if (pair? v) (car v) v)) bindings)
		       '_
		       (lambda ()
			  `(letrec ,(let loop ((bindings bindings)
					       (acc      '()))
				       (if (null? bindings)
					   (reverse! acc)
					   (let ((pr (car bindings)))
					      (if (not (pair? pr))
						  (error
						   #f
						   "Illegal `letrec' form"
						   x)
						  (let ((nb (list
							     (car pr)
							     (e (normalize-progn
								 (cdr pr))
								e))))
						     (replace! pr nb)
						     (loop
						      (cdr bindings)
						      (cons pr acc)))))))
			      ,(e (normalize-progn body) e)))))
		     (else
		      (error #f "Illegal `letrec' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
	 
;*---------------------------------------------------------------------*/
;*      expand-labels ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-labels x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (set-car! x 'let)
		      (e x e))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map (lambda (b)
			       (if (or (not (pair? b)) (not (symbol? (car b))))
				   (error #f
					  "Illegal `labels' form"
					  x)
				   (car b)))
			    bindings)
		       '_
		       (lambda ()
			  (let ((new
				 (let loop ((bindings bindings))
				    (cond
				       ((null? bindings)
					'())
				       ((not (pair? bindings))
					(error #f
					       "Illegal `labels' form"
					       x))
				       (else
					(match-case (car bindings)
					   ((?name ?args . ?lbody)
					    (with-lexical
					     (args*->args-list args)
					     '_
					     (lambda ()
						(cons
						 `(,name
						   ,args
						   ,(e (normalize-progn lbody)
						       e))
						 (loop (cdr bindings))))))
					   (else
					    (error #f
						   "Illegal `labels' form"
						   x))))))))
			     `(labels ,new ,(e (normalize-progn body) e))))))
		     (else
		      (error #f "Illegal `labels' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
