;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/farith.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 23 16:05:55 1995                          */
;*    Last change :  Fri May  8 06:35:56 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The flonum expanders.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_farithmetique
   (import type_type
	   ast_ident)
   (export (expand-fmax  ::obj ::procedure)
	   (expand-fmin  ::obj ::procedure)
	   (expand-fatan ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-fmax ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-fmax x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (real? x) (real? y))
	   (maxfl x y))
	  (else
	   (e `(max-2fl ,x ,y) e))))
      ((?- ?x . ?y)
       (let ((max (mark-symbol-non-user! (gensym 'max))))
	  (e `(let ((,max (max-2fl ,x ,(car y))))
		 (maxfl ,max ,@y))
	     e)))))

;*---------------------------------------------------------------------*/
;*    expand-fmin ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-fmin x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (real? x) (real? y))
	   (minfl x y))
	  (else
	   (e `(min-2fl ,x ,y) e))))
      ((?- ?x . ?y)
       (let ((min (mark-symbol-non-user! (gensym 'min))))
	  (e `(let ((,min (min-2fl ,x ,(car y))))
		 (minfl ,min ,@y))
	     e)))))

;*---------------------------------------------------------------------*/
;*    expand-fatan ...                                                 */
;*---------------------------------------------------------------------*/
(define (expand-fatan x e)
   (match-case x
      ((?- . (?x . ()))
       (if (real? x)
	   (atanfl x)
	   (e `(atan-1fl ,x) e)))
      ((?- ?x . (?y . ()))
       (if (and (real? x) (real? y))
	   (atanfl x y)
	   (e `(atan-2fl ,x ,y) e)))
      (else
       (error '() "Too many arguments provided" x))))
      

