;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Expand/expander.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 16:05:29 1994                          */
;*    Last change :  Thu Nov  6 12:06:33 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The O-expander creation.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_expander
   (include "Expand/expander.sch")
   (import  tools_error
	    engine_param)
   (export  (initialize-Oenv!)
	    (install-O-comptime-expander ::symbol ::procedure)
	    (find-O-expander             ::symbol)
	    (unbind-O-expander!          ::symbol)))

;*---------------------------------------------------------------------*/
;*    *Oenv* ...                                                       */
;*---------------------------------------------------------------------*/
(define *Oenv* '())

;*---------------------------------------------------------------------*/
;*    initialize-Oenv! ...                                             */
;*---------------------------------------------------------------------*/
(define (initialize-Oenv!)
   (set! *Oenv* (make-hash-table 4096
				 (lambda (o)
				    (string->0..2^x-1 (symbol->string o)
						      12))
				 expander-name
				 eq?
				 1024)))

;*---------------------------------------------------------------------*/
;*    install-O-comptime-expander ...                                  */
;*    -------------------------------------------------------------    */
;*    Les O-expanders sont des expanseurs d'optimisation. La difference*/
;*    avec les expanseurs normaux est que si une fonction portent le   */
;*    meme nom qu'eux, il sont retires de l'environment.               */
;*---------------------------------------------------------------------*/
(define (install-O-comptime-expander keyword function)
   (if (expander? (find-O-expander keyword))
       (internal-error "install-O-comptime-expander"
		       "Illegal re-installation of O-expander"
		       keyword)
       (let ((new (expander keyword function)))
	  (put-hash! new *Oenv*)
	  new)))

;*---------------------------------------------------------------------*/
;*    find-O-expander ...                                              */
;*    -------------------------------------------------------------    */
;*    We look for O-expander iff the variable *optim-O-macro?* has     */
;*    been set to #t.                                                  */
;*---------------------------------------------------------------------*/
(define (find-O-expander symbol)
   (and *optim-O-macro?* (get-hash symbol *Oenv*)))

;*---------------------------------------------------------------------*/
;*    unbind-O-expander! ...                                           */
;*---------------------------------------------------------------------*/
(define (unbind-O-expander! symbol)
   (rem-key-hash! symbol *Oenv*))
