;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/eps.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 14:56:58 1994                          */
;*    Last change :  Sat May 23 20:16:35 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The macro expanser inspired by:                                  */
;*    << Expansion-Passing Style: Beyond Conventional Macro >>,        */
;*    Dybvig, Friedman & Haynes  -- ACM 1986 (LFP) page 143            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_eps
   (include "Expand/expander.sch"
	    "Tools/trace.sch"
	    "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  tools_speek
	    tools_error
	    tools_progn
	    type_type
	    ast_ident
	    expand_expander)
   (export  (with-lexical          ::obj ::obj ::procedure)
	    (lexical-stack)
	    (add-macro-definition! ::obj)
	    (comptime-expand       ::obj)
	    (comptime-expand-once  ::obj)
	    (expand-units          ::obj)))

;*---------------------------------------------------------------------*/
;*    The user macro list.                                             */
;*---------------------------------------------------------------------*/
(define *macro* '())

;*---------------------------------------------------------------------*/
;*    add-macro! ...                                                   */
;*---------------------------------------------------------------------*/
(define (add-macro-definition! form)
   (set! *macro* (cons form *macro*)))

;*---------------------------------------------------------------------*/
;*    *lexical-stack* ...                                              */
;*    -------------------------------------------------------------    */
;*    This global variable allow us to simulate a stack to know        */
;*    when a variable `over-define' a `O-macro'. It is not as          */
;*    beautiful as a extra parameter to `expand' but it is             */
;*    easier to implement.                                             */
;*---------------------------------------------------------------------*/
(define *lexical-stack* '())

;*---------------------------------------------------------------------*/
;*    lexical-stack ...                                                */
;*---------------------------------------------------------------------*/
(define (lexical-stack)
   *lexical-stack*)

;*---------------------------------------------------------------------*/
;*    with-lexical ...                                                 */
;*---------------------------------------------------------------------*/
(define (with-lexical new mark thunk)
   (let ((new-id (map fast-id-of-id new))
	 (old-lexical-stack *lexical-stack*))
      (set! *lexical-stack*
	    (append (map (lambda (o) (cons o mark)) new-id) *lexical-stack*))
      (let ((res (thunk)))
	 (set! *lexical-stack* old-lexical-stack)
	 res)))
    
;*---------------------------------------------------------------------*/
;*    expand-units ...                                                 */
;*    -------------------------------------------------------------    */
;*    We expand the user code and the produced codes.                  */
;*---------------------------------------------------------------------*/
(define (expand-units units)
   (pass-prelude "Expand")
   ;; We set all macros definitions seen in include files.
   (for-each comptime-expand (reverse! *macro*))
   ;; imported inlined functions which are not coming from library
   ;; have to be expanded. It is not obliged to perform macro-expansion
   ;; on library functions because they have alredy been expanded.
   (define handler (lambda (escape proc mes obj)
		      (escape (user-error proc mes obj ''()))))
   ;; we scan all units
   (for-each (lambda (unit)
		(if (procedure? (unit-sexp* unit))
		    ;; a freezed unit (such as the eval unit)
		    ;; cannot be macro expanser.
		    'nothing
		    (let loop ((src (unit-sexp* unit))
			       (res '()))
		       (if (null? src)
			   (unit-sexp*-set! unit (reverse! res))
			   (match-case (car src)
			      ((define-macro . ?-)
			       (try (comptime-expand (car src)) handler)
			       (loop (cdr src) res))
			      ((define-expander . ?-)
			       (try (comptime-expand (car src)) handler)
			       (loop (cdr src) res))
			      (else
			       (let ((new-body (try (comptime-expand (car src))
						    handler)))
				  (loop (cdr src) (cons new-body res)))))))))
	     units)
   (pass-postlude units))
      
;*---------------------------------------------------------------------*/
;*    comptime-expand ...                                              */
;*---------------------------------------------------------------------*/
(define (comptime-expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    (comptime-expand-once ...                                        */
;*---------------------------------------------------------------------*/
(define (comptime-expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e::procedure)
   (trace expand "initial-expander: " x #\Newline)
   (let ((e1::procedure (cond
			   ((symbol? x)
			    *identifier-expander*)
			   ((null? x)
			    (error #f "Illegal form" '()))
			   ((not (pair? x))
			    (lambda (x e) x))
			   ((symbol? (car x))
			    (let ((id (fast-id-of-id (car x))))
			       (let (b)
				  (cond
				     ((begin
					 (set! b (get-compiler-expander id))
					 b)
				      b)
				     ((begin
					 (set! b (get-eval-expander id))
					 b)
				      b)
				     ((pair? (assq id (lexical-stack)))
				      *application-expander*)
				     ((begin
					 (set! b (find-O-expander id))
					 b)
				      (expander-expander b))
				     (else
				      *application-expander*)))))
			   (else
			    *application-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    *identifier-expander* ...                                        */
;*---------------------------------------------------------------------*/
(define (*identifier-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-expander* ...                                       */
;*---------------------------------------------------------------------*/
(define (*application-expander* x e)
   (let loop ((x* x))
      (cond
	 ((pair? x*)
	  (set-car! x* (e (car x*) e))
	  (set-cdr! x* (loop (cdr x*)))
	  x*)
	 ((null? x*)
	  '())
	 (else
	  (error #f "Illegal form" x)))))
