;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/assert.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  9 16:41:17 1993                          */
;*    Last change :  Tue Jun  9 23:01:38 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'expansion des formes `assert'                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_assert
   (include "Tools/location.sch")
   (import  engine_param
	    tools_misc
	    tools_progn
	    tools_location)
   (export  (expand-assert ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-assert ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-assert x e)
   (match-case x
      ((?- check (and ?vars (? pair?)) . ?body)
       ;; this is the old (1.7) style to introduce assertion
       (let ((new `(assert ,vars ,@body)))
	  (replace! x new)
	  (e x e)))
      ((?- (and ?vars (? list?)) . ?pred)
       (if (and (integer? *compiler-debug*) (>=fx *compiler-debug* 1))
	   (let ((new (make-one-assert e x vars pred)))
	      (replace! x new))
	   #unspecified))
      (else
       (error #f "Illegal `assert' form" x))))
 
;*---------------------------------------------------------------------*/
;*    make-one-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-one-assert e exp vars pred)
   (let ((old-pred (dup pred)))
      `(if ,(e (normalize-progn pred) e)
	   #unspecified
	   (begin
	      ;; we send all vars to the interpreters
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(define-primop-ref! ',(car vars)
				       ((@ __evmeaning_address foreign)
					,(car vars)))
				   defs))))
	      ,(let ((loc (let ((loc (find-location exp)))
			     (if (location? loc)
				 loc
				 (find-location pred)))))
		  `(notify-assert-fail ',vars
				       ',(cons 'begin old-pred)
				       ,(if (location? loc)
					    `',(cons (location-full-fname loc)
						     (location-pos loc))
					    #f)))
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(unbind-primop! ',(car vars))
				   defs))))))))

;*---------------------------------------------------------------------*/
;*    dup ...                                                          */
;*---------------------------------------------------------------------*/
(define (dup pred)
   (cond
      ((pair? pred)
       (cons (dup (car pred)) (dup (cdr pred))))
      (else
       pred)))


