;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Engine/signals.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 13 09:50:26 1994                          */
;*    Last change :  Mon Jun 10 07:56:33 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On recupere tous les signaux pour ne plus avoir de message       */
;*    intenpestifs.                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_signals
   (import  init_main
	    engine_param)
   (foreign (include "signal.h"))
   (export  (install-compiler-signals!)))

;*---------------------------------------------------------------------*/
;*    install-compiler-signals! ...                                    */
;*---------------------------------------------------------------------*/
(define (install-compiler-signals!)
   (let ((kill-my-self (lambda (n)
			  (if (>fx *verbose* 0)
			      (notify-error "Illegal signal caught"
					    n
					    "aborting...")
			      (notify-error "internal error"
					    "aborting"
					    #f))
			  (exit-bigloo -1))))
      (signal sigfpe kill-my-self)
      (signal sigill kill-my-self)
      (signal sigbus kill-my-self)
      (signal sigsegv kill-my-self)))


