;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Engine/pass.sch          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:29:06 1994                          */
;*    Last change :  Tue Jun 11 13:16:44 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pass prelude                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directives clause                                            */
;*---------------------------------------------------------------------*/
(directives
   (import  tools_speek
	    (*nb-error-on-pass* tools_error)
	    engine_pass))
 
;*---------------------------------------------------------------------*/
;*    pass-prelude ...                                                 */
;*    -------------------------------------------------------------    */
;*    The pass prelude.                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-prelude name . hooks)
   `(begin
       (verbose 1 "   . " ,name #\newline)
       (set! *nb-error-on-pass* 0)
       (set! *current-pass*  ,name)
       (let loop ((hooks ,(cons 'list hooks))
		  (hnames ',hooks))
	  (cond
	     ((null? hooks)
	      'pass-started)
	     (((car hooks))
	      (loop (cdr hooks) (cdr hnames)))
	     (else
	      (internal-error ,name
			      "failure during prelude hook"
			      (car hnames)))))))

;*---------------------------------------------------------------------*/
;*    pass-postlude ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-postlude value . hooks)
   `(let ((value ,value))
       (if (>fx *nb-error-on-pass* 0)
	   (begin
	      (fprint (current-error-port)
		      *nb-error-on-pass*
		      " error"
		      (if (and (integer? *nb-error-on-pass*)
			       (> *nb-error-on-pass* 1))
			  "s"
			  "")
		      " occured, ending ...")
	      (exit -1))
	   (let loop ((hooks  ,(cons 'list hooks))
		      (hnames ',hooks))
	      (cond
		 ((null? hooks)
		  value)
		 (((car hooks))
		  (loop (cdr hooks) (cdr hnames)))
		 (else
		  (internal-error *current-pass*
				  "failure during postlude hook"
				  (car hnames))))))))
	      
	       

	   
