;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/param.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  3 12:44:17 1995                          */
;*    Last change :  Thu Feb 11 07:20:54 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Global control of the compiler                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  ;; tools_date is a generated file and hence, it can't be
	    ;; set in the .afile file.
	    (tools_date "Tools/date.scm"))
   (export  *bigloo-version*
	    *bigloo-name*
	    *bigloo-level*
	    *bigloo-cmd-name*
	    *bigloo-args*
	    *rest-args*
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*
	    *bigloo-tmp*
	    *bigloo-licensing?*
	    *lib-mode*
	    *init-mode*
	    *max-c-token-length*
	    *max-c-foreign-arity*
	    *verbose*
	    *hello*
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*
	    *unsafe-version*
	    *unsafe-library*
	    *profile-library*
	    *trace-name*
	    *trace-write-length*
	    *additional-traces*
	    *inlining?*
	    *inlining-kfactor*
	    *inlining-reduce-kfactor*
	    *optim*
	    *optim-stack?*
	    *optim-inline-method?*
	    *optim-unroll-loop?*
	    *optim-loop-inlining?*
	    *optim-O-macro?*
	    *max-stack-alloc-size*
	    *genericity*
	    *shared-cnst?*
	    ;; -------------------------------------------------------------
	    ;; warning, any change about this variable name must be reported
	    ;; in the no-trace-no-check macro of Llib/error.scm file
	    *compiler-debug*            
	    ;; -------------------------------------------------------------
	    *c-debug*                   
	    *c-debug-option*
	    *bdb-debug*
	    *profile-mode*
	    *prof-table-name*
	    *module-shape?*             
	    *key-shape?*
	    *type-shape?*
	    *access-shape?*
	    *location-shape?*
	    *user-shape?*
	    *tmp-dest*         
	    *dest*
	    *shell*
	    *cc*
	    *stdc*               
	    *cc-options*       
	    *rm-c-files*       
	    *ld-options*       
	    *strip*            
	    *bigloo-lib*
	    *bigloo-lib-base-name*
	    *gc-lib*
	    *static-bigloo?*
	    *bigloo-user-lib*
	    *additional-bigloo-libraries*
	    *default-lib-dir*
	    *lib-dir*
	    *lib-src-dir*
	    *include-foreign*  
	    *additional-include-foreign*
	    *indent*
	    *access-file*      
	    *access-table*     
	    *src-files*              
	    *o-files*          
	    *with-files*
	    *interpreter*      
	    *startup-file*     
	    *call/cc?*
	    *reflection?*
	    *garbage-collector*
	    *pass*
	    *module-checksum-object?*
	    *heap-base-name*
	    *heap-name*
	    *additional-heap-name*
	    *additional-heap-names*
	    *extend-entry*
	    *auto-mode*
	    *src-suffix*
	    *obj-suffix*
	    *mco-suffix*
	    *case-sensitive*
	    *user-heap-size*
	    *reader*
	    (bigloo-variables-usage ::bool))
   (extern  (macro shell::string "SHELL")
	    (macro c-compiler::string "C_COMPILER")
	    (macro library-directory::string "LIBRARY_DIRECTORY")
	    (macro user-libraries::string "USER_LIBRARIES")
	    (macro c-beautifier::string "C_BEAUTIFIER")
	    (macro library-base-name::string "LIBRARY_BASE_NAME"))
   (eval    (export-all)))

;*---------------------------------------------------------------------*/
;*    *bigloo-variables* ...                                           */
;*    -------------------------------------------------------------    */
;*    This variable hold the list of all the Bigloo control            */
;*    variables with there description. This variable is used by       */
;*    the only function `bigloo-variables-usage'.                      */
;*---------------------------------------------------------------------*/
(define *bigloo-variables* '())

;*---------------------------------------------------------------------*/
;*    add-doc-variable! ...                                            */
;*---------------------------------------------------------------------*/
(define (add-doc-variable! id doc)
   (set! *bigloo-variables* (cons (cons id doc) *bigloo-variables*)))

;*---------------------------------------------------------------------*/
;*    doc-define ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (doc-define var doc val)
   `(begin
       (define ,var ,val)
       (add-doc-variable! ',var ,doc)))
		    
;*---------------------------------------------------------------------*/
;*    bigloo-variables-usage ...                                       */
;*    -------------------------------------------------------------    */
;*    If MANUAL? is true the formatting is done according to manual    */
;*    width constraints.                                               */
;*---------------------------------------------------------------------*/
(define (bigloo-variables-usage manual?)
   (print "   All the Bigloo control variables can be changed from the")
   (print "   interpreter, by the means of the `-eval' option, or using")
   (print "   the module clause `option'. For instance the option")
   (print "   \"-eval '(set! *strip* #t)'\" will set the variable")
   (print "   `*strip*' to the value `#t'.")
   (print "   These variables are:")
   (newline)
   (let loop ((l (reverse *bigloo-variables*)))
      (if (pair? l)
	  (let ((var (car l)))
	     (if manual?
		 (begin
		    (print "   - " (car var) " : ")
		    (print "     " (cdr var))
		    (display "     default: ")
		    (write (eval (car var)))
		    (newline))
		 (begin
		    (display* "   - " (car var) " : " (cdr var) " [")
		    (write (eval (car var)))
		    (print "]")))
	     (loop (cdr l))))))
   
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
;; the bigloo version
(doc-define *bigloo-version*
	    "The Bigloo major release number"
	    "2.0")
;; the bigloo name
(doc-define *bigloo-name*
	    "The Bigloo name"
	    (string-append "Bigloo (" *bigloo-version* ")"))
;; the bigloo minor release number
(doc-define *bigloo-level*
	    "The Bigloo minor release number (#f or a char)"
	    #\a)
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *rest-args*         '())
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "Manuel.Serrano@unice.fr")
(define *bigloo-date*       (bigloo-date))
;; the tmp directory
(doc-define *bigloo-tmp*
	    "The tmp directory name"
	    (let ((Venv (getenv "TMPDIR")))
	       (if (string? Venv)
		   Venv
		   (os-tmp))))
;; Shall we include the license in the C files ?
(doc-define *bigloo-licensing?*
	    "Add the Bigloo license ?"
	    #f)
	    
;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(doc-define *verbose*
	    "The verbosity level"
	    0)

(doc-define *hello*
	    "Say hello (when verbose)"
	    #t)

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
;; the source files
(doc-define *src-files*
	    "The sources files"
	    '())
(define *tmp-dest*          #f)
;; the target name
(doc-define *dest*
	    "The target name"
	    #f)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
;; the shell
(doc-define *shell*
	    "The C compiler"
	    shell)
;; the c compiler
(doc-define *cc*
	    "The C compiler"
	    c-compiler)
;; The C production type
(doc-define *stdc*
	    "Shall we produced ISO C?"
	    #f)
;; the CC option
(doc-define *cc-options*
	    "cc options"
	    "")
;; shall we remove the C produced file?
(doc-define *rm-c-files*
	    "Shall we remove the C produced file?"
	    #t)
;; ld options
(doc-define *ld-options*
	    "ld options"
	    ""))
;; strip ?
(doc-define *strip*
	    "Shall we strip the executable?"
	    #t)
;; the default lib dir path
(doc-define *default-lib-dir*
	    "The default lib dir path (without version)"
	    library-directory)
;; the lib dir path
(doc-define *lib-dir*
	    "The lib dir path"
	    (let ((lib-env (getenv "BIGLOOLIB")))
	       (if (not (string? lib-env))
		   (list *default-lib-dir*)
		   (list lib-env))))
;; the lib source dir path
(doc-define *lib-src-dir*
	    "The lib dir path"
	    (make-file-name (car *lib-dir*) "runtime"))
;; the bigloo library base name
(doc-define *bigloo-lib-base-name*
	    "The Bigloo library base name"
	    library-base-name)
;; the bigloo library
(doc-define *bigloo-lib*
	    "The Bigloo library"
	    (string-append *bigloo-lib-base-name*
			   *bigloo-version*
			   (if (char? *bigloo-level*)
			       (make-string 1 *bigloo-level*)
			       "")))
;; the gc library
(doc-define *gc-lib*
	    "The Gc library"
	    "gc")
;; does we use a static version of the bigloo library?
(doc-define *static-bigloo?*
	    "Do we use the static Bigloo library"
	    #f)
;; the user C libraries
(doc-define *bigloo-user-lib*
	    "The user extra C libraries"
	    (list user-libraries))
;; the user Bigloo libraries
(doc-define *additional-bigloo-libraries*
	    "The user extra Bigloo libraries"
	    '())
;; the load path
(set! *load-path* (append *lib-dir* *load-path*))
;; the C include files
(doc-define *include-foreign*
	    "The C included files"
	    (list (string-append "bigloo"
				 *bigloo-version*
				 (if (char? *bigloo-level*)
				     (make-string 1 *bigloo-level*)
				     "")
				 ".h")))
;; the additional C include files
(doc-define *additional-include-foreign*
	    "The additional C included files"
	    '())
;; the bigloo heap base name
(doc-define *heap-base-name*
	    "The Bigloo heap base name"
	    "bigloo")
;; the heap name
(doc-define *heap-name*
	    "The Bigloo heap file name"
	    (string-append *heap-base-name*
			   *bigloo-version*
			   (if (char? *bigloo-level*)
			       (make-string 1 *bigloo-level*)
			       "")
			   ".heap"))
;; the additional heap name
(doc-define *additional-heap-name*
	    "A name of an additional heap file name to be build"
	    #f)
;; the additional heap names
(doc-define *additional-heap-names*
	    "A list of Bigloo additional heap file name"
	    '())
;; indent
(doc-define *indent*
	    "The name of the C beautifier"
	    c-beautifier)
;; debugging level
(doc-define *compiler-debug*
	    "Debugging level"
	    0)
;; C debugging mode ?
(doc-define *c-debug*
	    "C debugging mode?"
	    #f)
;; C debugging option
(doc-define *c-debug-option*
	    "cc debugging option"
	    "-g")
;; The bdb debugging option
(doc-define *bdb-debug*
	    "Bdb debugging mode"
	    0)
;; The Bigloo profiling option
(doc-define *profile-mode*
	    "Bigloo profile mode"
	    0)
;; The Bigloo profiling translation table name
(doc-define *prof-table-name*
	    "Bprof translation table file name"
	    "bmon.out")

;*---------------------------------------------------------------------*/
;*    Les fichier de link                                              */
;*---------------------------------------------------------------------*/
(doc-define *access-file*
	    "The access file name"
	    #f)
(define *access-table* '())
(doc-define *o-files*
	    "The additional obect files"
	    '())
(doc-define *with-files*
	    "The additional modules"
	    '())
   
;*---------------------------------------------------------------------*/
;*    Des variables de controle sur `comment on doit compiler'         */
;*---------------------------------------------------------------------*/
(doc-define *interpreter*
	    "Shall we interprete the source file?"
	    #f)
(doc-define *startup-file*
	    "A startup file for the interpreter"
	    #f)
(doc-define *call/cc?*
	    "Shall we enabled call/cc?"
	    #f)
(doc-define *reflection?*
	    "Shall we produce refection code for classes"
	    #t)
(doc-define *pass*
	    "Stop after the pass"
	    'ld)
(doc-define *module-checksum-object?*
	    "Produce a module checksum object (.mco)"
	    #f)
(doc-define *garbage-collector*
	    "The garbage collector"
	    'boehm)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(doc-define *unsafe-type*
	    "Runtime type safety"
	    #f)
(doc-define *unsafe-arity*
	    "Runtime type arity safety"
	    #f)
(doc-define *unsafe-range*
	    "Runtime range safety"
	    #f)
(doc-define *unsafe-struct*
	    "Runtime struct range safety"
	    #f)
(doc-define *unsafe-version*
            "Module version safety"
	    #f)
(doc-define *unsafe-library*
	    "Use the unsafe library version"
	    #f)
(doc-define *profile-library*
	    "Use the profiled library version"
	    #f)
(define *module-shape?*             #f)
(define *key-shape?*                #f)
(define *type-shape?*               #f)
(define *access-shape?*             #f)
(define *location-shape?*           #f)
(define *user-shape?*               #f)
(doc-define *max-stack-alloc-size*
	    "Maximum size of stack allocated objects"
	    #f)
(define *genericity*                #t)
(doc-define *shared-cnst?*
	    "Shared constant compilation?"
	    #t)
(doc-define *lib-mode*
	    "Lib-mode compilation?"
	    #f)
(doc-define *init-mode*
	    "Module initialization mode"
	    'read)
(doc-define *max-c-token-length*
	    "Max c token length"
	    1024)
(doc-define *max-c-foreign-arity*
	    "Max C function arity"
	    16)
(doc-define *trace-name*
	    "Trace file name"
	    "trace")
(doc-define *trace-write-length*
	    "Trace dumping max level"
	    80)
(define *additional-traces*         '())

;*---------------------------------------------------------------------*/
;*    Optimizations                                                    */
;*---------------------------------------------------------------------*/
(doc-define *optim*
	    "Optimization level"
	    0)
(doc-define *optim-stack?*
	    "Stack allocation optimization"
	    #unspecified)
(doc-define *optim-inline-method?*
	    "Method inlining optimization"
	    #unspecified)
(doc-define *optim-unroll-loop?*
	    "Loop unrolling optimization"
	    #unspecified)
(doc-define *optim-loop-inlining?*
	    "Loop inlining optimization"
	    #t)
(doc-define *optim-O-macro?*
	    "Enable optimization by macro-expansion"
	    #t)
(doc-define *inlining?*
	    "Inlining optimization"
	    #t)
(doc-define *inlining-kfactor*
	    "Inlining growth factor"
	    (lambda (olevel) (*fx 2 olevel)))
(doc-define *inlining-reduce-kfactor*
	    "Inlinine growth factor reductor"
	    (lambda (kfactor) (/fx kfactor 2)))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(doc-define *extend-entry*
	    "Extend entry"
	    #f)

;*---------------------------------------------------------------------*/
;*    *src-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The list of suffix recognize by the compiler and the linker.     */
;*---------------------------------------------------------------------*/
(doc-define *src-suffix*
	    "Scheme legal suffixes"
	    '("scm" "bgl"))

;*---------------------------------------------------------------------*/
;*    *obj-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The suffix list of the object file                               */
;*---------------------------------------------------------------------*/
(doc-define *obj-suffix*
	    "Object legal suffixes"
	    '("o"))

;*---------------------------------------------------------------------*/
;*    *mco-suffix*                                                     */
;*    -------------------------------------------------------------    */
;*    The suffix list of the module checksum object files.             */
;*---------------------------------------------------------------------*/
(doc-define *mco-suffix*
	    "Module checksum object legal suffixes"
	    '("mco"))

;*---------------------------------------------------------------------*/
;*    Les auto-modes (comme en emacs)                                  */
;*---------------------------------------------------------------------*/
(doc-define *auto-mode*
	    "auto-mode (extend mode) list"
	    '(("ml"  . "caml")
	      ("mli" . "caml")
	      ("oon" . "meroon")))

;*---------------------------------------------------------------------*/
;*    *case-sensitive* ...                                             */
;*---------------------------------------------------------------------*/
(doc-define *case-sensitive*
	    "Case sensitivity"
	    #f)

;*---------------------------------------------------------------------*/
;*    *user-heap-size*                                                 */
;*---------------------------------------------------------------------*/
(doc-define *user-heap-size*
	    "Heap size (in MegaByte) or #f for default value"
	    #f)

;*---------------------------------------------------------------------*/
;*    *reader* ...                                                     */
;*---------------------------------------------------------------------*/
(doc-define *reader*
	    "The way the reader reads input file ('plain or 'intern)"
	    'plain)

;*---------------------------------------------------------------------*/
;*    Other variables that are defined inside the interpreter...       */
;*---------------------------------------------------------------------*/
(add-doc-variable! '*load-path* "The load path")
(add-doc-variable! '*user-pass* "The user specific compilation pass")
(add-doc-variable! '*debug*     "The debugging level")
(add-doc-variable! '*warning*   "The warning level")
(add-doc-variable! '*hygien?*   "Hygienic r5rs macro expansion activation")
