;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/link.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 15 11:16:02 1994                          */
;*    Last change :  Fri Nov 20 07:00:41 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On link quand l'utilisateur n'a passe que des `.o'               */
;*    -------------------------------------------------------------    */
;*    Pour ce faire on essaye de trouver des `.scm' correspondants.    */
;*    On genere un petit fichier `.scm' qui les initialise puis on     */
;*    le compile normalement ou alors, on se contente d'invoquer le    */
;*    linker `*ld*'.                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_link
   (export (link))
   (import cc_ld
	   read_reader
	   engine_compiler
	   engine_param
	   bdb_setting
	   (make-library-name module_alibrary)
	   tools_error
	   tools_file))

;*---------------------------------------------------------------------*/
;*    *tmp-main-file-name* ...                                         */
;*---------------------------------------------------------------------*/
(define *tmp-main-file-name* (make-file-name *bigloo-tmp*
					     (string-append
					      "main-tmp"
					      "@"
					      (let ((user (getenv "USER")))
						 (if (not (string? user))
						     ""
						     user))
					      (car *src-suffix*))))
			      
;*---------------------------------------------------------------------*/
;*    link ...                                                         */
;*---------------------------------------------------------------------*/
(define (link)
   ;; we set bdb options
   (if (>fx *bdb-debug* 0)
       (bdb-setting!))
   ;; we start by looking for the source files
   (let loop ((o-files   *o-files*)
	      (scm-files '()))
      (if (null? o-files)
	  ;; and with launch the linking process
	  (link-with scm-files)
	  (let* ((pref     (unprof-src-name (prefix (car o-files))))
		 (bpref    (basename pref))
		 (scm-file (find-src-file pref bpref)))
	     (if (string? scm-file)
		 (loop (cdr o-files) (cons scm-file scm-files))
		 (begin
		    (if (and (number? *warning*) (>=fx *warning* 2))
			(warning  "link"
				  "No Bigloo module found for -- "
				  (car o-files)))
		    (loop (cdr o-files) scm-files)))))))

;*---------------------------------------------------------------------*/
;*    unprof-src-name ...                                              */
;*---------------------------------------------------------------------*/
(define (unprof-src-name name)
   (if (not *profile-mode*)
       name
       (let ((len (string-length name)))
	  (if (and (>fx len 2)
		   (char=? (string-ref name (-fx len 1)) #\p)
		   (char=? (string-ref name (-fx len 2)) #\_))
	      (substring name 0 (-fx len 2))
	      name))))

;*---------------------------------------------------------------------*/
;*    find-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (find-src-file prefix bname)
   (let loop ((suffix *src-suffix*))
      (if (null? suffix)
	  #f
	  (let* ((suf (car suffix))
		 (f   (find-file/path (string-append prefix "." suf)
				      *load-path*)))
	     (if (string? f)
		 f
		 (let ((f (find-file/path (string-append bname "." suf)
					  *load-path*)))
		    (if (string? f)
			f
			(loop (cdr suffix)))))))))

;*---------------------------------------------------------------------*/
;*    link-with ...                                                    */
;*---------------------------------------------------------------------*/
(define (link-with scm-files)
   (if (null? scm-files)
       (let ((first (prefix (car *o-files*))))
	  (warning "link" "No source file found" " -- " *o-files*)
	  (set! *o-files* (cdr *o-files*))
	  (ld first #f))
       ;; on construit la clause du module
       (let loop ((scm-files scm-files)
		  (cls       '())
		  (main      #f)
		  (fmain     "")
		  (libraries '()))
	  (if (null? scm-files)
	      (if main
		  ;; ce n'est pas la peine de generer un main, il y en a
		  ;; deja un
		  (let ((first (prefix (car *o-files*))))
		     ;; if libraries are used by some module we add them
		     ;; to the link
		     (set! *additional-bigloo-libraries*
			   (append (map make-library-name libraries)
				   *additional-bigloo-libraries*))
		     (set! *o-files* (cdr *o-files*))
		     (ld first #f))
		  ;; on genere un main puis on link.
		  (begin
		     (make-tmp-main cls main libraries)
		     (set! *src-files* (list *tmp-main-file-name*))
		     ;; we have to remove extra mco files before compiler
		     ;; otherwise the compiler will warn about that files.
		     (let loop ((ra  *rest-args*)
				(res '()))
			(cond
			   ((null? ra)
			    (set! *rest-args* (reverse! res)))
			   ((member (suffix (car ra)) *mco-suffix*)
			    (loop (cdr ra) res))
			   (else
			    (loop (cdr ra) (cons (car ra) res)))))
		     (unwind-protect
			(compiler)
			(let* ((scm-file *tmp-main-file-name*)
			       (pre      (prefix scm-file))
			       (c-file   (string-append pre ".c"))
			       (o-file   (string-append pre ".o")))
			   (for-each (lambda (f)
					(if (file-exists? f)
					    (delete-file f)))
				     (list scm-file c-file o-file))))
		     0))
	      (let ((port (open-input-file (car scm-files))))
		 (if (not (input-port? port))
		     (error "" "Illegal file" (car scm-files))
		     (let ((exp (compiler-read port)))
			(close-input-port port)
			(match-case exp
			   ((module ?name ??- (main ?new-main) . ?-)
			    (if main
				(error ""
				       (string-append
					"Redeclaration of the main (files "
					fmain
					" and "
					(car scm-files) ")")
				       (cons main new-main)))
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  new-main
				  (car scm-files)
				  (append (find-libraries (cddr exp))
					  libraries)))
			   ((module ?name . ?-)
			    (loop (cdr scm-files)
				  (cons (list name
					      (string-append
					       "\""
					       (car scm-files)
					       "\""))
					cls)
				  main
				  fmain
				  (append (find-libraries (cddr exp))
					  libraries)))
			   (else
			    ;; ah, ce n'etait pas un fichier bigloo,
			    ;; on saute (en meprisant :-)
			    (loop (cdr scm-files)
				  cls
				  main
				  fmain
				  libraries))))))))))

;*---------------------------------------------------------------------*/
;*    find-libraries ...                                               */
;*---------------------------------------------------------------------*/
(define (find-libraries clauses)
   (let loop ((clauses   clauses)
	      (libraries '()))
      (match-case clauses
	 (()
	  (reverse! libraries))
	 (((library . ?libs) . ?rest)
	  (loop rest (append libs libraries)))
	 (else
	  (loop (cdr clauses) libraries)))))

;*---------------------------------------------------------------------*/
;*    make-tmp-main ...                                                */
;*---------------------------------------------------------------------*/
(define (make-tmp-main clauses main libraries)
   (let ((pout (open-output-file *tmp-main-file-name*)))
      (if (not (output-port? pout))
	  (error ""
		 "Can't open output file"
		 *tmp-main-file-name*)
	  (begin
	     (fprint pout ";; " *bigloo-name*)
	     (fprint pout ";; !!! generated file, don't edit !!!")
	     (fprint pout ";; ==================================")
	     (newline pout)
	     (if (and (not main) (>fx *bdb-debug* 0))
		 (warning "link"
			  "It won't be possible to debug that program"
			  "-- It contains no MAIN function!"))
	     (let* ((libs   (if (and #f (>fx *bdb-debug* 0))
				(cons 'bdb libraries)
				libraries))
		    (module `(module ,(gensym 'main)
			       (import ,@(reverse clauses))
			       ,@(if (pair? libs)
				     `((library ,@libs))
				     '()))))
		(fprint pout module)
		(newline pout))
	     (if main
		 (begin
		    (fprint pout "(main *the-command-line*)")
		    (newline pout)))
	     (close-output-port pout)))))
	  
	  

