;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/engine.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:13:23 1993                          */
;*    Last change :  Fri Nov 20 14:39:43 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The system's engine (some kind of dispatcher between the linker, */
;*    the interpreter and the compiler).                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (engine)
	   (hello-world))
   (import tools_speek
	   tools_trace
	   write_version
           engine_param
	   engine_compiler
	   engine_interp
	   engine_link))

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine)
   (cond
      ((and (pair? *src-files*) (not *interpreter*))
       (compiler))
      ((null? *o-files*)
       (interp version
	       *verbose*
	       *src-files*
	       *startup-file*
	       (string-append (car *lib-dir*) "/scheme-files")
	       *bigloo-args*))
      (else
       (link))))

;*---------------------------------------------------------------------*/
;*    hello-world ...                                                  */
;*---------------------------------------------------------------------*/
(define (hello-world)
   ;; aller, on dit bonjour
   (if *hello*
       (let loop ((src (reverse! *src-files*))
		  (str ""))
	  (if (null? src)
	      (begin
		 (string-set! str (-fx (string-length str) 1) #\:)
		 (verbose 0 str #\Newline))
	      (loop (cdr src) (string-append (car src) " " str))))))
