/*===========================================================================*/
/*   (Engine/compiler.scm)                                                   */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>
#include <signal.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;

typedef struct ccomp
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t producer;
     obj_t consumer;
     obj_t finalizer;
     obj_t checksummer;
  }
     *ccomp_t;


extern obj_t indent_cc_indent(obj_t);
static obj_t method_init_76_engine_compiler();
extern obj_t _optim__89_engine_param;
extern obj_t _optim_unroll_loop___80_engine_param;
static obj_t _compiler_engine_compiler(obj_t);
extern obj_t engine_engine_engine();
extern obj_t current_error_port;
extern obj_t _nb_error_on_pass__70_tools_error;
extern obj_t patch_vector_set__231_cfa_tvector();
extern obj_t make_add_heap_195_heap_make();
extern obj_t compiler_engine_compiler();
extern obj_t integrate_walk__134_integrate_walk(obj_t);
extern obj_t warning___error(obj_t);
extern obj_t stop_on_pass_198_engine_pass(obj_t, obj_t);
extern obj_t callcc_walk__209_callcc_walk(obj_t);
extern obj_t _bdb_debug__1_engine_param;
extern obj_t global_ast_var;
extern obj_t _obj__252_type_cache;
extern obj_t user_error_151_tools_error(obj_t, obj_t, obj_t, obj_t);
extern obj_t globalize_walk__63_globalize_walk(obj_t, obj_t);
extern bool_t is_a__118___object(obj_t, obj_t);
extern obj_t module_initialization_70_engine_compiler(long, char *);
extern obj_t module_initialization_70_tools_speek(long, char *);
extern obj_t module_initialization_70_tools_error(long, char *);
extern obj_t module_initialization_70_engine_pass(long, char *);
extern obj_t module_initialization_70_engine_signals(long, char *);
extern obj_t module_initialization_70_engine_param(long, char *);
extern obj_t module_initialization_70_engine_engine(long, char *);
extern obj_t module_initialization_70_read_src(long, char *);
extern obj_t module_initialization_70_write_expanded(long, char *);
extern obj_t module_initialization_70_write_ast(long, char *);
extern obj_t module_initialization_70_read_access(long, char *);
extern obj_t module_initialization_70_heap_restore(long, char *);
extern obj_t module_initialization_70_heap_make(long, char *);
extern obj_t module_initialization_70_ast_env(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_ast_build(long, char *);
extern obj_t module_initialization_70_ast_unit(long, char *);
extern obj_t module_initialization_70_user_user(long, char *);
extern obj_t module_initialization_70_type_env(long, char *);
extern obj_t module_initialization_70_type_cache(long, char *);
extern obj_t module_initialization_70_module_module(long, char *);
extern obj_t module_initialization_70_module_include(long, char *);
extern obj_t module_initialization_70_expand_syntax_case_44(long, char *);
extern obj_t module_initialization_70_expand_eps(long, char *);
extern obj_t module_initialization_70_expand_install(long, char *);
extern obj_t module_initialization_70_init_main(long, char *);
extern obj_t module_initialization_70_trace_walk(long, char *);
extern obj_t module_initialization_70_inline_walk(long, char *);
extern obj_t module_initialization_70_effect_walk(long, char *);
extern obj_t module_initialization_70_callcc_walk(long, char *);
extern obj_t module_initialization_70_fail_walk(long, char *);
extern obj_t module_initialization_70_globalize_walk(long, char *);
extern obj_t module_initialization_70_cfa_walk(long, char *);
extern obj_t module_initialization_70_cfa_tvector(long, char *);
extern obj_t module_initialization_70_integrate_walk(long, char *);
extern obj_t module_initialization_70_coerce_walk(long, char *);
extern obj_t module_initialization_70_reduce_walk(long, char *);
extern obj_t module_initialization_70_cnst_walk(long, char *);
extern obj_t module_initialization_70_cgen_walk(long, char *);
extern obj_t module_initialization_70_hgen_walk(long, char *);
extern obj_t module_initialization_70_bdb_setting(long, char *);
extern obj_t module_initialization_70_bdb_spread_obj_171(long, char *);
extern obj_t module_initialization_70_bdb_walk(long, char *);
extern obj_t module_initialization_70_prof_walk(long, char *);
extern obj_t module_initialization_70_cc_indent(long, char *);
extern obj_t module_initialization_70_cc_cc(long, char *);
extern obj_t module_initialization_70_cc_ld(long, char *);
extern obj_t module_initialization_70___error(long, char *);
extern obj_t module_initialization_70___object(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___r4_numbers_6_5(long, char *);
extern obj_t module_initialization_70___r4_output_6_10_3(long, char *);
extern obj_t module_initialization_70___r5_macro_4_3_init(long, char *);
extern obj_t user_walk_92_user_user(obj_t);
extern obj_t write_ast_133_write_ast(obj_t);
extern obj_t initialize_genv__97_ast_env();
extern obj_t _module_checksum_object___74_engine_param;
extern obj_t syntax_expand_units_115_expand_syntax_case_44(obj_t);
extern obj_t trace_walk__65_trace_walk(obj_t);
extern obj_t make_heap_12_heap_make();
extern obj_t coerce_walk__125_coerce_walk(obj_t);
extern obj_t exit_bigloo_229_init_main(obj_t);
extern obj_t write_expanded_48_write_expanded(obj_t);
static obj_t imported_modules_init_94_engine_compiler();
extern obj_t _hygien___100___r5_macro_4_3_init;
extern obj_t initialize_tenv__150_type_env();
extern obj_t expand_units_9_expand_eps(obj_t);
extern obj_t fprint___r4_output_6_10_3(obj_t, obj_t);
extern obj_t effect_walk__175_effect_walk(obj_t);
extern obj_t bdb_setting__207_bdb_setting();
extern obj_t fail_walk__172_fail_walk(obj_t);
extern obj_t _rest_args__8_engine_param;
static obj_t library_modules_init_112_engine_compiler();
extern obj_t hello_world_248_engine_engine();
extern obj_t install_type_cache__77_type_cache();
extern obj_t set_default_type__106_type_cache(type_t);
extern obj_t cfa_walk__41_cfa_walk(obj_t);
static obj_t toplevel_init_63_engine_compiler();
extern obj_t build_ast_197_ast_build(obj_t);
extern obj_t _call_cc___102_engine_param;
extern obj_t check_types_141_type_env();
extern obj_t open_input_string(obj_t);
extern obj_t _interpreter__140_engine_param;
extern obj_t string_to_bstring(char *);
extern obj_t inline_walk__185_inline_walk(obj_t, obj_t);
extern obj_t cgen_walk_174_cgen_walk(obj_t);
static obj_t arg1633_engine_compiler(obj_t);
static obj_t arg1624_engine_compiler(obj_t);
extern obj_t cnst_walk__13_cnst_walk(obj_t);
static obj_t arg1617_engine_compiler(obj_t);
static obj_t arg1612_engine_compiler(obj_t);
static obj_t arg1608_engine_compiler(obj_t);
static obj_t arg1603_engine_compiler(obj_t);
static obj_t arg1593_engine_compiler(obj_t);
static obj_t arg1600_engine_compiler(obj_t);
static obj_t arg1588_engine_compiler(obj_t);
static obj_t arg1584_engine_compiler(obj_t);
static obj_t arg1581_engine_compiler(obj_t);
static obj_t arg1578_engine_compiler(obj_t);
static obj_t arg1573_engine_compiler(obj_t);
static obj_t arg1568_engine_compiler(obj_t);
static obj_t arg1559_engine_compiler(obj_t);
extern obj_t bdb_walk__231_bdb_walk(obj_t);
static obj_t arg1555_engine_compiler(obj_t);
static obj_t arg1552_engine_compiler(obj_t);
static obj_t arg1548_engine_compiler(obj_t);
static obj_t arg1540_engine_compiler(obj_t);
static obj_t arg1536_engine_compiler(obj_t);
static obj_t arg1533_engine_compiler(obj_t);
static obj_t arg1530_engine_compiler(obj_t);
static obj_t arg1527_engine_compiler(obj_t);
static obj_t arg1524_engine_compiler(obj_t);
static obj_t arg1518_engine_compiler(obj_t);
static obj_t arg1478_engine_compiler(obj_t);
extern obj_t install_initial_expander_168_expand_install();
extern obj_t reduce_walk__148_reduce_walk(obj_t);
extern obj_t _compiler_debug__134_engine_param;
extern obj_t read_access_file_42_read_access();
extern obj_t module_checksum_object_250_module_module();
extern obj_t internal_error_43_tools_error(obj_t, obj_t, obj_t);
extern obj_t unit_sexp__add__71_ast_unit(obj_t, obj_t);
extern obj_t bdb_spread_obj__133_bdb_spread_obj_171(obj_t);
extern obj_t produce_module__65_module_module(obj_t);
extern obj_t make_prof_unit_161_prof_walk();
static obj_t _hgen_walk_236_hgen_walk(obj_t);
extern obj_t ld_cc_ld(obj_t, bool_t);
extern obj_t cc_cc_cc(obj_t, bool_t);
extern bool_t _2__206___r4_numbers_6_5(obj_t, obj_t);
extern obj_t read_src_204_read_src();
extern obj_t restore_heap_59_heap_restore();
extern obj_t read___reader(obj_t);
extern obj_t _profile_mode__105_engine_param;
extern obj_t install_compiler_signals__223_engine_signals();
extern obj_t _c_debug__136_engine_param;
extern obj_t _lib_mode__85_engine_param;
static obj_t require_initialization_114_engine_compiler = BUNSPEC;
extern obj_t _pass__125_engine_param;
extern obj_t get_toplevel_unit_32_module_include();
extern obj_t _main__152_module_module;
static obj_t cnst_init_137_engine_compiler();
extern obj_t _current_pass__25_engine_pass;
static obj_t __cnst[34];

DEFINE_STATIC_PROCEDURE(proc1739_engine_compiler, arg1633_engine_compiler1747, arg1633_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1738_engine_compiler, arg1624_engine_compiler1748, arg1624_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1737_engine_compiler, arg1617_engine_compiler1749, arg1617_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1736_engine_compiler, arg1612_engine_compiler1750, arg1612_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1735_engine_compiler, arg1536_engine_compiler1751, arg1536_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1734_engine_compiler, arg1533_engine_compiler1752, arg1533_engine_compiler, 0L, 0);
DEFINE_STATIC_PROCEDURE(proc1728_engine_compiler, arg1478_engine_compiler1753, arg1478_engine_compiler, 0L, 0);
extern obj_t hgen_walk_env_69_hgen_walk;
DEFINE_EXPORT_PROCEDURE(compiler_env_81_engine_compiler, _compiler_engine_compiler1754, _compiler_engine_compiler, 0L, 0);
DEFINE_STRING(string1740_engine_compiler, string1740_engine_compiler1755, "DONE CC CINDENT DISTRIB CGEN INLINE+ REDUCER CNST BDB REDUCE COERCE INTEGRATE CFA GLOBALIZE GLOBALIZATION FAIL INLINE ALL EFFECT CALLCC TRACE BDB-SPREAD-OBJ MAKE-ADD-HEAP MAKE-HEAP AST EXPAND SYNTAX USER HGEN (BDB-INITIAL-BREAKPOINT) BDB-INITIAL-BREAKPOINT LD (#unspecified) MCO ", 279);
DEFINE_STRING(string1733_engine_compiler, string1733_engine_compiler1756, "failure during postlude hook", 28);
DEFINE_STRING(string1732_engine_compiler, string1732_engine_compiler1757, " error", 6);
DEFINE_STRING(string1731_engine_compiler, string1731_engine_compiler1758, " occured, ending ...", 20);
DEFINE_STRING(string1729_engine_compiler, string1729_engine_compiler1759, "cer", 3);
DEFINE_STRING(string1730_engine_compiler, string1730_engine_compiler1760, "Type `extended pair' expected for expression", 44);
DEFINE_STRING(string1727_engine_compiler, string1727_engine_compiler1761, "Don't know what to do with arguments: ", 38);
DEFINE_STRING(string1726_engine_compiler, string1726_engine_compiler1762, "Illegal source file", 19);
DEFINE_STRING(string1725_engine_compiler, string1725_engine_compiler1763, "Parse error", 11);


/* module-initialization */ obj_t 
module_initialization_70_engine_compiler(long checksum_1431, char *from_1432)
{
   if (CBOOL(require_initialization_114_engine_compiler))
     {
	require_initialization_114_engine_compiler = BBOOL(((bool_t) 0));
	library_modules_init_112_engine_compiler();
	cnst_init_137_engine_compiler();
	imported_modules_init_94_engine_compiler();
	method_init_76_engine_compiler();
	toplevel_init_63_engine_compiler();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_engine_compiler()
{
   module_initialization_70___error(((long) 0), "ENGINE_COMPILER");
   module_initialization_70___object(((long) 0), "ENGINE_COMPILER");
   module_initialization_70___r5_macro_4_3_init(((long) 0), "ENGINE_COMPILER");
   module_initialization_70___r4_output_6_10_3(((long) 0), "ENGINE_COMPILER");
   module_initialization_70___r4_numbers_6_5(((long) 0), "ENGINE_COMPILER");
   module_initialization_70___reader(((long) 0), "ENGINE_COMPILER");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_engine_compiler()
{
   {
      obj_t cnst_port_138_1423;
      cnst_port_138_1423 = open_input_string(string1740_engine_compiler);
      {
	 long i_1424;
	 i_1424 = ((long) 33);
       loop_1425:
	 {
	    bool_t test1741_1426;
	    test1741_1426 = (i_1424 == ((long) -1));
	    if (test1741_1426)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg1743_1427;
		    {
		       obj_t list1744_1428;
		       {
			  obj_t arg1745_1429;
			  arg1745_1429 = BNIL;
			  list1744_1428 = MAKE_PAIR(cnst_port_138_1423, arg1745_1429);
		       }
		       arg1743_1427 = read___reader(list1744_1428);
		    }
		    CNST_TABLE_SET(i_1424, arg1743_1427);
		 }
		 {
		    int aux_1430;
		    {
		       long aux_1453;
		       aux_1453 = (i_1424 - ((long) 1));
		       aux_1430 = (int) (aux_1453);
		    }
		    {
		       long i_1456;
		       i_1456 = (long) (aux_1430);
		       i_1424 = i_1456;
		       goto loop_1425;
		    }
		 }
	      }
	 }
      }
   }
}


/* toplevel-init */ obj_t 
toplevel_init_63_engine_compiler()
{
   return BUNSPEC;
}


/* compiler */ obj_t 
compiler_engine_compiler()
{
   install_compiler_signals__223_engine_signals();
   {
      obj_t src_738;
      src_738 = read_src_204_read_src();
      if (CBOOL(src_738))
	{
	   if (PAIRP(src_738))
	     {
		BFALSE;
	     }
	   else
	     {
		user_error_151_tools_error(string1725_engine_compiler, string1726_engine_compiler, src_738, BNIL);
	     }
	}
      else
	{
	   _interpreter__140_engine_param = BTRUE;
	   {
	      obj_t arg1467_741;
	      arg1467_741 = engine_engine_engine();
	      exit_bigloo_229_init_main(arg1467_741);
	   }
	}
      hello_world_248_engine_engine();
      {
	 bool_t test1468_742;
	 {
	    long n1_1269;
	    n1_1269 = (long) CINT(_bdb_debug__1_engine_param);
	    test1468_742 = (n1_1269 > ((long) 0));
	 }
	 if (test1468_742)
	   {
	      bdb_setting__207_bdb_setting();
	   }
	 else
	   {
	      BUNSPEC;
	   }
      }
      {
	 bool_t test1469_743;
	 {
	    obj_t obj_1271;
	    obj_1271 = _rest_args__8_engine_param;
	    test1469_743 = NULLP(obj_1271);
	 }
	 if (test1469_743)
	   {
	      BUNSPEC;
	   }
	 else
	   {
	      obj_t list1470_744;
	      {
		 obj_t arg1473_746;
		 arg1473_746 = MAKE_PAIR(_rest_args__8_engine_param, BNIL);
		 list1470_744 = MAKE_PAIR(string1727_engine_compiler, arg1473_746);
	      }
	      warning___error(list1470_744);
	   }
      }
      read_access_file_42_read_access();
      if (CBOOL(_lib_mode__85_engine_param))
	{
	   initialize_genv__97_ast_env();
	   initialize_tenv__150_type_env();
	}
      else
	{
	   restore_heap_59_heap_restore();
	}
      install_type_cache__77_type_cache();
      patch_vector_set__231_cfa_tvector();
      {
	 obj_t module_748;
	 module_748 = CAR(src_738);
	 {
	    obj_t src_code_162_749;
	    src_code_162_749 = CDR(src_738);
	    {
	       obj_t units_750;
	       {
		  obj_t cellval_1487;
		  cellval_1487 = produce_module__65_module_module(module_748);
		  units_750 = MAKE_CELL(cellval_1487);
	       }
	       {
		  {
		     bool_t test1475_751;
		     {
			long n1_1274;
			n1_1274 = (long) CINT(_profile_mode__105_engine_param);
			test1475_751 = (n1_1274 >= ((long) 1));
		     }
		     if (test1475_751)
		       {
			  obj_t aux_1405;
			  {
			     obj_t arg1476_752;
			     arg1476_752 = make_prof_unit_161_prof_walk();
			     {
				obj_t obj2_1277;
				obj2_1277 = CELL_REF(units_750);
				aux_1405 = MAKE_PAIR(arg1476_752, obj2_1277);
			     }
			  }
			  CELL_SET(units_750, aux_1405);
		       }
		     else
		       {
			  BUNSPEC;
		       }
		  }
		  if (CBOOL(_module_checksum_object___74_engine_param))
		    {
		       module_checksum_object_250_module_module();
		    }
		  else
		    {
		       BUNSPEC;
		    }
		  {
		     obj_t arg1477_753;
		     arg1477_753 = CNST_TABLE_REF(((long) 0));
		     {
			obj_t arg1478_1358;
			arg1478_1358 = proc1728_engine_compiler;
			stop_on_pass_198_engine_pass(arg1477_753, arg1478_1358);
		     }
		  }
		  {
		     obj_t code_757;
		     if (NULLP(src_code_162_749))
		       {
			  code_757 = CNST_TABLE_REF(((long) 1));
		       }
		     else
		       {
			  code_757 = src_code_162_749;
		       }
		     {
			obj_t dcode_758;
			{
			   bool_t test1481_760;
			   {
			      bool_t test1486_766;
			      {
				 long n1_1279;
				 n1_1279 = (long) CINT(_bdb_debug__1_engine_param);
				 test1486_766 = (n1_1279 > ((long) 0));
			      }
			      if (test1486_766)
				{
				   bool_t _ortest_1443_767;
				   {
				      obj_t obj_1281;
				      obj_1281 = _main__152_module_module;
				      _ortest_1443_767 = is_a__118___object(obj_1281, global_ast_var);
				   }
				   if (_ortest_1443_767)
				     {
					test1481_760 = _ortest_1443_767;
				     }
				   else
				     {
					obj_t obj1_1282;
					obj1_1282 = _pass__125_engine_param;
					{
					   obj_t aux_1507;
					   aux_1507 = CNST_TABLE_REF(((long) 2));
					   test1481_760 = (obj1_1282 == aux_1507);
					}
				     }
				}
			      else
				{
				   test1481_760 = ((bool_t) 0);
				}
			   }
			   if (test1481_760)
			     {
				obj_t break_761;
				{
				   bool_t test1482_762;
				   test1482_762 = EXTENDED_PAIRP(module_748);
				   if (test1482_762)
				     {
					obj_t arg1483_763;
					obj_t arg1485_765;
					arg1483_763 = CNST_TABLE_REF(((long) 3));
					{
					   bool_t test1137_1286;
					   test1137_1286 = EXTENDED_PAIRP(module_748);
					   if (test1137_1286)
					     {
						arg1485_765 = CER(module_748);
					     }
					   else
					     {
						FAILURE(string1729_engine_compiler, string1730_engine_compiler, module_748);
					     }
					}
					break_761 = MAKE_EXTENDED_PAIR(arg1483_763, BNIL, arg1485_765);
				     }
				   else
				     {
					break_761 = CNST_TABLE_REF(((long) 4));
				     }
				}
				dcode_758 = MAKE_PAIR(break_761, code_757);
			     }
			   else
			     {
				dcode_758 = code_757;
			     }
			}
			{
			   {
			      obj_t arg1480_759;
			      arg1480_759 = get_toplevel_unit_32_module_include();
			      unit_sexp__add__71_ast_unit(arg1480_759, dcode_758);
			   }
			}
		     }
		  }
		  {
		     bool_t test1489_771;
		     {
			long n1_1296;
			n1_1296 = (long) CINT(_nb_error_on_pass__70_tools_error);
			test1489_771 = (n1_1296 > ((long) 0));
		     }
		     if (test1489_771)
		       {
			  {
			     char *arg1494_774;
			     {
				bool_t test1502_781;
				{
				   bool_t test1503_782;
				   {
				      obj_t obj_1298;
				      obj_1298 = _nb_error_on_pass__70_tools_error;
				      test1503_782 = INTEGERP(obj_1298);
				   }
				   if (test1503_782)
				     {
					test1502_781 = _2__206___r4_numbers_6_5(_nb_error_on_pass__70_tools_error, BINT(((long) 1)));
				     }
				   else
				     {
					test1502_781 = ((bool_t) 0);
				     }
				}
				if (test1502_781)
				  {
				     arg1494_774 = "s";
				  }
				else
				  {
				     arg1494_774 = "";
				  }
			     }
			     {
				obj_t list1497_776;
				{
				   obj_t arg1498_777;
				   {
				      obj_t arg1499_778;
				      {
					 obj_t arg1500_779;
					 arg1500_779 = MAKE_PAIR(string1731_engine_compiler, BNIL);
					 {
					    obj_t aux_1532;
					    aux_1532 = string_to_bstring(arg1494_774);
					    arg1499_778 = MAKE_PAIR(aux_1532, arg1500_779);
					 }
				      }
				      arg1498_777 = MAKE_PAIR(string1732_engine_compiler, arg1499_778);
				   }
				   list1497_776 = MAKE_PAIR(_nb_error_on_pass__70_tools_error, arg1498_777);
				}
				fprint___r4_output_6_10_3(current_error_port, list1497_776);
			     }
			  }
			  {
			     obj_t res1724_1300;
			     exit(((long) -1));
			     res1724_1300 = BINT(((long) -1));
			     res1724_1300;
			  }
		       }
		     else
		       {
			  obj_t hooks_783;
			  obj_t hnames_784;
			  hooks_783 = BNIL;
			  hnames_784 = BNIL;
			loop_785:
			  if (NULLP(hooks_783))
			    {
			       BUNSPEC;
			    }
			  else
			    {
			       bool_t test1508_790;
			       {
				  obj_t fun1515_795;
				  fun1515_795 = CAR(hooks_783);
				  {
				     obj_t aux_1543;
				     aux_1543 = PROCEDURE_ENTRY(fun1515_795) (fun1515_795, BEOA);
				     test1508_790 = CBOOL(aux_1543);
				  }
			       }
			       if (test1508_790)
				 {
				    {
				       obj_t hnames_1550;
				       obj_t hooks_1548;
				       hooks_1548 = CDR(hooks_783);
				       hnames_1550 = CDR(hnames_784);
				       hnames_784 = hnames_1550;
				       hooks_783 = hooks_1548;
				       goto loop_785;
				    }
				 }
			       else
				 {
				    internal_error_43_tools_error(_current_pass__25_engine_pass, string1733_engine_compiler, CAR(hnames_784));
				 }
			    }
		       }
		  }
		  check_types_141_type_env();
		  stop_on_pass_198_engine_pass(CNST_TABLE_REF(((long) 5)), hgen_walk_env_69_hgen_walk);
		  user_walk_92_user_user(CELL_REF(units_750));
		  {
		     obj_t arg1517_797;
		     arg1517_797 = CNST_TABLE_REF(((long) 6));
		     {
			obj_t arg1518_1357;
			arg1518_1357 = make_fx_procedure(arg1518_engine_compiler, ((long) 0), ((long) 1));
			PROCEDURE_SET(arg1518_1357, ((long) 0), units_750);
			stop_on_pass_198_engine_pass(arg1517_797, arg1518_1357);
		     }
		  }
		  install_initial_expander_168_expand_install();
		  if (CBOOL(_hygien___100___r5_macro_4_3_init))
		    {
		       syntax_expand_units_115_expand_syntax_case_44(CELL_REF(units_750));
		    }
		  else
		    {
		       BUNSPEC;
		    }
		  {
		     obj_t arg1522_801;
		     arg1522_801 = CNST_TABLE_REF(((long) 7));
		     {
			obj_t arg1524_1356;
			arg1524_1356 = make_fx_procedure(arg1524_engine_compiler, ((long) 0), ((long) 1));
			PROCEDURE_SET(arg1524_1356, ((long) 0), units_750);
			stop_on_pass_198_engine_pass(arg1522_801, arg1524_1356);
		     }
		  }
		  expand_units_9_expand_eps(CELL_REF(units_750));
		  {
		     obj_t arg1526_805;
		     arg1526_805 = CNST_TABLE_REF(((long) 8));
		     {
			obj_t arg1527_1355;
			arg1527_1355 = make_fx_procedure(arg1527_engine_compiler, ((long) 0), ((long) 1));
			PROCEDURE_SET(arg1527_1355, ((long) 0), units_750);
			stop_on_pass_198_engine_pass(arg1526_805, arg1527_1355);
		     }
		  }
		  {
		     obj_t ast_809;
		     {
			obj_t cellval_1575;
			cellval_1575 = build_ast_197_ast_build(CELL_REF(units_750));
			ast_809 = MAKE_CELL(cellval_1575);
		     }
		     {
			obj_t arg1529_810;
			arg1529_810 = CNST_TABLE_REF(((long) 9));
			{
			   obj_t arg1530_1354;
			   arg1530_1354 = make_fx_procedure(arg1530_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1530_1354, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1529_810, arg1530_1354);
			}
		     }
		     {
			obj_t arg1532_814;
			arg1532_814 = CNST_TABLE_REF(((long) 10));
			{
			   obj_t arg1533_1353;
			   arg1533_1353 = proc1734_engine_compiler;
			   stop_on_pass_198_engine_pass(arg1532_814, arg1533_1353);
			}
		     }
		     {
			obj_t arg1535_818;
			arg1535_818 = CNST_TABLE_REF(((long) 11));
			{
			   obj_t arg1536_1352;
			   arg1536_1352 = proc1735_engine_compiler;
			   stop_on_pass_198_engine_pass(arg1535_818, arg1536_1352);
			}
		     }
		     {
			bool_t test1538_822;
			{
			   long n1_1307;
			   n1_1307 = (long) CINT(_bdb_debug__1_engine_param);
			   test1538_822 = (n1_1307 >= ((long) 1));
			}
			if (test1538_822)
			  {
			     bdb_spread_obj__133_bdb_spread_obj_171(CELL_REF(ast_809));
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1539_823;
			arg1539_823 = CNST_TABLE_REF(((long) 12));
			{
			   obj_t arg1540_1351;
			   arg1540_1351 = make_fx_procedure(arg1540_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1540_1351, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1539_823, arg1540_1351);
			}
		     }
		     {
			bool_t test1542_827;
			{
			   bool_t test1543_828;
			   {
			      obj_t obj_1309;
			      obj_1309 = _compiler_debug__134_engine_param;
			      test1543_828 = INTEGERP(obj_1309);
			   }
			   if (test1543_828)
			     {
				long n1_1310;
				n1_1310 = (long) CINT(_compiler_debug__134_engine_param);
				test1542_827 = (n1_1310 > ((long) 2));
			     }
			   else
			     {
				test1542_827 = ((bool_t) 0);
			     }
			}
			if (test1542_827)
			  {
			     obj_t aux_1407;
			     aux_1407 = trace_walk__65_trace_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1407);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1545_829;
			arg1545_829 = CNST_TABLE_REF(((long) 13));
			{
			   obj_t arg1548_1350;
			   arg1548_1350 = make_fx_procedure(arg1548_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1548_1350, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1545_829, arg1548_1350);
			}
		     }
		     if (CBOOL(_call_cc___102_engine_param))
		       {
			  obj_t aux_1408;
			  aux_1408 = callcc_walk__209_callcc_walk(CELL_REF(ast_809));
			  CELL_SET(ast_809, aux_1408);
		       }
		     else
		       {
			  BUNSPEC;
		       }
		     {
			obj_t arg1550_833;
			arg1550_833 = CNST_TABLE_REF(((long) 14));
			{
			   obj_t arg1552_1349;
			   arg1552_1349 = make_fx_procedure(arg1552_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1552_1349, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1550_833, arg1552_1349);
			}
		     }
		     if (CBOOL(_optim_unroll_loop___80_engine_param))
		       {
			  {
			     obj_t aux_1409;
			     aux_1409 = effect_walk__175_effect_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1409);
			  }
			  {
			     obj_t arg1554_837;
			     arg1554_837 = CNST_TABLE_REF(((long) 15));
			     {
				obj_t arg1555_1348;
				arg1555_1348 = make_fx_procedure(arg1555_engine_compiler, ((long) 0), ((long) 1));
				PROCEDURE_SET(arg1555_1348, ((long) 0), ast_809);
				stop_on_pass_198_engine_pass(arg1554_837, arg1555_1348);
			     }
			  }
		       }
		     else
		       {
			  BUNSPEC;
		       }
		     {
			obj_t aux_1410;
			aux_1410 = inline_walk__185_inline_walk(CELL_REF(ast_809), CNST_TABLE_REF(((long) 16)));
			CELL_SET(ast_809, aux_1410);
		     }
		     {
			obj_t arg1558_842;
			arg1558_842 = CNST_TABLE_REF(((long) 17));
			{
			   obj_t arg1559_1347;
			   arg1559_1347 = make_fx_procedure(arg1559_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1559_1347, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1558_842, arg1559_1347);
			}
		     }
		     {
			bool_t test1561_846;
			{
			   bool_t test1562_847;
			   {
			      obj_t obj_1312;
			      obj_1312 = _compiler_debug__134_engine_param;
			      test1562_847 = INTEGERP(obj_1312);
			   }
			   if (test1562_847)
			     {
				bool_t test1563_848;
				{
				   long n1_1313;
				   n1_1313 = (long) CINT(_compiler_debug__134_engine_param);
				   test1563_848 = (n1_1313 > ((long) 0));
				}
				if (test1563_848)
				  {
				     long n1_1315;
				     n1_1315 = (long) CINT(_compiler_debug__134_engine_param);
				     test1561_846 = (n1_1315 <= ((long) 2));
				  }
				else
				  {
				     test1561_846 = ((bool_t) 0);
				  }
			     }
			   else
			     {
				test1561_846 = ((bool_t) 0);
			     }
			}
			if (test1561_846)
			  {
			     obj_t aux_1411;
			     aux_1411 = trace_walk__65_trace_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1411);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			bool_t test1564_849;
			{
			   bool_t test1565_850;
			   {
			      obj_t obj_1317;
			      obj_1317 = _compiler_debug__134_engine_param;
			      test1565_850 = INTEGERP(obj_1317);
			   }
			   if (test1565_850)
			     {
				long n1_1318;
				n1_1318 = (long) CINT(_compiler_debug__134_engine_param);
				test1564_849 = (n1_1318 > ((long) 0));
			     }
			   else
			     {
				test1564_849 = ((bool_t) 0);
			     }
			}
			if (test1564_849)
			  {
			     obj_t aux_1412;
			     aux_1412 = fail_walk__172_fail_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1412);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1566_851;
			arg1566_851 = CNST_TABLE_REF(((long) 18));
			{
			   obj_t arg1568_1346;
			   arg1568_1346 = make_fx_procedure(arg1568_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1568_1346, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1566_851, arg1568_1346);
			}
		     }
		     {
			obj_t aux_1413;
			aux_1413 = globalize_walk__63_globalize_walk(CELL_REF(ast_809), CNST_TABLE_REF(((long) 19)));
			CELL_SET(ast_809, aux_1413);
		     }
		     {
			obj_t arg1572_856;
			arg1572_856 = CNST_TABLE_REF(((long) 20));
			{
			   obj_t arg1573_1345;
			   arg1573_1345 = make_fx_procedure(arg1573_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1573_1345, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1572_856, arg1573_1345);
			}
		     }
		     {
			obj_t aux_1414;
			aux_1414 = cfa_walk__41_cfa_walk(CELL_REF(ast_809));
			CELL_SET(ast_809, aux_1414);
		     }
		     {
			obj_t arg1575_860;
			arg1575_860 = CNST_TABLE_REF(((long) 21));
			{
			   obj_t arg1578_1344;
			   arg1578_1344 = make_fx_procedure(arg1578_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1578_1344, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1575_860, arg1578_1344);
			}
		     }
		     set_default_type__106_type_cache((type_t) (_obj__252_type_cache));
		     {
			obj_t aux_1415;
			aux_1415 = integrate_walk__134_integrate_walk(CELL_REF(ast_809));
			CELL_SET(ast_809, aux_1415);
		     }
		     {
			obj_t arg1580_864;
			arg1580_864 = CNST_TABLE_REF(((long) 22));
			{
			   obj_t arg1581_1343;
			   arg1581_1343 = make_fx_procedure(arg1581_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1581_1343, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1580_864, arg1581_1343);
			}
		     }
		     {
			obj_t aux_1416;
			aux_1416 = coerce_walk__125_coerce_walk(CELL_REF(ast_809));
			CELL_SET(ast_809, aux_1416);
		     }
		     {
			obj_t arg1583_868;
			arg1583_868 = CNST_TABLE_REF(((long) 23));
			{
			   obj_t arg1584_1342;
			   arg1584_1342 = make_fx_procedure(arg1584_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1584_1342, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1583_868, arg1584_1342);
			}
		     }
		     {
			bool_t test1586_872;
			{
			   long n1_1320;
			   n1_1320 = (long) CINT(_optim__89_engine_param);
			   test1586_872 = (n1_1320 >= ((long) 2));
			}
			if (test1586_872)
			  {
			     {
				obj_t aux_1417;
				aux_1417 = effect_walk__175_effect_walk(CELL_REF(ast_809));
				CELL_SET(ast_809, aux_1417);
			     }
			     {
				obj_t arg1587_873;
				arg1587_873 = CNST_TABLE_REF(((long) 15));
				{
				   obj_t arg1588_1341;
				   arg1588_1341 = make_fx_procedure(arg1588_engine_compiler, ((long) 0), ((long) 1));
				   PROCEDURE_SET(arg1588_1341, ((long) 0), ast_809);
				   stop_on_pass_198_engine_pass(arg1587_873, arg1588_1341);
				}
			     }
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			bool_t test1590_877;
			{
			   long n1_1322;
			   n1_1322 = (long) CINT(_optim__89_engine_param);
			   test1590_877 = (n1_1322 >= ((long) 1));
			}
			if (test1590_877)
			  {
			     obj_t aux_1418;
			     aux_1418 = reduce_walk__148_reduce_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1418);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1592_878;
			arg1592_878 = CNST_TABLE_REF(((long) 24));
			{
			   obj_t arg1593_1340;
			   arg1593_1340 = make_fx_procedure(arg1593_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1593_1340, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1592_878, arg1593_1340);
			}
		     }
		     {
			bool_t test1595_882;
			{
			   long n1_1324;
			   n1_1324 = (long) CINT(_bdb_debug__1_engine_param);
			   test1595_882 = (n1_1324 >= ((long) 1));
			}
			if (test1595_882)
			  {
			     obj_t aux_1419;
			     aux_1419 = bdb_walk__231_bdb_walk(CELL_REF(ast_809));
			     CELL_SET(ast_809, aux_1419);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1598_883;
			arg1598_883 = CNST_TABLE_REF(((long) 25));
			{
			   obj_t arg1600_1339;
			   arg1600_1339 = make_fx_procedure(arg1600_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1600_1339, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1598_883, arg1600_1339);
			}
		     }
		     {
			obj_t aux_1420;
			aux_1420 = cnst_walk__13_cnst_walk(CELL_REF(ast_809));
			CELL_SET(ast_809, aux_1420);
		     }
		     {
			obj_t arg1602_887;
			arg1602_887 = CNST_TABLE_REF(((long) 26));
			{
			   obj_t arg1603_1338;
			   arg1603_1338 = make_fx_procedure(arg1603_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1603_1338, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1602_887, arg1603_1338);
			}
		     }
		     {
			bool_t test1605_891;
			{
			   long n1_1326;
			   n1_1326 = (long) CINT(_optim__89_engine_param);
			   test1605_891 = (n1_1326 >= ((long) 3));
			}
			if (test1605_891)
			  {
			     obj_t aux_1421;
			     aux_1421 = inline_walk__185_inline_walk(CELL_REF(ast_809), CNST_TABLE_REF(((long) 27)));
			     CELL_SET(ast_809, aux_1421);
			  }
			else
			  {
			     BUNSPEC;
			  }
		     }
		     {
			obj_t arg1607_893;
			arg1607_893 = CNST_TABLE_REF(((long) 28));
			{
			   obj_t arg1608_1337;
			   arg1608_1337 = make_fx_procedure(arg1608_engine_compiler, ((long) 0), ((long) 1));
			   PROCEDURE_SET(arg1608_1337, ((long) 0), ast_809);
			   stop_on_pass_198_engine_pass(arg1607_893, arg1608_1337);
			}
		     }
		     {
			obj_t c_prefix_211_897;
			c_prefix_211_897 = cgen_walk_174_cgen_walk(CELL_REF(ast_809));
			{
			   obj_t arg1610_898;
			   arg1610_898 = CNST_TABLE_REF(((long) 29));
			   {
			      obj_t arg1612_1336;
			      arg1612_1336 = proc1736_engine_compiler;
			      stop_on_pass_198_engine_pass(arg1610_898, arg1612_1336);
			   }
			}
			{
			   obj_t arg1615_902;
			   arg1615_902 = CNST_TABLE_REF(((long) 30));
			   {
			      obj_t arg1617_1335;
			      arg1617_1335 = proc1737_engine_compiler;
			      stop_on_pass_198_engine_pass(arg1615_902, arg1617_1335);
			   }
			}
			if (STRINGP(c_prefix_211_897))
			  {
			     {
				bool_t test1620_907;
				{
				   bool_t test1621_908;
				   {
				      obj_t obj1_1329;
				      obj1_1329 = _pass__125_engine_param;
				      {
					 obj_t aux_1710;
					 aux_1710 = CNST_TABLE_REF(((long) 31));
					 test1621_908 = (obj1_1329 == aux_1710);
				      }
				   }
				   if (test1621_908)
				     {
					test1620_907 = ((bool_t) 1);
				     }
				   else
				     {
					test1620_907 = CBOOL(_c_debug__136_engine_param);
				     }
				}
				if (test1620_907)
				  {
				     indent_cc_indent(c_prefix_211_897);
				  }
				else
				  {
				     BUNSPEC;
				  }
			     }
			     {
				obj_t arg1623_910;
				arg1623_910 = CNST_TABLE_REF(((long) 31));
				{
				   obj_t arg1624_1334;
				   arg1624_1334 = proc1738_engine_compiler;
				   stop_on_pass_198_engine_pass(arg1623_910, arg1624_1334);
				}
			     }
			     {
				bool_t arg1627_914;
				{
				   bool_t test1628_915;
				   {
				      obj_t obj1_1331;
				      obj1_1331 = _pass__125_engine_param;
				      {
					 obj_t aux_1719;
					 aux_1719 = CNST_TABLE_REF(((long) 32));
					 test1628_915 = (obj1_1331 == aux_1719);
				      }
				   }
				   if (test1628_915)
				     {
					arg1627_914 = ((bool_t) 0);
				     }
				   else
				     {
					arg1627_914 = ((bool_t) 1);
				     }
				}
				cc_cc_cc(c_prefix_211_897, arg1627_914);
			     }
			     {
				obj_t arg1632_917;
				arg1632_917 = CNST_TABLE_REF(((long) 32));
				{
				   obj_t arg1633_1333;
				   arg1633_1333 = proc1739_engine_compiler;
				   stop_on_pass_198_engine_pass(arg1632_917, arg1633_1333);
				}
			     }
			     ld_cc_ld(c_prefix_211_897, ((bool_t) 1));
			  }
			else
			  {
			     BUNSPEC;
			  }
			return BINT(((long) 0));
		     }
		  }
	       }
	    }
	 }
      }
   }
}


/* _compiler */ obj_t 
_compiler_engine_compiler(obj_t env_1359)
{
   return compiler_engine_compiler();
}


/* arg1633 */ obj_t 
arg1633_engine_compiler(obj_t env_1360)
{
   {
      return CNST_TABLE_REF(((long) 33));
   }
}


/* arg1624 */ obj_t 
arg1624_engine_compiler(obj_t env_1361)
{
   {
      return CNST_TABLE_REF(((long) 33));
   }
}


/* arg1617 */ obj_t 
arg1617_engine_compiler(obj_t env_1362)
{
   {
      return CNST_TABLE_REF(((long) 33));
   }
}


/* arg1612 */ obj_t 
arg1612_engine_compiler(obj_t env_1363)
{
   {
      return CNST_TABLE_REF(((long) 33));
   }
}


/* arg1608 */ obj_t 
arg1608_engine_compiler(obj_t env_1364)
{
   {
      obj_t ast_1365;
      ast_1365 = PROCEDURE_REF(env_1364, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1365));
      }
   }
}


/* arg1603 */ obj_t 
arg1603_engine_compiler(obj_t env_1366)
{
   {
      obj_t ast_1367;
      ast_1367 = PROCEDURE_REF(env_1366, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1367));
      }
   }
}


/* arg1600 */ obj_t 
arg1600_engine_compiler(obj_t env_1368)
{
   {
      obj_t ast_1369;
      ast_1369 = PROCEDURE_REF(env_1368, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1369));
      }
   }
}


/* arg1593 */ obj_t 
arg1593_engine_compiler(obj_t env_1370)
{
   {
      obj_t ast_1371;
      ast_1371 = PROCEDURE_REF(env_1370, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1371));
      }
   }
}


/* arg1588 */ obj_t 
arg1588_engine_compiler(obj_t env_1372)
{
   {
      obj_t ast_1373;
      ast_1373 = PROCEDURE_REF(env_1372, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1373));
      }
   }
}


/* arg1584 */ obj_t 
arg1584_engine_compiler(obj_t env_1374)
{
   {
      obj_t ast_1375;
      ast_1375 = PROCEDURE_REF(env_1374, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1375));
      }
   }
}


/* arg1581 */ obj_t 
arg1581_engine_compiler(obj_t env_1376)
{
   {
      obj_t ast_1377;
      ast_1377 = PROCEDURE_REF(env_1376, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1377));
      }
   }
}


/* arg1578 */ obj_t 
arg1578_engine_compiler(obj_t env_1378)
{
   {
      obj_t ast_1379;
      ast_1379 = PROCEDURE_REF(env_1378, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1379));
      }
   }
}


/* arg1573 */ obj_t 
arg1573_engine_compiler(obj_t env_1380)
{
   {
      obj_t ast_1381;
      ast_1381 = PROCEDURE_REF(env_1380, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1381));
      }
   }
}


/* arg1568 */ obj_t 
arg1568_engine_compiler(obj_t env_1382)
{
   {
      obj_t ast_1383;
      ast_1383 = PROCEDURE_REF(env_1382, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1383));
      }
   }
}


/* arg1559 */ obj_t 
arg1559_engine_compiler(obj_t env_1384)
{
   {
      obj_t ast_1385;
      ast_1385 = PROCEDURE_REF(env_1384, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1385));
      }
   }
}


/* arg1555 */ obj_t 
arg1555_engine_compiler(obj_t env_1386)
{
   {
      obj_t ast_1387;
      ast_1387 = PROCEDURE_REF(env_1386, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1387));
      }
   }
}


/* arg1552 */ obj_t 
arg1552_engine_compiler(obj_t env_1388)
{
   {
      obj_t ast_1389;
      ast_1389 = PROCEDURE_REF(env_1388, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1389));
      }
   }
}


/* arg1548 */ obj_t 
arg1548_engine_compiler(obj_t env_1390)
{
   {
      obj_t ast_1391;
      ast_1391 = PROCEDURE_REF(env_1390, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1391));
      }
   }
}


/* arg1540 */ obj_t 
arg1540_engine_compiler(obj_t env_1392)
{
   {
      obj_t ast_1393;
      ast_1393 = PROCEDURE_REF(env_1392, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1393));
      }
   }
}


/* arg1536 */ obj_t 
arg1536_engine_compiler(obj_t env_1394)
{
   {
      return make_add_heap_195_heap_make();
   }
}


/* arg1533 */ obj_t 
arg1533_engine_compiler(obj_t env_1395)
{
   {
      return make_heap_12_heap_make();
   }
}


/* arg1530 */ obj_t 
arg1530_engine_compiler(obj_t env_1396)
{
   {
      obj_t ast_1397;
      ast_1397 = PROCEDURE_REF(env_1396, ((long) 0));
      {
	 return write_ast_133_write_ast(CELL_REF(ast_1397));
      }
   }
}


/* arg1527 */ obj_t 
arg1527_engine_compiler(obj_t env_1398)
{
   {
      obj_t units_1399;
      units_1399 = PROCEDURE_REF(env_1398, ((long) 0));
      {
	 return write_expanded_48_write_expanded(CELL_REF(units_1399));
      }
   }
}


/* arg1524 */ obj_t 
arg1524_engine_compiler(obj_t env_1400)
{
   {
      obj_t units_1401;
      units_1401 = PROCEDURE_REF(env_1400, ((long) 0));
      {
	 return write_expanded_48_write_expanded(CELL_REF(units_1401));
      }
   }
}


/* arg1518 */ obj_t 
arg1518_engine_compiler(obj_t env_1402)
{
   {
      obj_t units_1403;
      units_1403 = PROCEDURE_REF(env_1402, ((long) 0));
      {
	 return write_expanded_48_write_expanded(CELL_REF(units_1403));
      }
   }
}


/* arg1478 */ obj_t 
arg1478_engine_compiler(obj_t env_1404)
{
   {
      {
	 long aux_1773;
	 aux_1773 = ((long) 0);
	 return BINT(aux_1773);
      }
   }
}


/* method-init */ obj_t 
method_init_76_engine_compiler()
{
   return BUNSPEC;
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_engine_compiler()
{
   module_initialization_70_tools_speek(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_tools_error(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_engine_pass(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_engine_signals(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_engine_param(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_engine_engine(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_read_src(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_write_expanded(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_write_ast(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_read_access(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_heap_restore(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_heap_make(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_ast_env(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_type_type(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_ast_var(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_ast_node(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_ast_build(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_ast_unit(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_user_user(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_type_env(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_type_cache(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_module_module(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_module_include(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_expand_syntax_case_44(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_expand_eps(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_expand_install(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_init_main(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_trace_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_inline_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_effect_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_callcc_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_fail_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_globalize_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cfa_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cfa_tvector(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_integrate_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_coerce_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_reduce_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cnst_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cgen_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_hgen_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_bdb_setting(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_bdb_spread_obj_171(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_bdb_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_prof_walk(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cc_indent(((long) 0), "ENGINE_COMPILER");
   module_initialization_70_cc_cc(((long) 0), "ENGINE_COMPILER");
   return module_initialization_70_cc_ld(((long) 0), "ENGINE_COMPILER");
}
