;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Effect/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 10:25:23 1995                          */
;*    Last change :  Thu Jun 27 09:26:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the effect property.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_walk
   (include "Engine/pass.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    type_type
	    ast_var
	    ast_node
	    effect_cgraph
	    effect_spread)
   (export  (effect-walk! globals)))

;*---------------------------------------------------------------------*/
;*    effect-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (effect-walk! globals)
   (pass-prelude "Effect")
   ;; we compute the inversed call-graph
   (trace effect "cgraph..." #\Newline)
   (for-each (lambda (global)
		(fun-call-graph! global))
	     globals)
   ;; then we iterate to mark all function/side-effect
   (trace effect "fix point..." #\Newline)
   (iterate-to-fix-point! (get-var/side-effect))
   ;; we mark function which are known to not make side effect
   (for-each (lambda (var)
		(let ((fun (variable-value var)))
		   (if (eq? (fun-side-effect? fun) #unspecified)
		       (fun-side-effect?-set! fun #f))))
	     (get-var/all))
   ;; we spread the effect properties
   (trace effect "spread..." #\Newline)
   (for-each (lambda (global)
		(spread-side-effect! (sfun-body (global-value global))))
	     globals)
   ;; we are done now.
   (trace effect "Effect done." #\Newline)
   (pass-postlude globals))
	   
;*---------------------------------------------------------------------*/
;*    iterate-to-fix-point! ...                                        */
;*---------------------------------------------------------------------*/
(define (iterate-to-fix-point! W)
   (if (null? W)
       'done
       (for-each
	(lambda (var)
	   (let ((fun (variable-value var)))
	      (if (not (eq? (fun-side-effect? fun) #t))
		  (begin
		     (fun-side-effect?-set! fun #t)
		     (cond
			((local/from? var)
			 (iterate-to-fix-point! (local/from-from var)))
			((global/from? var)
			 (iterate-to-fix-point! (global/from-from var))))))))
	W)))

					
