;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Effect/effect.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 13:46:44 1995                          */
;*    Last change :  Mon Apr 14 09:05:58 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The effect property                                              */
;*    -------------------------------------------------------------    */
;*    It is optional to have run the Effect pass before invoking       */
;*    this function. Nevertheless, firstly invoking Effect pass        */
;*    leads to better approximations.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_effect
   (include "Ast/node.sch")
   (export  (generic side-effect?::bool ::node)))

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (side-effect? node::node))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node)
   #f)

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::var)
   (not (eq? (variable-access (var-variable node)) 'read)))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node/effect)
   (let ((effect (node/effect-side-effect? node)))
      (if (boolean? effect)
	  effect
	  #t)))
 
;*---------------------------------------------------------------------*/
;*    side-effect? ::setq ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::setq)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::fail ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::fail)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::set-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::set-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::jump-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::jump-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::box-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::box-set!)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::app-ly ...                                        */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::app-ly)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::funcall ...                                       */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::funcall)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::cast ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::cast)
   (with-access::cast node (arg)
      (side-effect? arg)))



	    
