;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Coerce/typeof.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul  1 09:35:30 1996                          */
;*    Last change :  Sat May 16 08:44:04 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The node typeof generic function.                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_typeof
   (import  type_type
	    type_cache
	    type_typeof
	    tools_shape
	    ast_var
	    ast_node)
   (export  (generic typeof::type ::node)))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-generic (typeof::type node::node))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::atom)
   (with-access::atom node (value)
      (typeof-atom value)))
 
;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::kwote)
   (with-access::kwote node (value)
      (typeof-kwote value)))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::var)
   (with-access::var node (variable)
      (let ((value (variable-value variable)))
	 (cond
	    ((sfun? value)
	     *procedure*)
	    ((cfun? value)
	     (error "typeof" "Je n'ai pas encore fait ce truc" (shape node)))
	    (else
	     (variable-type variable))))))

;*---------------------------------------------------------------------*/
;*    typeof ::closure ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::closure)
   *procedure*)

;*---------------------------------------------------------------------*/
;*    typeof ::sequence ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::sequence)
   (with-access::sequence node (nodes)
      (typeof (car (last-pair nodes)))))

;*---------------------------------------------------------------------*/
;*    typeof ::pragma ...                                              */
;*---------------------------------------------------------------------*/
(define-method (typeof node::pragma)
   (with-access::pragma node (type)
      type))

;*---------------------------------------------------------------------*/
;*    typeof ::cast ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::cast)
   (with-access::cast node (type)
      type))

;*---------------------------------------------------------------------*/
;*    typeof ::setq ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::setq)
   *unspec*)

;*---------------------------------------------------------------------*/
;*    typeof ::conditional ...                                         */
;*---------------------------------------------------------------------*/
(define-method (typeof node::conditional)
   (with-access::conditional node (test true false)
      (let ((ttrue (typeof true))
	    (tfalse (typeof false)))
	 (if (not (eq? ttrue tfalse))
	     *obj*
	     ttrue))))

;*---------------------------------------------------------------------*/
;*    typeof ::fail ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::fail)
   (with-access::fail node (proc msg obj)
      *magic*))

;*---------------------------------------------------------------------*/
;*    typeof ::select ...                                              */
;*---------------------------------------------------------------------*/
(define-method (typeof node::select)
   (with-access::select node (clauses test)
      (let loop ((clauses (cdr clauses))
		 (type    (typeof (cdr (car clauses)))))
	 (if (null? clauses)
	     type
	     (if (eq? (typeof (cdr (car clauses))) type)
		 (loop (cdr clauses) type)
		 *obj*)))))

;*---------------------------------------------------------------------*/
;*    typeof ::let-fun ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::let-fun)
   (with-access::let-fun node (body)
      (typeof body)))

;*---------------------------------------------------------------------*/
;*    typeof ::let-var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::let-var)
   (with-access::let-var node (body)
      (typeof body)))
 
;*---------------------------------------------------------------------*/
;*    typeof ::set-ex-it ...                                           */
;*---------------------------------------------------------------------*/
(define-method (typeof node::set-ex-it)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::jump-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (typeof node::jump-ex-it)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::make-box ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::make-box)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::box-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::box-ref)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::box-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::box-set!)
   *unspec*)

;*---------------------------------------------------------------------*/
;*    typeof ::app-ly ...                                              */
;*---------------------------------------------------------------------*/
(define-method (typeof node::app-ly)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::funcall ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::funcall)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::app ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (typeof node::app)
   (with-access::app node (fun)
      (variable-type (var-variable fun))))
		
		
