;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Coerce/pproto.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 10:45:07 1995                          */
;*    Last change :  Mon Jul  8 16:53:08 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We print prototype                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_pproto
   (import  tools_speek
	    tools_shape
	    type_type
	    type_pptype
	    ast_var)
   (export  (pfunction-proto ::long ::variable)
	    (pvariable-proto ::long ::variable)
	    (reset-ppmarge!)
	    (inc-ppmarge!)
	    (dec-ppmarge!)))

;*---------------------------------------------------------------------*/
;*    reset-ppmarge! ...                                               */
;*---------------------------------------------------------------------*/
(define (reset-ppmarge!)
   (set! *pp-marge* 8))

;*---------------------------------------------------------------------*/
;*    inc-ppmarge! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inc-ppmarge!)
   (set! *pp-marge* (+fx 1 *pp-marge*)))

;*---------------------------------------------------------------------*/
;*    dec-ppmarge! ...                                                 */
;*---------------------------------------------------------------------*/
(define (dec-ppmarge!)
   (set! *pp-marge* (-fx *pp-marge* 1)))

;*---------------------------------------------------------------------*/
;*    *pp-marge* ...                                                   */
;*---------------------------------------------------------------------*/
(define *pp-marge*       8)
(define old-marge        -1)
(define old-marge-string "")

;*---------------------------------------------------------------------*/
;*    pfunction-proto ...                                              */
;*---------------------------------------------------------------------*/
(define (pfunction-proto level variable)
   (let ((marge (if (=fx old-marge *pp-marge*)
		    old-marge-string
		    (let ((marge (make-string *pp-marge* #\space)))
		       (set! old-marge *pp-marge*)
		       (set! old-marge-string marge)
		       marge))))
      (verbose level
	       marge
	       (shape variable) " : "
	       (function-type->string variable)
	       #\Newline)))

;*---------------------------------------------------------------------*/
;*    pvariable-proto ...                                              */
;*---------------------------------------------------------------------*/
(define (pvariable-proto level variable)
   (let ((marge (make-string *pp-marge* #\space)))
      (verbose level
	       marge
	       (shape variable) " : "
	       (variable-type->string variable)
	       #\Newline)))
