;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Coerce/funcall.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Tue Aug  4 14:26:41 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `funcall' coercion                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_funcall
   (include "Tools/trace.sch"
	    "Tools/location.sch")
   (import  engine_param
	    tools_shape
	    tools_error
	    tools_location
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_sexp
	    ast_local
	    ast_ident
	    coerce_coerce
	    coerce_convert))

;*---------------------------------------------------------------------*/
;*    coerce! ::funcall ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::funcall to)
   (trace coerce "coerce-funcall!: " (shape node) #\Newline)
   (let ((error-msg (list 'quote (shape node)))
	 (strength  (funcall-strength node)))
      ;; we coerce the arguments
      (coerce-funcall-args! node to)
      (if (memq strength '(light elight))
	  (convert! node *obj* to)
	  ;; we coerce the procedure
	  (let ((c-fun (coerce! (funcall-fun node) *procedure*)))
	     ;; we check arity
	     (if *unsafe-arity*
		 (begin
		    (funcall-fun-set! node c-fun)
		    (convert! node *obj* to))
		 (let* ((fun    (make-local-svar 'fun *procedure*))
			(loc    (node-loc node))
			(len    (-fx (length (funcall-args node)) 2))
			(a-len  (mark-symbol-non-user! (gensym 'len)))
			(a-tlen (mark-symbol-non-user!
				 (symbol-append a-len '::long)))
			(lnode  (instantiate::let-var
				   (loc loc)
				   (type *obj*)
				   (bindings (list (cons fun c-fun)))
				   (body (top-level-sexp->node
					  `(let ((,a-tlen ,len))
					      (if (correct-arity? ,fun ,a-len)
						  ,(convert! node *obj* to)
						  ,(make-error-node fun
								    error-msg
								    loc
								    to)))
					  loc)))))
		    (funcall-fun-set! node (instantiate::var
					      (loc loc)
					      (type *obj*)
					      (variable fun)))
		    lnode))))))

;*---------------------------------------------------------------------*/
;*    make-error-node ...                                              */
;*---------------------------------------------------------------------*/
(define (make-error-node fun error-msg loc to)
   (let ((ut *unsafe-type*))
      (set! *unsafe-type* #t)
      (let ((node (coerce!
		   (top-level-sexp->node 
		    (if (and (or (>fx *compiler-debug* 0)
				 (>fx *bdb-debug* 0))
			     (location? loc))
			`(begin
			    ((@ error/location __error)
			     ,(string-append (symbol->string
					      (current-function))
					     ":Wrong number of arguments")
			     ,error-msg
			     ,fun
			     ,(location-full-fname loc)
			     ,(location-pos loc))
			    (failure '_ '_ '_))
			`(failure ,(string-append (symbol->string
						   (current-function))
						  ":Wrong number of arguments")
				  ,error-msg
				  ,fun))
		    loc)
		   to)))
	 (set! *unsafe-type* ut)
	 node)))

;*---------------------------------------------------------------------*/
;*    coerce-funcall-args! ...                                         */
;*---------------------------------------------------------------------*/
(define (coerce-funcall-args! node to)
   (if (null? (funcall-args node))
       (funcall-args-set! node (list (top-level-sexp->node
				      '__eoa__
				      (node-loc node))))
       (let loop ((actuals (funcall-args node))
		  (prev    'dummy))
	  (if (null? actuals)
	      (set-cdr! prev (list (top-level-sexp->node
				    '__eoa__
				    (node-loc node))))
	      (begin
		 (set-car! actuals (coerce! (car actuals) *obj*))
		 (loop (cdr actuals) actuals))))))
