;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Coerce/apply.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Tue Aug  4 14:28:53 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `apply' coercion                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_apply
   (include "Tools/trace.sch"
	    "Tools/location.sch")
   (import  engine_param
	    tools_shape
	    tools_location
	    tools_error
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_sexp
	    ast_local
	    coerce_coerce
	    coerce_convert))

;*---------------------------------------------------------------------*/
;*    coerce! ::app-ly ...                                             */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::app-ly to)
   (trace coerce "coerce-apply!: " (shape node) #\Newline)
   (let ((error-msg (list 'quote (shape node))))
      ;; we coerce the arguments
      (app-ly-arg-set! node (coerce! (app-ly-arg node) *obj*))
      ;; we coerce the procedure
      (let ((c-fun (coerce! (app-ly-fun node) *procedure*)))
	 ;; we check arity
	 (if *unsafe-arity*
	     (begin
		(if (var? c-fun)
		    (begin
		       (app-ly-fun-set! node c-fun)
		       (convert! node *obj* to))
		    (let ((fun (make-local-svar 'fun *procedure*)))
		       (app-ly-fun-set! node c-fun)
		       (instantiate::let-var
			  (loc (node-loc node))
			  (type (node-type node))
			  (bindings (list (cons fun c-fun)))
			  (body (convert! node *obj* to))))))
	     (let* ((fun   (make-local-svar 'fun *procedure*))
		    (val   (make-local-svar 'val *procedure*))
		    (len   (gensym 'len))
		    (loc   (node-loc node))
		    (lnode (instantiate::let-var
			      (loc loc)
			      (type *obj*)
			      (bindings (list (cons fun c-fun)
					      (cons val (app-ly-arg node))))
			      (body     (top-level-sexp->node
					 `(let ((,(symbol-append len '::long)
						 (length ,val)))
					     (if (correct-arity? ,fun ,len)
						 ,(convert! node *obj* to)
						 ,(make-error-node error-msg
								   loc
								   to)))
					 loc)))))
		   ;; we set the new apply value
		(app-ly-fun-set! node (instantiate::var
					(loc loc)
					(type *procedure*)
					(variable fun)))
		(app-ly-arg-set! node (instantiate::var
					(loc loc)
					(type *obj*)
					(variable val)))
		lnode)))))

;*---------------------------------------------------------------------*/
;*    make-error-node ...                                              */
;*---------------------------------------------------------------------*/
(define (make-error-node error-msg loc to)
   (let ((ut *unsafe-type*))
      (set! *unsafe-type* #t)
      (let ((node (coerce!
		   (top-level-sexp->node 
		    (if (and (or (>fx *bdb-debug* 0)
				 (>fx *compiler-debug* 0))
			     (location? loc))
			`(begin
			    ((@ error/location __error)
			     ,(list 'quote (current-function))
			     "Wrong number of arguments"
			     ,error-msg
			     ,(location-full-fname loc)
			     ,(location-pos loc))
			    (failure '_ '_ '_))
			`(failure ,(list 'quote (current-function))
				  "Wrong number of arguments"
				  ,error-msg))
		    loc)
		   to)))
	 (set! *unsafe-type* ut)
	 node)))

