;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cnst/initialize.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 20 15:50:19 1995                          */
;*    Last change :  Sun Oct 18 08:23:24 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The initialize function definition.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_initialize
   (include "Tools/trace.sch"
	    "Ast/unit.sch")
   (import  tools_shape
	    tools_speek
	    tools_error
	    engine_param
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_env
	    ast_build
	    ast_lvtype
	    coerce_coerce 
	    cnst_alloc
	    cnst_node)
   (export  (initialize-ast)))

;*---------------------------------------------------------------------*/
;*    initialize-ast ...                                               */
;*    -------------------------------------------------------------    */
;*    Now, we have finished the ast walk, we can set the               */
;*    initialization function definition.                              */
;*---------------------------------------------------------------------*/
(define (initialize-ast)
   (let ((body (case *init-mode*
			((lib)
			 (lib-initialize!))
			((read)
			 (read-initialize!))
			((intern)
			 (intern-initialize!))
			(else
			 (internal-error "intialize-stop!"
					 "Illegal init-mode"
					 *init-mode*)))))
      (if (pair? body)
	  (let ((unit (unit 'cnst 8 body #t)))
	     (let ((ast (build-ast (list unit))))
		(for-each (lambda (global)
			     (coerce! (sfun-body (global-value global))
				      (global-type global)))
			  ast)
		ast))
	  '())))

;*---------------------------------------------------------------------*/
;*    lib-initialize! ...                                              */
;*---------------------------------------------------------------------*/
(define (lib-initialize!)
   (global-name-set! (get-cnst-table) "*__cnst")
   (get-cnst-sexp))

;*---------------------------------------------------------------------*/
;*    read-initialize! ...                                             */
;*---------------------------------------------------------------------*/
(define (read-initialize!)
   (if (=fx (get-cnst-offset) 0)
       (read-empty-cnst-initialize!)
       (read-full-cnst-initialize!)))

;*---------------------------------------------------------------------*/
;*    read-empty-cnst-initialize! ...                                  */
;*---------------------------------------------------------------------*/
(define (read-empty-cnst-initialize!)
   (global-name-set! (get-cnst-table) "*__cnst")
   (get-cnst-sexp))

;*---------------------------------------------------------------------*/
;*    read-full-cnst-initialize! ...                                   */
;*---------------------------------------------------------------------*/
(define (read-full-cnst-initialize!)
   (global-name-set! (get-cnst-table)
		     (string-append "__cnst[ "
				    (number->string (get-cnst-offset))
				    " ] "))
   (define (read-full-cnst-initialize/small-string cnst-string)
      (let* ((var-string  (cnst-alloc-string cnst-string #f))
	     (sexp `(let ((cnst-port::input-port
				      (c-open-input-string ,(global-id
							     (var-variable
							      var-string)))))
		       (labels ((loop (i::long)
				      (if (c-=fx i -1)
					  #unspecified
					  (begin
					     (cnst-table-set!
					      i
					      ((@ read __reader) cnst-port))
					     (let ((aux::int (c--fx i 1)))
						(loop aux))))))
			  (loop ,(-fx (get-cnst-offset) 1))))))
	 (cons sexp (get-cnst-sexp))))
   (let ((cnst-string (cnst-set->cnst-string (get-cnst-set))))
      (read-full-cnst-initialize/small-string cnst-string)))

;*---------------------------------------------------------------------*/
;*    cnst-set->cnst-string ...                                        */
;*    -------------------------------------------------------------    */
;*    What we call a `set' is just a list of constants.                */
;*    To build the string, we just print it !                          */
;*---------------------------------------------------------------------*/
(define (cnst-set->cnst-string set)
   (let ((port (open-output-string)))
      (if (not (output-port? port))
	  (internal-error "cnst-set->cnst-string"
			  "Can't open output string port"
			  port)
	  (begin
	     (for-each (lambda (cnst)
			  (write cnst port)
			  (write-char #\space port))
		       set)
	     (close-output-port port)))))
  
;*---------------------------------------------------------------------*/
;*    intern-initialize! ...                                           */
;*---------------------------------------------------------------------*/
(define (intern-initialize!)
   (if (=fx (get-cnst-offset) 0)
       (intern-empty-cnst-initialize!)
       (intern-full-cnst-initialize!)))

;*---------------------------------------------------------------------*/
;*    intern-empty-cnst-initialize! ...                                */
;*---------------------------------------------------------------------*/
(define (intern-empty-cnst-initialize!)
   (global-name-set! (get-cnst-table) "*__cnst")
   (get-cnst-sexp))

;*---------------------------------------------------------------------*/
;*    intern-full-cnst-initialize! ...                                 */
;*---------------------------------------------------------------------*/
(define (intern-full-cnst-initialize!)
   (global-name-set! (get-cnst-table)
		     (string-append "__cnst[ "
				    (number->string (get-cnst-offset))
				    " ] "))
   (define (intern-full-cnst-initialize/small-string cnst-string)
      (let* ((var-string  (cnst-alloc-string cnst-string #f))
	     (sexp `(let ((cnst-tmp::vector
				     ((@ string->obj __intext)
				      ,(global-id
					(var-variable var-string)))))
		       (labels ((loop (i::int)
				      (if (c-=fx i -1)
					  #unspecified
					  (begin
					     (cnst-table-set! i
							      (c-vector-ref
							       cnst-tmp
							       i))
					     (let ((aux::int (c--fx i 1)))
						(loop aux))))))
			  (loop ,(-fx (get-cnst-offset) 1))))))
	 (cons sexp (get-cnst-sexp))))
   (let* ((cnst-string (obj->string (list->vector (reverse! (get-cnst-set))))))
      (intern-full-cnst-initialize/small-string cnst-string)))

 
