;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cnst/cache.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Feb 19 10:35:59 1995                          */
;*    Last change :  Tue Apr  8 13:30:53 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A cache to be able to recognize function call very fast.         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_cache
   (import  type_type
	    ast_var
	    ast_env
	    engine_param)
   (export  (start-cnst-cache!)
	    (stop-cnst-cache!)
	    *cnst-table-ref*
	    *cnst-table-set!*
	    *cons*
	    *btrue*
	    *bfalse*
	    *string->bstring*
	    *string->symbol*
	    *string->keyword*
	    *bool->bbool*
	    *make-fx-procedure*
	    *make-va-procedure*
	    *double->real*
	    *list->vector*
	    *vector-tag-set!*))

;*---------------------------------------------------------------------*/
;*    The cache registers definition                                   */
;*---------------------------------------------------------------------*/
(define *cache-started?*        #f)

(define *cnst-table-ref*        #f)
(define *cnst-table-set!*       #f)
(define *cons*                  #f)
(define *btrue*                 #f)
(define *bfalse*                #f)
(define *string->bstring*       #f)
(define *string->symbol*        #f)
(define *string->keyword*       #f)
(define *bool->bbool*           #f)
(define *make-fx-procedure*     #f)
(define *make-va-procedure*     #f)
(define *double->real*          #f)
(define *list->vector*          #f)
(define *vector-tag-set!*       #f)

;*---------------------------------------------------------------------*/
;*    start-cnst-cache! ...                                            */
;*---------------------------------------------------------------------*/
(define (start-cnst-cache!)
   (if (not *cache-started?*)
       (begin
	  (set! *cache-started?* #t)
	  (set! *cnst-table-ref* (find-global 'cnst-table-ref 'foreign))
	  (set! *cnst-table-set!* (find-global 'cnst-table-set! 'foreign))
	  (set! *cons* (find-global 'c-cons 'foreign))
	  (set! *btrue* (find-global 'btrue 'foreign))
	  (set! *bfalse* (find-global 'bfalse 'foreign))
	  (set! *string->bstring* (find-global 'string->bstring 'foreign))
	  (set! *string->symbol* (find-global 'c-string->symbol 'foreign))
	  (set! *string->keyword* (find-global 'c-string->keyword 'foreign))
	  (set! *bool->bbool* (find-global 'bool->bbool 'foreign))
	  (set! *make-fx-procedure* (find-global 'make-fx-procedure 'foreign))
	  (set! *make-va-procedure* (find-global 'make-va-procedure 'foreign))
	  (set! *double->real* (find-global 'double->real 'foreign))
	  (set! *list->vector* (find-global 'list->vector))
	  (set! *vector-tag-set!* (find-global 'vector-tag-set!))
	  #t)
       #t))

;*---------------------------------------------------------------------*/
;*    stop-cnst-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (stop-cnst-cache!)
   (set! *string->bstring*    #f)
   (set! *string->symbol*     #f)
   (set! *string->keyword*    #f)
   (set! *bool->bbool*        #f)
   (set! *make-fx-procedure*  #f)
   (set! *make-va-procedure*  #f)
   (set! *double->real*       #f)
   (set! *cons*               #f)
   (set! *btrue*              #f)
   (set! *bfalse*             #f)
   #t)






