;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/walk.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Sat Oct 10 14:13:23 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `C generation' pass.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Engine/pass.sch"
	    "Ast/unit.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    module_module
	    module_library
	    type_type
	    ast_var
	    ast_node
	    ast_occur
	    ast_build
	    object_class
	    bdb_emit
	    prof_emit
	    cgen_cop
	    cgen_emit
	    cgen_prototype
	    cgen_main
	    cgen_init
	    cgen_cgen)
   (export  (cgen-walk globals)))

;*---------------------------------------------------------------------*/
;*    cgen-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cgen-walk globals)
   (pass-prelude "C generation" (lambda () (start-emission! ".c")))

   (trace cgen "cgen-walk: *main*: " (shape *main*) #\( *main* #\) #\Newline)
   
   (let* ((lib-unit (library-finalizer))
	  (lib-init (if (unit? lib-unit)
			(let ((vars (build-ast-sans-remove (list lib-unit))))
			   (for-each (lambda (g)
					(occur-node-in!
					 (sfun-body (global-value g))
					 g))
				     vars)
			   vars)
			'()))
	  (globals  (cons (make-module-init)
			  (if (and (or *main* (memq *pass* '(ld distrib)))
				   (not (eq? *main* 'imported)))
			      (cons (make-bigloo-main)
				    (append lib-init globals))
			      (append lib-init globals)))))
      
      ;; a very little comment 
      (emit-header)
   
      ;; emit the GC selection
      (emit-garbage-collector-selection)
   
      ;; if we are in debugging mode, we generate a macro
      (if (or (>fx *compiler-debug* 0) *c-debug*)
	  (emit-debug-activation))
   
      ;; the include (both Bigloo's and user's ones)
      (emit-include)
   
      ;; we emit the generated type for the classes
      (emit-class-types *c-port*)
   
      ;; we declare prototypes
      ;; first, we print the prototype of variables
      (emit-prototypes)

      ;; then we emit the constants values
      (emit-cnsts)
   
      ;; when compiling in bdb mode we have to emit the identifier
      ;; translation table.
      (if (>fx *bdb-debug* 0)
	  (emit-bdb-info globals *c-port*))

      ;; when compiling for profile we emit identifier translation table
      (if (>fx *profile-mode* 0)
	  (emit-prof-info globals *c-port*))
      
      ;; we print the C main...
      (if (and (or *main* (memq *pass* '(ld distrib)))
	       (not (eq? *main* 'imported)))
	  (emit-main))

      ;; we now emit the code for all the Scheme functions
      (for-each cgen globals)

      (stop-emission!)))
