;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/proto.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  2 09:57:04 1996                          */
;*    Last change :  Tue Oct 27 09:36:26 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of prototypes                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_prototype
   (include "Tvector/tvector.sch")
   (import  tools_error
	    tools_shape
	    engine_param
	    module_module
	    type_type
	    type_cache
	    type_tools
	    type_env
	    ast_var
	    ast_node
	    ast_env
	    ast_ident
	    tvector_tvector
	    tvector_cnst
	    cnst_alloc
	    cgen_cop
	    cgen_emit
	    cgen_emit-cop) 
   (export  (emit-prototypes)
	    (emit-cnsts)
	    (set-variable-name! variable)
	    (qualified-name ::bstring ::symbol)))

;*---------------------------------------------------------------------*/
;*    emit-prototypes ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-prototypes)
   ;; first, we print the prototype of non procedure
   (for-each-global!
    (lambda (global)
       (if (and (or (and (eq? (global-module global) *module*)
			 (eq? (global-import global) 'export))
		    (>fx (global-occurrence global) 0)
		    (eq? (global-removable global) 'never))
		(not (scnst? (global-value global))))
	   (emit-prototype (global-value global) global))))
   ;; since cnst-table is a hack, it nevers appears but it is used
   ;; by a bunch of C macros (this variable cannot appears because
   ;; it has a strange name).
   (let ((cnst-init (get-cnst-table)))
      (emit-prototype (global-value cnst-init) cnst-init))
   ;; we are done now for prototypes.
   (newline *c-port*))

;*---------------------------------------------------------------------*/
;*    emit-cnsts ...                                                   */
;*---------------------------------------------------------------------*/
(define (emit-cnsts)
   (for-each-global!
    (lambda (global)
       (if (and (or (and (eq? (global-module global) *module*)
			 (eq? (global-import global) 'export))
		    (>fx (global-occurrence global) 0))
		(scnst? (global-value global)))
	   (emit-cnst (global-value global) global))))
   (newline *c-port*))

;*---------------------------------------------------------------------*/
;*    emit-prototype ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (emit-prototype value::value variable::variable))

;*---------------------------------------------------------------------*/
;*    emit-prototype ::svar ...                                        */
;*---------------------------------------------------------------------*/
(define-method (emit-prototype value::svar variable)
   (emit-prototype/svar/scnst value variable))

;*---------------------------------------------------------------------*/
;*    emit-prototype ::scnst ...                                       */
;*---------------------------------------------------------------------*/
(define-method (emit-prototype value::scnst variable)
   (emit-prototype/svar/scnst value variable))

;*---------------------------------------------------------------------*/
;*    emit-prototype/svar/scnst ...                                    */
;*---------------------------------------------------------------------*/
(define (emit-prototype/svar/scnst value variable)
   (with-access::variable variable (type id name)
      (set-variable-name! variable)
      (cond
	 ((eq? (global-import variable) 'static)
	  (fprint *c-port*
		  "static"
		  #\space
		  (make-typed-declaration type name)
		  (if (sub-type? type *obj*) " = BUNSPEC;" #\;)))
	 ((eq? (global-import variable) 'export)
	  (fprint *c-port*
		  (make-typed-declaration type name)
		  (if (sub-type? type *obj*) " = BUNSPEC;" #\;)))
	 (else
	  (fprint *c-port*
		  (get-c-scope variable)
		  #\space
		  (make-typed-declaration type name)
		  #\;)))))

;*---------------------------------------------------------------------*/
;*    emit-prototype ::sfun ...                                        */
;*---------------------------------------------------------------------*/
(define-method (emit-prototype value::sfun variable)
   (with-access::variable variable (type id name)
      (set-variable-name! variable)
      (fprin *c-port* (get-c-scope variable) #\space)
      (fprin *c-port* (make-typed-declaration type name))
      (let ((args (sfun-args value)))
	 (if (and (pair? args) (type? (car args)))
	     (emit-prototype-formal-types args)
	     (emit-prototype-formals args)))
      (fprint *c-port* #\;)))

;*---------------------------------------------------------------------*/
;*    emit-prototype-formal-types ...                                  */
;*---------------------------------------------------------------------*/
(define (emit-prototype-formal-types types)
   (if (null? types)
       (fprin *c-port* "()")
       (begin
	  (display #\( *c-port*)
	  (let loop ((types types))
	     (if (null? (cdr types))
		 (fprin *c-port* (type-name-sans-$ (car types)) #\))
		 (begin
		    (fprin *c-port* (type-name-sans-$ (car types)) ", ")
		    (loop (cdr types))))))))

;*---------------------------------------------------------------------*/
;*    emit-prototype-formals ...                                       */
;*---------------------------------------------------------------------*/
(define (emit-prototype-formals args)
   (if (null? args)
       (fprin *c-port* "()")
       (begin
	  (display #\( *c-port*)
	  (let loop ((args args))
	     (if (null? (cdr args))
		 (with-access::local (car args) (type)
		    (fprin *c-port* (type-name-sans-$ type) #\)))
		 (with-access::local (car args) (type)
		    (fprin *c-port* (type-name-sans-$ type) ", ")
		    (loop (cdr args))))))))

;*---------------------------------------------------------------------*/
;*    emit-prototype ::cfun ...                                        */
;*---------------------------------------------------------------------*/
(define-method (emit-prototype value::cfun variable)
   (if (not (cfun-macro? value))
       (with-access::global variable (id type name)
	  (fprin *c-port* "extern ")
	  (let* ((arity (cfun-arity value))
		 (targs (cfun-args-type value)))
	     (fprin *c-port* (make-typed-declaration type name) #\()
	     (cond
		((null? targs)
		 (display #\) *c-port*))
		((<=fx arity -1)
		 (fprin *c-port* (type-name-sans-$ (car targs)) ", ...)"))
		(else
		 (let loop ((targs targs))
		    (if (null? (cdr targs))
			(if (<fx arity 0)
			    (fprin *c-port* "...)")
			    (fprin *c-port*
				   (type-name-sans-$ (car targs)) #\)))
			(begin
			   (fprin *c-port* (type-name-sans-$ (car targs)) ", ")
			   (loop (cdr targs)))))))
	     (display #\; *c-port*)
	     (newline *c-port*)))))

;*---------------------------------------------------------------------*/
;*    emit-prototype ::cvar ...                                        */
;*---------------------------------------------------------------------*/
(define-method (emit-prototype value::cvar variable)
   (if (not (cvar-macro? value))
       (with-access::global variable (type name)
	  (fprint *c-port* "extern " (make-typed-declaration type name) #\;))))

;*---------------------------------------------------------------------*/
;*    emit-cnst ...                                                    */
;*---------------------------------------------------------------------*/
(define (emit-cnst value::scnst variable::global)
   (with-access::scnst value (class node)
      (case class
	 ((sstring)
	  (emit-cnst-string node variable))
	 ((sreal)
	  (emit-cnst-real node variable))
	 ((sfun)
	  (emit-cnst-sfun node variable))
	 ((sgfun)
	  (emit-cnst-sgfun node variable))
	 ((stvector)
	  (emit-cnst-stvector node variable))
	 (else
	  (internal-error "emit-cnst" "Unknown cnst class" class)))))

;*---------------------------------------------------------------------*/
;*    emit-cnst-string ...                                             */
;*---------------------------------------------------------------------*/
(define (emit-cnst-string ostr global)
   (set-variable-name! global)
   (let ((str (string-for-read ostr)))
      (fprin *c-port*
	     "DEFINE_STRING( "
	     (global-name global)
	     ", "
	     (id->name (gensym (global-name global)))
	     ", \"")
      (let loop ((read 0)
		 (rlen (string-length str)))
	 (cond
	    ((<=fx rlen *max-c-token-length*)
	     (display (untrigraph (substring str read (+fx read rlen)))
		      *c-port*)
	     (fprint *c-port* "\", " (string-length ostr) " );"))
	    (else
	     (let laap ((offset (+fx read *max-c-token-length*)))
		(cond
		   ((>=fx (+fx read 3) offset)
		    (internal-error "emit-cnst-string"
				    "Can't emit string"
				    ostr))
		   ((char=? (string-ref str (-fx offset 1)) #\\)
		    (laap (-fx offset 1)))
		   ((and (char=? (string-ref str (-fx offset 2)) #\\)
			 (char-numeric? (string-ref str (-fx offset 1))))
		    (laap (-fx offset 2)))
		   ((and (char=? (string-ref str (-fx offset 3)) #\\)
			 (char-numeric? (string-ref str (-fx offset 2)))
			 (char-numeric? (string-ref str (-fx offset 1))))
		    (laap (-fx offset 3)))
		   (else
		    (fprin *c-port* (substring str read offset) #"\"\n\"")
		    (loop offset
			  (-fx rlen (-fx offset read)))))))))))

;*---------------------------------------------------------------------*/
;*    emit-cnst-real ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-cnst-real real global)
   (set-variable-name! global)
   (fprint *c-port*
	   "DEFINE_REAL( "
	   (global-name global)
	   ", "
	   (id->name (gensym (global-name global)))
	   ", "
	   real
	   " );"))

;*---------------------------------------------------------------------*/
;*    emit-cnst-sfun ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-cnst-sfun sfun global)
   (emit-cnst-sfun/sgfun sfun global "PROCEDURE"))

;*---------------------------------------------------------------------*/
;*    emit-cnst-sgfun ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-cnst-sgfun sgfun global)
   (emit-cnst-sfun/sgfun sgfun global "GENERIC"))

;*---------------------------------------------------------------------*/
;*    emit-cnst-sfun/sgfun ...                                         */
;*---------------------------------------------------------------------*/
(define (emit-cnst-sfun/sgfun fun global kind)
   (if (eq? (global-import global) 'import)
       (emit-prototype (global-value global) global)
       (let* ((actuals (app-args fun))
	      (entry   (car actuals))
	      (arity   (atom-value (cadr actuals)))
	      (vname   (set-variable-name! global))
	      (name    (set-variable-name! (var-variable entry))))
	  (if (>=fx arity 0)
	      (fprint *c-port*
		      (if (eq? (global-import global) 'static)
			  (string-append "DEFINE_STATIC_" kind "( ")
			  (string-append "DEFINE_EXPORT_" kind "( "))
		      vname
		      ", "
		      (id->name (gensym name))
		      ", "
		      name
		      ", 0L, "
		      arity
		      " );")
	      (fprint *c-port*
		      (if (eq? (global-import global) 'static)
			  (string-append "DEFINE_STATIC_" kind "( ")
			  (string-append "DEFINE_EXPORT_" kind "( "))
		      vname
		      ", "
		      (id->name (gensym name))
		      ", va_generic_entry"
		      ", "
		      name
		      ", "
		      arity
		      " );")))))
   
;*---------------------------------------------------------------------*/
;*    emit-cnst-stvector ...                                           */
;*---------------------------------------------------------------------*/
(define (emit-cnst-stvector tvec global)
   (let* ((vec   (a-tvector-vector tvec))
	  (itype (tvec-item-type (a-tvector-type tvec)))
	  (c-vec (tvector->c-vector tvec)))
      (set-variable-name! global)
      (let ((aux (id->name (gensym (global-name global)))))
	 (fprint *c-port*
		 "DEFINE_TVECTOR_START( "
		 aux
		 ", "
		 (vector-length vec)
		 ", "
		 (string-sans-$ (type-name itype))
		 " ) "
		 c-vec
		 " DEFINE_TVECTOR_STOP( "
		 (global-name global)
		 ", "
		 aux
		 " );"))))

;*---------------------------------------------------------------------*/
;*    get-c-scope ...                                                  */
;*---------------------------------------------------------------------*/
(define-generic (get-c-scope::bstring variable::variable))

;*---------------------------------------------------------------------*/
;*    get-c-scope ::global ...                                         */
;*---------------------------------------------------------------------*/
(define-method (get-c-scope variable::global)
   (with-access::global variable (import)
      (case import
	 ((static)
	  "static")
	 ((import)
	  "extern")
	 ((export)
	  "extern")
	 (else
	  (internal-error "get-c-scope" "Unknown importation" import)))))

;*---------------------------------------------------------------------*/
;*    get-c-scope ::local ...                                          */
;*---------------------------------------------------------------------*/
(define-method (get-c-scope variable::local)
   "static")

;*---------------------------------------------------------------------*/
;*    set-variable-name! ...                                           */
;*---------------------------------------------------------------------*/
(define (set-variable-name! variable)
   (with-access::variable variable (name id)
      (if (string? name)
	  name
	  (let ((n (let ((name (id->name id)))
		      (cond 
			 ((global? variable)
			  (let ((module-id (global-module variable)))
			     (qualified-name name module-id)))
			 ((local? variable)
			  (string-append
			   name
			   "_"
			   (integer->string (local-key variable))))
			 (else
			  (internal-error "set-variable-name!"
					  "Unknown variable sort"
					  (shape variable)))))))
	     (set! name n)
	     n))))

;*---------------------------------------------------------------------*/
;*    qualified-name ...                                               */
;*---------------------------------------------------------------------*/
(define (qualified-name name::bstring module-id::symbol)
   (string-append name "_" (id->name module-id)))
   
;*---------------------------------------------------------------------*/
;*    fprin ...                                                        */
;*---------------------------------------------------------------------*/
(define (fprin port . obj)
   (for-each (lambda (o) (display o port)) obj))
