;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/init.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 17:59:38 1995                          */
;*    Last change :  Tue Aug  4 14:30:48 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We produce a Bigloo's `main' function.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_init
   (import  engine_param
	    module_module
	    tools_shape
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_env
	    ast_sexp
	    ast_local
	    ast_glo-def
	    ast_unit
	    ast_occur
	    coerce_coerce)
   (export  (make-module-init)))

;*---------------------------------------------------------------------*/
;*    make-module-init ...                                             */
;*---------------------------------------------------------------------*/
(define (make-module-init)
   (let* ((req  (def-global-svar! 'require-initialization::obj
		   *module*
		   'module-initalization
		   'now))
	  (ubody `(if require-initialization
		     (begin
			(set! require-initialization #f)
			,@(unit-init-calls)
			#unspecified)
		     #unspecified))
	  (body (if *unsafe-version*
		    ubody
		    `(if (pragma::bool "((($1) & ($2)) == ($1))"
				       checksum
				       ,*module-checksum*)
			 ,ubody
			 (module-init-error ,(symbol->string *module*) from))))
	  (cvar (make-local-svar 'checksum *long*))
	  (nvar (make-local-svar 'from *string*))
	  (node (let ((_           *_*)
		      (unsafe-type *unsafe-type*))
		   (set! *_* *obj*)
		   (set! *unsafe-type* #t)
		   (let ((node (coerce! (sexp->node body
						    (list cvar nvar)
						    '()
						    'value)
					*obj*)))
		      (set! *_* _)
		      (set! *unsafe-type* unsafe-type)
		      node)))
	  (init (def-global-sfun! (module-initialization-id *module*)
		   '(checksum from)
		   (list cvar nvar)
		   *module*
		   'sfun
		   'module-initialization
		   'now
		   node)))
      (global-import-set! init 'export)
      (global-type-set! init *obj*)
      (occur-node-in! node init)
      init))
 
