;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/emit.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 18:14:47 1995                          */
;*    Last change :  Tue Jun 30 12:42:39 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of the C code                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_emit
   (import  engine_param
	    tools_license)
   (export  (start-emission! suffix::bstring)
	    (stop-emission!)
	    (emit-comment ::bstring ::char)
	    (emit-header)
	    (emit-garbage-collector-selection)
	    (emit-include)
	    (emit-debug-activation)
	    (emit-main)
	    *c-port*))

;*---------------------------------------------------------------------*/
;*    *dest-prefix* ...                                                */
;*---------------------------------------------------------------------*/
(define *dest-prefix* #f)
(define *c-port*      #f)

;*---------------------------------------------------------------------*/
;*    start-emission! ...                                              */
;*---------------------------------------------------------------------*/
(define (start-emission! suffix)
   (let* ((prefix (cond
		     ((and (string? *dest*)
			   (memq *pass* '(cgen distrib cc cindent)))
		      (prefix *dest*))
		     ((pair? *src-files*)
		      (prefix (car *src-files*)))
		     (else
		      #f))))
      (if (or (eq? *dest* '--to-stdout) (not (string? prefix)))
	  (set! *c-port* (current-output-port))
	  (let ((f-name (string-append prefix suffix)))
	     (set! *dest-prefix* prefix)
	     (set! *c-port* (open-output-file f-name))
	     (if (not (output-port? *c-port*))
		 (error *bigloo-name* "Can't open file for output" f-name))))))

;*---------------------------------------------------------------------*/
;*    stop-emission! ...                                               */
;*---------------------------------------------------------------------*/
(define (stop-emission!)
   (cond
      ((not (output-port? *c-port*))
       #f)
      ((eq? *c-port* (current-output-port))
       #f)
      (else
       (flush-output-port *c-port*)
       (close-output-port *c-port*)
       (set! *c-port* #f)
       *dest-prefix*)))

;*---------------------------------------------------------------------*/
;*    *max-col* ...                                                    */
;*---------------------------------------------------------------------*/
(define *max-col* 79)

;*---------------------------------------------------------------------*/
;*    emit-comment ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-comment string fill)
   (let ((string (if (>fx (string-length string) (-fx *max-col* 8))
		     (substring string 0 (-fx *max-col* 9))
		     string)))
      (display "/*" *c-port*)
      (let ((len (string-length string)))
	 (if (=fx len 0)
	     (fprint *c-port* (make-string (-fx *max-col* 4) fill) "*/")
	     (begin
		(display (make-string 2 fill) *c-port*)
		(display #\space *c-port*)
		(display string *c-port*)
		(display #\space *c-port*)
		(fprint *c-port*
			(make-string (-fx *max-col* (+ 8 len)) fill)
			"*/"))))))

;*---------------------------------------------------------------------*/
;*    emit-license ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-license)
   (let ((in (open-input-string (bigloo-license))))
      (let loop ((str (read-line in)))
	 (if (eof-object? str)
	     (close-input-port in)
	     (begin
		(emit-comment str #\space)
		(loop (read-line in)))))))

;*---------------------------------------------------------------------*/
;*    emit-header ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-header)
   (emit-comment "" #\=)
   (emit-comment (let ((p (open-output-string)))
		    (display *src-files* p)
		    (close-output-port p))
		 #\space)
   (emit-comment *bigloo-name* #\space)
   (emit-comment (string-append *bigloo-author* " (c)      " *bigloo-date*)
		 #\space)
   (if *bigloo-licensing?* (emit-license))
   (emit-comment "" #\=)
   (newline *c-port*))

;*---------------------------------------------------------------------*/
;*    emit-garbage-collector-selection ...                             */
;*---------------------------------------------------------------------*/
(define (emit-garbage-collector-selection)
   (fprint *c-port* "/* GC selection */")
   (case *garbage-collector*
      ((boehm)
       (fprint *c-port* #"#define THE_GC BOEHM_GC\n"))
      ((bumpy)
       (fprint *c-port* "#define THE_GC BOEHM_GC")
       (fprint *c-port* #"#define BUMPY_GC\n"))
      (else
       (error "emit-garbage-collector-selection"
	      "Can't emit code for gc"
	      *garbage-collector*))))
       
;*---------------------------------------------------------------------*/
;*    emit-include ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-include)
   ;; the regular include files
   (for-each (lambda (i) (fprint *c-port* "#include <" i ">"))
	     (reverse! *include-foreign*))
   ;; the user additional includes
   (for-each (lambda (i) (fprint *c-port* "#include <" i ">"))
	     (reverse! *additional-include-foreign*))
   (newline *c-port*))

;*---------------------------------------------------------------------*/
;*    emit-debug-activation ...                                        */
;*---------------------------------------------------------------------*/
(define (emit-debug-activation)
   (fprint *c-port* "/* debug mode */")
   (fprint *c-port* "#define BIGLOO_DEBUG 1")
   (newline *c-port*))

;*---------------------------------------------------------------------*/
;*    emit-main ...                                                    */
;*---------------------------------------------------------------------*/
(define (emit-main)
   (fprint *c-port* #"extern int _bigloo_main();\n")
   (fprint *c-port* "int BIGLOO_MAIN(int argc, char *argv[])")
   (fprint *c-port*
	   "{"
	   (if (number? *user-heap-size*)
	       (string-append "extern long heap_size; heap_size = "
			      (integer->string *user-heap-size*)
			      ";")
	       "")
	   "_bigloo_main(argc, argv);}")
   (newline *c-port*))
