;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cgen/cop.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  2 13:53:24 1996                          */
;*    Last change :  Sun May 24 07:18:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The intermediate structure to emit c code.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_cop
   
   (import type_type
	   ast_var
	   ast_node)
   
   (export (class cop
	      ;; the source line number associated to this instruction
	      (loc::obj (default #f)))

	   (class clabel::cop
	      (name::bstring read-only)
	      (used?::bool (default #f))
	      (body (default #unspecified)))

	   (class cgoto::cop
	      (label::clabel read-only))

	   (class block::cop
	      (body::cop read-only))

	   (class creturn::cop
	      (value::cop read-only))

	   (class cvoid::cop
	      (value::cop read-only))

	   (class catom::cop
	      (value read-only))
	   
	   (class varc::cop
	      (variable::variable read-only))
	   
	   (class cpragma::cop
	      (format::bstring read-only)
	      (args read-only))

	   (class ccast::cop
	      (type::type read-only)
	      (arg::cop read-only))
	   
	   (class csequence::cop
	      (c-exp?::bool read-only (default #f))
	      (cops read-only))

	   (class nop::cop)

	   (class stop::cop
	      (value::cop read-only))

	   (class csetq::cop
	      (var::varc read-only)
	      (value::cop read-only))

	   (class cif::cop
	      (test::cop read-only)
	      (true::cop read-only)
	      (false::cop read-only))
	   
	   (class local-var::cop
	      (vars read-only))
	   
	   (class cfuncall::cop
	      (fun::cop read-only)
	      (args read-only)
	      (strength::symbol read-only))
	   
	   (class capply::cop
	      (fun::cop read-only)
	      (arg::cop read-only))

	   (class capp::cop
	      (fun::cop read-only)
	      (args read-only))

	   (class cfail::cop
	      (proc::cop read-only)
	      (msg::cop read-only)
	      (obj::cop read-only))

	   (class cswitch::cop
	      (test::cop read-only)
	      (clauses read-only))

	   (class cmake-box::cop
	      (value::cop read-only))

	   (class cbox-ref::cop
	      (var::cop read-only))

	   (class cbox-set!::cop
	      (var::cop read-only)
	      (value::cop read-only))
	   
	   (class cset-ex-it::cop
	      (exit::cop read-only)
	      (jump-value::cop read-only)
	      (body::cop read-only))

	   (class cjump-ex-it::cop
	      (exit::cop read-only)
	      (value::cop read-only))

	   (wide-class sfun/c::sfun
	      (label::clabel read-only)
	      integrated::bool)

	   (class bdb-block::cop
	      (body::cop read-only))))
	      

	   


