;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cfa/struct.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 18:06:51 1995                          */
;*    Last change :  Sun Nov 29 09:55:02 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The struct approximation management                              */
;*    -------------------------------------------------------------    */
;*    All structs fields approximation are merged into on single set.  */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_struct
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    cfa_info
	    cfa_loose
	    cfa_iterate
	    cfa_cfa
	    cfa_setup
	    cfa_approx
	    cfa_stack))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-make-struct-app ...                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-make-struct-app)
   (with-access::pre-make-struct-app node (fun args)
      (node-setup*! args)
      (let* ((owner (pre-make-struct-app-owner node))
	     (node  (shrink! node)))
	 (let ((wnode (widen!::make-struct-app node
			 (owner owner)
			 (approx (make-empty-approx))
			 (value-approx (make-empty-approx)))))
	    (trace (cfa 3) "    make-struct-app: " (shape node) #\Newline)
	    (make-struct-app-approx-set! wnode
					 (make-type-alloc-approx *struct*
								 node))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-struct-ref-app ...                             */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-struct-ref-app)
   (with-access::pre-struct-ref-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::struct-ref-app node (approx (make-type-approx *obj*))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-struct-set!-app ...                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-struct-set!-app)
   (with-access::pre-struct-set!-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::struct-set!-app node (approx (make-type-approx *unspec*))))))

;*---------------------------------------------------------------------*/
;*    cfa! ::make-struct-app ...                                       */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::make-struct-app)
   (with-access::make-struct-app node (args value-approx approx)
      (trace (cfa 4) "   make-struct: " (shape node) #\Newline)
      (cfa! (car args))
      (let ((init-value-approx (cfa! (cadr args))))
	 (union-approx! value-approx init-value-approx)
	 approx)))

;*---------------------------------------------------------------------*/
;*    cfa! ::struct-ref-app ...                                        */
;*    -------------------------------------------------------------    */
;*    This function differs from the vector-ref one in the several     */
;*    points. In particular we don't have to take care to add *obj*    */
;*    in the approximation of struct-ref because the type of           */
;*    struct-ref _is_ *obj*.                                           */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::struct-ref-app)
   (with-access::struct-ref-app node (args approx)
      ;; even if we don't use it we must walk on the 2nd
      ;; argument of a struct ref.
      (cfa! (cadr args))
      (let ((struct-approx (cfa! (car args))))
	 (trace (cfa 4) "    struct-ref: " (shape node) #\Newline)
	 ;; we check for top
	 (if (approx-top? struct-approx)
	     (approx-set-top! approx))
	 (for-each-approx-alloc
	  (lambda (app)
	     (if (make-struct-app? app)
		 (with-access::make-struct-app app (value-approx)
		    (union-approx! approx value-approx)
		    (approx-set-type! value-approx (approx-type approx)))))
	  struct-approx))
      approx))

;*---------------------------------------------------------------------*/
;*    cfa! ::struct-set!-app ...                                       */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::struct-set!-app)
   (with-access::struct-set!-app node (args approx)
      ;; even if we don't use it we must walk on the 2nd
      ;; argument of a struct ref.
      (cfa! (cadr args))
      (let ((struct-approx (cfa! (car args)))
	    (val-approx (cfa! (caddr args))))
	 (trace (cfa 4) "   struct-set!: " (shape node) #\Newline)
	 ;; we check if we have top on the structure
	 (if (approx-top? struct-approx)
	     ;; yes, we have, hence we loose every thing.
	     (loose! val-approx 'all)
	     (for-each-approx-alloc
	      (lambda (app)
		 (if (make-struct-app? app)
		     (with-access::make-struct-app app (value-approx)
			(union-approx! value-approx val-approx))))
	      struct-approx)))
      approx))
      
;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Loosing a struct means that struct-ref now returns `obj' and     */
;*    `top' and that all contained allocation are also lost but        */
;*    it does not change anything on the allocation itself.            */
;*---------------------------------------------------------------------*/
(define-method (loose-alloc! alloc::make-struct-app)
   (with-access::make-struct-app alloc (lost-stamp value-approx stackable?)
      (if (=fx lost-stamp *cfa-stamp*)
	  #unspecified
	  (begin
	     (trace (cfa 2) " *** loose: " (shape alloc) #\Newline)
	     (set! lost-stamp *cfa-stamp*)
	     (set! stackable? #f)
	     (for-each-approx-alloc loose-alloc! value-approx)
	     (approx-set-type! value-approx *obj*)
	     (approx-set-top! value-approx)))))
   
;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*---------------------------------------------------------------------*/
(define-method (stack-loose-alloc! alloc::make-struct-app cowner)
   (with-access::make-struct-app alloc
	 (value-approx stackable? owner stack-stamp)
      (if (or (not stackable?) (memq cowner stack-stamp))
	  #unspecified
	  (begin
	     (set! stack-stamp (cons cowner stack-stamp))
	     (if (or (not (variable? cowner)) (eq? owner cowner))
		 (begin
		    (trace (cfa 2)
			   " *** stack-loose: " (shape alloc) #\Newline)
		    (set! stackable? #f)
		    (for-each-approx-alloc (lambda (alloc)
					      (stack-loose-alloc! alloc 'all))
					   value-approx))
		 (for-each-approx-alloc (lambda (alloc)
					   (stack-loose-alloc! alloc cowner))
					value-approx))))))
   
;*---------------------------------------------------------------------*/
;*    stack! ::make-struct-app ...                                     */
;*---------------------------------------------------------------------*/
(define-method (stack! node::make-struct-app)
   (with-access::make-struct-app node (fun args stackable? lost-stamp)
      (trace (cfa 2)
	     "stack(make-struct-app): s?: " stackable? #\Newline)
      (stack*! args)
      (node-heap->stack! node (and (=fx lost-stamp -1) stackable?))))
