;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cfa/show.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar  8 18:51:37 1995                          */
;*    Last change :  Wed Jun  3 15:40:23 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We show the result of the cfa.                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_show
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_trace
	    tools_speek
	    write_scheme
	    type_type
	    ast_var
	    ast_node
	    cfa_info
	    cfa_approx
	    cfa_collect
	    cfa_iterate)
   (export  (show-cfa-nb-iterations)
	    (show-cfa-results globals)))

;*---------------------------------------------------------------------*/
;*    show-cfa-nb-iterations ...                                       */
;*---------------------------------------------------------------------*/
(define (show-cfa-nb-iterations)
   (verbose 2 "      (" (+fx 1 *cfa-stamp*) " Iterations)" #\Newline))

;*---------------------------------------------------------------------*/
;*    show-cfa-results ...                                             */
;*---------------------------------------------------------------------*/
(define (show-cfa-results globals)
   (trace cfa
	  #\Newline
	  "============================================" #\Newline
	  "cfa-results:" #\Newline)
   (if (pair? (get-allocs)) (trace cfa #\Newline))
   (for-each (lambda (a)
		(trace cfa (node-key a) ": " (shape a) " """ #\Newline))
	     (get-allocs))
   (trace cfa #\Newline)
   (trace cfa
	  (let ((old-case *pp-case*))
	     (set! *pp-case* 'lower)
	     (for-each (lambda (g)
			  (let ((fun (global-value g)))
			     (write-scheme-comment *trace-port* (shape g))
			     (pp `(,(case (sfun-class fun)
				       ((sgfun)
					'define-generic)
				       ((sifun)
					'define-inline)
				       ((smfun)
					'define-method)
				       (else
					'define))
				   (,(shape g)
				    ,@(map shape (sfun-args fun)))
				   ,(shape (sfun-body fun)))
				 *trace-port*)))
		       globals)
	     (set! *pp-case* old-case)
	     #\Newline #\Newline)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-method (shape local::reshaped-local)
   (let ((port (open-output-string)))
      (display (call-next-method) port)
      (cfa-variable-shape local port)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-method (shape global::reshaped-global)
   (let ((port (open-output-string)))
      (display (call-next-method) port)
      (cfa-variable-shape global port)))
   
;*---------------------------------------------------------------------*/
;*    cfa-variable-shape ...                                           */
;*---------------------------------------------------------------------*/
(define (cfa-variable-shape variable port)
   (let ((value (variable-value variable)))
      (cond 
	 ((svar/Cinfo? value)
	  (display " " port)
	  (display (shape (svar/Cinfo-approx value)) port))
	 ((cvar/Cinfo? value)
	  (display " " port)
	  (display (shape (cvar/Cinfo-approx value)) port))
	 ((scnst/Cinfo? value)
	  (display " " port)
	  (display (shape (scnst/Cinfo-approx value)) port))
	 ((intern-sfun/Cinfo? value)
	  (display " " port)
	  (display (shape (intern-sfun/Cinfo-approx value)) port))
	 ((extern-sfun/Cinfo? value)
	  (display " " port)
	  (display (shape (extern-sfun/Cinfo-approx value)) port))
	 ((cfun/Cinfo? value)
	  (display " " port)
	  (display (shape (cfun/Cinfo-approx value)) port)))
      (string->symbol (close-output-port port))))
