/*===========================================================================*/
/*   (Cfa/set.scm)                                                           */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;


static obj_t method_init_76_cfa_set();
static long max_small_set_size_55_cfa_set;
extern obj_t create_struct(obj_t, long);
extern obj_t set_union__206_cfa_set(obj_t, obj_t);
static obj_t set_member__236_cfa_set(obj_t, obj_t);
extern obj_t module_initialization_70_cfa_set(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_tools_shape(long, char *);
extern obj_t module_initialization_70_tools_error(long, char *);
extern obj_t module_initialization_70_cfa_approx(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___r4_vectors_6_8(long, char *);
static obj_t _set__list_15_cfa_set(obj_t, obj_t);
static obj_t _set_extend__167_cfa_set(obj_t, obj_t, obj_t);
extern obj_t list__vector_101___r4_vectors_6_8(obj_t);
extern obj_t make_set__25_cfa_set(obj_t);
static obj_t imported_modules_init_94_cfa_set();
extern obj_t set_extend__187_cfa_set(obj_t, obj_t);
static obj_t _set__114_cfa_set(obj_t, obj_t);
static obj_t _set_union__126_cfa_set(obj_t, obj_t, obj_t);
static obj_t library_modules_init_112_cfa_set();
extern obj_t set_length_165_cfa_set(obj_t);
static obj_t toplevel_init_63_cfa_set();
static obj_t _declare_set_1819_98_cfa_set(obj_t, obj_t);
extern obj_t open_input_string(obj_t);
static obj_t _set__vector_80_cfa_set(obj_t, obj_t);
extern bool_t set__44_cfa_set(obj_t);
static long max_large_size_22_cfa_set;
extern obj_t set__vector_66_cfa_set(obj_t);
static obj_t _make_set__72_cfa_set(obj_t, obj_t);
extern obj_t shape_tools_shape(obj_t);
extern obj_t make_string(long, unsigned char);
extern obj_t internal_error_43_tools_error(obj_t, obj_t, obj_t);
extern obj_t set_for_each_94_cfa_set(obj_t, obj_t);
extern obj_t read___reader(obj_t);
static obj_t _set_length_66_cfa_set(obj_t, obj_t);
extern obj_t declare_set__41_cfa_set(obj_t);
static obj_t _set_for_each1820_13_cfa_set(obj_t, obj_t, obj_t);
static obj_t require_initialization_114_cfa_set = BUNSPEC;
static obj_t set_union_2__160_cfa_set(obj_t, obj_t);
extern obj_t set__list_248_cfa_set(obj_t);
static obj_t cnst_init_137_cfa_set();
static obj_t __cnst[3];

DEFINE_EXPORT_PROCEDURE(declare_set__env_66_cfa_set, _declare_set_1819_98_cfa_set1839, _declare_set_1819_98_cfa_set, 0L, 1);
DEFINE_EXPORT_PROCEDURE(set_for_each_env_0_cfa_set, _set_for_each1820_13_cfa_set1840, _set_for_each1820_13_cfa_set, 0L, 2);
DEFINE_EXPORT_PROCEDURE(set__env_43_cfa_set, _set__114_cfa_set1841, _set__114_cfa_set, 0L, 1);
DEFINE_EXPORT_PROCEDURE(set__vector_env_86_cfa_set, _set__vector_80_cfa_set1842, _set__vector_80_cfa_set, 0L, 1);
DEFINE_EXPORT_PROCEDURE(set_extend__env_151_cfa_set, _set_extend__167_cfa_set1843, _set_extend__167_cfa_set, 0L, 2);
DEFINE_EXPORT_PROCEDURE(set_union__env_227_cfa_set, _set_union__126_cfa_set1844, va_generic_entry, _set_union__126_cfa_set, -2);
DEFINE_EXPORT_PROCEDURE(make_set__env_47_cfa_set, _make_set__72_cfa_set1845, _make_set__72_cfa_set, 0L, 1);
DEFINE_STRING(string1833_cfa_set, string1833_cfa_set1846, "LARGE-SET SMALL-SET META-SET ", 29);
DEFINE_STRING(string1832_cfa_set, string1832_cfa_set1847, "argument not a set", 18);
DEFINE_STRING(string1831_cfa_set, string1831_cfa_set1848, "set-length", 10);
DEFINE_STRING(string1829_cfa_set, string1829_cfa_set1849, "Incompatible sets", 17);
DEFINE_STRING(string1830_cfa_set, string1830_cfa_set1850, "set-for-each", 12);
DEFINE_STRING(string1828_cfa_set, string1828_cfa_set1851, "set-union!", 10);
DEFINE_STRING(string1827_cfa_set, string1827_cfa_set1852, "set-member?", 11);
DEFINE_STRING(string1826_cfa_set, string1826_cfa_set1853, "Not a set", 9);
DEFINE_STRING(string1825_cfa_set, string1825_cfa_set1854, "set-extend!", 11);
DEFINE_STRING(string1824_cfa_set, string1824_cfa_set1855, "Not a meta-set", 14);
DEFINE_STRING(string1823_cfa_set, string1823_cfa_set1856, "make-set", 8);
DEFINE_STRING(string1822_cfa_set, string1822_cfa_set1857, "Too many element in set", 23);
DEFINE_STRING(string1821_cfa_set, string1821_cfa_set1858, "define-set!", 11);
DEFINE_EXPORT_PROCEDURE(set__list_env_124_cfa_set, _set__list_15_cfa_set1859, _set__list_15_cfa_set, 0L, 1);
DEFINE_EXPORT_PROCEDURE(set_length_env_35_cfa_set, _set_length_66_cfa_set1860, _set_length_66_cfa_set, 0L, 1);


/* module-initialization */ obj_t 
module_initialization_70_cfa_set(long checksum_2015, char *from_2016)
{
   if (CBOOL(require_initialization_114_cfa_set))
     {
	require_initialization_114_cfa_set = BBOOL(((bool_t) 0));
	library_modules_init_112_cfa_set();
	cnst_init_137_cfa_set();
	imported_modules_init_94_cfa_set();
	method_init_76_cfa_set();
	toplevel_init_63_cfa_set();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_cfa_set()
{
   module_initialization_70___r4_vectors_6_8(((long) 0), "CFA_SET");
   module_initialization_70___reader(((long) 0), "CFA_SET");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_cfa_set()
{
   {
      obj_t cnst_port_138_2007;
      cnst_port_138_2007 = open_input_string(string1833_cfa_set);
      {
	 long i_2008;
	 i_2008 = ((long) 2);
       loop_2009:
	 {
	    bool_t test1834_2010;
	    test1834_2010 = (i_2008 == ((long) -1));
	    if (test1834_2010)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg1835_2011;
		    {
		       obj_t list1836_2012;
		       {
			  obj_t arg1837_2013;
			  arg1837_2013 = BNIL;
			  list1836_2012 = MAKE_PAIR(cnst_port_138_2007, arg1837_2013);
		       }
		       arg1835_2011 = read___reader(list1836_2012);
		    }
		    CNST_TABLE_SET(i_2008, arg1835_2011);
		 }
		 {
		    int aux_2014;
		    {
		       long aux_2033;
		       aux_2033 = (i_2008 - ((long) 1));
		       aux_2014 = (int) (aux_2033);
		    }
		    {
		       long i_2036;
		       i_2036 = (long) (aux_2014);
		       i_2008 = i_2036;
		       goto loop_2009;
		    }
		 }
	      }
	 }
      }
   }
}


/* toplevel-init */ obj_t 
toplevel_init_63_cfa_set()
{
   {
      long ptr_align_30_743;
      ptr_align_30_743 = PTR_ALIGNMENT;
      {
	 long aux_2039;
	 {
	    long aux_2040;
	    aux_2040 = (ptr_align_30_743 + ((long) 3));
	    aux_2039 = (((long) 1) << aux_2040);
	 }
	 max_small_set_size_55_cfa_set = (aux_2039 - ptr_align_30_743);
      }
   }
   return (max_large_size_22_cfa_set = ((long) 10000),
      BUNSPEC);
}


/* declare-set! */ obj_t 
declare_set__41_cfa_set(obj_t table_31)
{
   {
      long cardinal_798;
      cardinal_798 = VECTOR_LENGTH(table_31);
      {
	 long quotient_799;
	 quotient_799 = (cardinal_798 / ((long) 8));
	 {
	    long remainder_800;
	    remainder_800 = (cardinal_798 % ((long) 8));
	    {
	       long size_801;
	       if ((cardinal_798 < max_small_set_size_55_cfa_set))
		 {
		    size_801 = ((long) 0);
		 }
	       else
		 {
		    if ((remainder_800 == ((long) 0)))
		      {
			 size_801 = (quotient_799 + ((long) 1));
		      }
		    else
		      {
			 size_801 = (quotient_799 + ((long) 2));
		      }
		 }
	       {
		  if ((cardinal_798 >= ((long) 10000)))
		    {
		       {
			  obj_t arg1501_805;
			  arg1501_805 = shape_tools_shape(table_31);
			  return internal_error_43_tools_error(string1821_cfa_set, string1822_cfa_set, arg1501_805);
		       }
		    }
		  else
		    {
		       if ((((long) 0) == size_801))
			 {
			    {
			       long i_807;
			       long pow_808;
			       i_807 = ((long) 0);
			       pow_808 = ((long) 1);
			     loop_809:
			       if ((i_807 == cardinal_798))
				 {
				    {
				       obj_t new_1518;
				       {
					  obj_t aux_2061;
					  aux_2061 = CNST_TABLE_REF(((long) 0));
					  new_1518 = create_struct(aux_2061, ((long) 2));
				       }
				       {
					  obj_t aux_2064;
					  aux_2064 = BINT(size_801);
					  STRUCT_SET(new_1518, ((long) 1), aux_2064);
				       }
				       STRUCT_SET(new_1518, ((long) 0), table_31);
				       return new_1518;
				    }
				 }
			       else
				 {
				    {
				       node_effect_213_t node_1533;
				       obj_t key_1534;
				       {
					  obj_t aux_2068;
					  aux_2068 = VECTOR_REF(table_31, i_807);
					  node_1533 = (node_effect_213_t) (aux_2068);
				       }
				       key_1534 = BINT(pow_808);
				       ((((node_effect_213_t) CREF(node_1533))->key) = ((obj_t) key_1534), BUNSPEC);
				    }
				    {
				       long pow_2075;
				       long i_2073;
				       i_2073 = (i_807 + ((long) 1));
				       pow_2075 = (((long) 2) * pow_808);
				       pow_808 = pow_2075;
				       i_807 = i_2073;
				       goto loop_809;
				    }
				 }
			    }
			 }
		       else
			 {
			    {
			       long i_814;
			       long quotient_815;
			       long mask_816;
			       i_814 = ((long) 0);
			       quotient_815 = ((long) 0);
			       mask_816 = ((long) 1);
			     loop_817:
			       if ((i_814 == cardinal_798))
				 {
				    {
				       obj_t new_1545;
				       {
					  obj_t aux_2079;
					  aux_2079 = CNST_TABLE_REF(((long) 0));
					  new_1545 = create_struct(aux_2079, ((long) 2));
				       }
				       {
					  obj_t aux_2082;
					  aux_2082 = BINT(size_801);
					  STRUCT_SET(new_1545, ((long) 1), aux_2082);
				       }
				       STRUCT_SET(new_1545, ((long) 0), table_31);
				       return new_1545;
				    }
				 }
			       else
				 {
				    if ((mask_816 == ((long) 256)))
				      {
					 {
					    long mask_2090;
					    long quotient_2088;
					    quotient_2088 = (quotient_815 + ((long) 1));
					    mask_2090 = ((long) 1);
					    mask_816 = mask_2090;
					    quotient_815 = quotient_2088;
					    goto loop_817;
					 }
				      }
				    else
				      {
					 {
					    obj_t arg1513_822;
					    obj_t arg1514_823;
					    arg1513_822 = VECTOR_REF(table_31, i_814);
					    {
					       obj_t aux_2094;
					       obj_t aux_2092;
					       aux_2094 = BINT(mask_816);
					       aux_2092 = BINT(quotient_815);
					       arg1514_823 = MAKE_PAIR(aux_2092, aux_2094);
					    }
					    {
					       node_effect_213_t node_1566;
					       node_1566 = (node_effect_213_t) (arg1513_822);
					       ((((node_effect_213_t) CREF(node_1566))->key) = ((obj_t) arg1514_823), BUNSPEC);
					    }
					 }
					 {
					    long mask_2101;
					    long i_2099;
					    i_2099 = (i_814 + ((long) 1));
					    mask_2101 = (mask_816 * ((long) 2));
					    mask_816 = mask_2101;
					    i_814 = i_2099;
					    goto loop_817;
					 }
				      }
				 }
			    }
			 }
		    }
	       }
	    }
	 }
      }
   }
}


/* _declare-set!1819 */ obj_t 
_declare_set_1819_98_cfa_set(obj_t env_1983, obj_t table_1984)
{
   return declare_set__41_cfa_set(table_1984);
}


/* make-set! */ obj_t 
make_set__25_cfa_set(obj_t meta_set_245_32)
{
   {
      bool_t test_2104;
      if (STRUCTP(meta_set_245_32))
	{
	   obj_t aux_2109;
	   obj_t aux_2107;
	   aux_2109 = CNST_TABLE_REF(((long) 0));
	   aux_2107 = STRUCT_KEY(meta_set_245_32);
	   test_2104 = (aux_2107 == aux_2109);
	}
      else
	{
	   test_2104 = ((bool_t) 0);
	}
      if (test_2104)
	{
	   bool_t test_2112;
	   {
	      long aux_2113;
	      {
		 obj_t aux_2114;
		 aux_2114 = STRUCT_REF(meta_set_245_32, ((long) 1));
		 aux_2113 = (long) CINT(aux_2114);
	      }
	      test_2112 = (aux_2113 == ((long) 0));
	   }
	   if (test_2112)
	     {
		{
		   obj_t new_1589;
		   {
		      obj_t aux_2118;
		      aux_2118 = CNST_TABLE_REF(((long) 1));
		      new_1589 = create_struct(aux_2118, ((long) 2));
		   }
		   STRUCT_SET(new_1589, ((long) 1), meta_set_245_32);
		   {
		      obj_t aux_2122;
		      aux_2122 = BINT(((long) 0));
		      STRUCT_SET(new_1589, ((long) 0), aux_2122);
		   }
		   return new_1589;
		}
	     }
	   else
	     {
		{
		   obj_t arg1522_830;
		   {
		      obj_t arg1524_831;
		      arg1524_831 = STRUCT_REF(meta_set_245_32, ((long) 1));
		      {
			 obj_t list1525_832;
			 {
			    obj_t aux_2126;
			    aux_2126 = BCHAR(((unsigned char) '\000'));
			    list1525_832 = MAKE_PAIR(aux_2126, BNIL);
			 }
			 {
			    obj_t res1818_1611;
			    {
			       unsigned char aux_2133;
			       long aux_2129;
			       {
				  obj_t aux_2134;
				  aux_2134 = CAR(list1525_832);
				  aux_2133 = (unsigned char) CCHAR(aux_2134);
			       }
			       {
				  int aux_2130;
				  aux_2130 = CINT(arg1524_831);
				  aux_2129 = (long) (aux_2130);
			       }
			       res1818_1611 = make_string(aux_2129, aux_2133);
			    }
			    arg1522_830 = res1818_1611;
			 }
		      }
		   }
		   {
		      obj_t new_1614;
		      {
			 obj_t aux_2138;
			 aux_2138 = CNST_TABLE_REF(((long) 2));
			 new_1614 = create_struct(aux_2138, ((long) 2));
		      }
		      STRUCT_SET(new_1614, ((long) 1), meta_set_245_32);
		      STRUCT_SET(new_1614, ((long) 0), arg1522_830);
		      return new_1614;
		   }
		}
	     }
	}
      else
	{
	   {
	      obj_t arg1531_838;
	      arg1531_838 = shape_tools_shape(meta_set_245_32);
	      return internal_error_43_tools_error(string1823_cfa_set, string1824_cfa_set, arg1531_838);
	   }
	}
   }
}


/* _make-set! */ obj_t 
_make_set__72_cfa_set(obj_t env_1985, obj_t meta_set_245_1986)
{
   return make_set__25_cfa_set(meta_set_245_1986);
}


/* set? */ bool_t 
set__44_cfa_set(obj_t obj_33)
{
   {
      bool_t _ortest_1435_1627;
      if (STRUCTP(obj_33))
	{
	   obj_t aux_2150;
	   obj_t aux_2148;
	   aux_2150 = CNST_TABLE_REF(((long) 1));
	   aux_2148 = STRUCT_KEY(obj_33);
	   _ortest_1435_1627 = (aux_2148 == aux_2150);
	}
      else
	{
	   _ortest_1435_1627 = ((bool_t) 0);
	}
      if (_ortest_1435_1627)
	{
	   return _ortest_1435_1627;
	}
      else
	{
	   if (STRUCTP(obj_33))
	     {
		obj_t aux_2158;
		obj_t aux_2156;
		aux_2158 = CNST_TABLE_REF(((long) 2));
		aux_2156 = STRUCT_KEY(obj_33);
		return (aux_2156 == aux_2158);
	     }
	   else
	     {
		return ((bool_t) 0);
	     }
	}
   }
}


/* _set? */ obj_t 
_set__114_cfa_set(obj_t env_1987, obj_t obj_1988)
{
   {
      bool_t aux_2161;
      aux_2161 = set__44_cfa_set(obj_1988);
      return BBOOL(aux_2161);
   }
}


/* set-extend! */ obj_t 
set_extend__187_cfa_set(obj_t set_34, obj_t obj_35)
{
   {
      {
	 bool_t test_2164;
	 if (STRUCTP(set_34))
	   {
	      obj_t aux_2169;
	      obj_t aux_2167;
	      aux_2169 = CNST_TABLE_REF(((long) 1));
	      aux_2167 = STRUCT_KEY(set_34);
	      test_2164 = (aux_2167 == aux_2169);
	   }
	 else
	   {
	      test_2164 = ((bool_t) 0);
	   }
	 if (test_2164)
	   {
	      {
		 obj_t aux_2172;
		 {
		    long aux_2173;
		    {
		       long aux_2178;
		       long aux_2174;
		       {
			  obj_t aux_2179;
			  {
			     node_effect_213_t node_1678;
			     node_1678 = (node_effect_213_t) (obj_35);
			     aux_2179 = (((node_effect_213_t) CREF(node_1678))->key);
			  }
			  aux_2178 = (long) CINT(aux_2179);
		       }
		       {
			  obj_t aux_2175;
			  aux_2175 = STRUCT_REF(set_34, ((long) 0));
			  aux_2174 = (long) CINT(aux_2175);
		       }
		       aux_2173 = (aux_2174 | aux_2178);
		    }
		    aux_2172 = BINT(aux_2173);
		 }
		 STRUCT_SET(set_34, ((long) 0), aux_2172);
	      }
	      return BUNSPEC;
	   }
	 else
	   {
	      bool_t test_2186;
	      if (STRUCTP(set_34))
		{
		   obj_t aux_2191;
		   obj_t aux_2189;
		   aux_2191 = CNST_TABLE_REF(((long) 2));
		   aux_2189 = STRUCT_KEY(set_34);
		   test_2186 = (aux_2189 == aux_2191);
		}
	      else
		{
		   test_2186 = ((bool_t) 0);
		}
	      if (test_2186)
		{
		   {
		      obj_t key_848;
		      {
			 node_effect_213_t node_1660;
			 node_1660 = (node_effect_213_t) (obj_35);
			 key_848 = (((node_effect_213_t) CREF(node_1660))->key);
		      }
		      {
			 obj_t the_set_132_849;
			 the_set_132_849 = STRUCT_REF(set_34, ((long) 0));
			 {
			    obj_t quotient_850;
			    quotient_850 = CAR(key_848);
			    {
			       {
				  unsigned char aux_2200;
				  long aux_2198;
				  {
				     unsigned char aux_2207;
				     unsigned char aux_2201;
				     {
					long aux_2208;
					aux_2208 = (long) CINT(quotient_850);
					aux_2207 = STRING_REF(the_set_132_849, aux_2208);
				     }
				     {
					long aux_2202;
					{
					   obj_t aux_2203;
					   aux_2203 = CDR(key_848);
					   aux_2202 = (long) CINT(aux_2203);
					}
					aux_2201 = (aux_2202);
				     }
				     aux_2200 = (aux_2201 | aux_2207);
				  }
				  aux_2198 = (long) CINT(quotient_850);
				  STRING_SET(the_set_132_849, aux_2198, aux_2200);
			       }
			       return BUNSPEC;
			    }
			 }
		      }
		   }
		}
	      else
		{
		   {
		      obj_t arg1536_846;
		      arg1536_846 = shape_tools_shape(set_34);
		      return internal_error_43_tools_error(string1825_cfa_set, string1826_cfa_set, arg1536_846);
		   }
		}
	   }
      }
   }
}


/* _set-extend! */ obj_t 
_set_extend__167_cfa_set(obj_t env_1989, obj_t set_1990, obj_t obj_1991)
{
   return set_extend__187_cfa_set(set_1990, obj_1991);
}


/* set-member? */ obj_t 
set_member__236_cfa_set(obj_t set_36, obj_t obj_37)
{
   {
      {
	 bool_t test_2216;
	 if (STRUCTP(set_36))
	   {
	      obj_t aux_2221;
	      obj_t aux_2219;
	      aux_2221 = CNST_TABLE_REF(((long) 1));
	      aux_2219 = STRUCT_KEY(set_36);
	      test_2216 = (aux_2219 == aux_2221);
	   }
	 else
	   {
	      test_2216 = ((bool_t) 0);
	   }
	 if (test_2216)
	   {
	      {
		 bool_t aux_2224;
		 {
		    long aux_2225;
		    {
		       long aux_2230;
		       long aux_2226;
		       {
			  obj_t aux_2231;
			  {
			     node_effect_213_t node_1720;
			     node_1720 = (node_effect_213_t) (obj_37);
			     aux_2231 = (((node_effect_213_t) CREF(node_1720))->key);
			  }
			  aux_2230 = (long) CINT(aux_2231);
		       }
		       {
			  obj_t aux_2227;
			  aux_2227 = STRUCT_REF(set_36, ((long) 0));
			  aux_2226 = (long) CINT(aux_2227);
		       }
		       aux_2225 = (aux_2226 & aux_2230);
		    }
		    aux_2224 = (aux_2225 > ((long) 0));
		 }
		 return BBOOL(aux_2224);
	      }
	   }
	 else
	   {
	      bool_t test_2238;
	      if (STRUCTP(set_36))
		{
		   obj_t aux_2243;
		   obj_t aux_2241;
		   aux_2243 = CNST_TABLE_REF(((long) 2));
		   aux_2241 = STRUCT_KEY(set_36);
		   test_2238 = (aux_2241 == aux_2243);
		}
	      else
		{
		   test_2238 = ((bool_t) 0);
		}
	      if (test_2238)
		{
		   {
		      bool_t aux_2246;
		      {
			 obj_t key_869;
			 {
			    node_effect_213_t node_1703;
			    node_1703 = (node_effect_213_t) (obj_37);
			    key_869 = (((node_effect_213_t) CREF(node_1703))->key);
			 }
			 {
			    {
			       long aux_2249;
			       {
				  long aux_2254;
				  long aux_2250;
				  {
				     unsigned char aux_2255;
				     {
					long aux_2258;
					obj_t aux_2256;
					{
					   obj_t aux_2259;
					   aux_2259 = CAR(key_869);
					   aux_2258 = (long) CINT(aux_2259);
					}
					aux_2256 = STRUCT_REF(set_36, ((long) 0));
					aux_2255 = STRING_REF(aux_2256, aux_2258);
				     }
				     aux_2254 = (aux_2255);
				  }
				  {
				     obj_t aux_2251;
				     aux_2251 = CDR(key_869);
				     aux_2250 = (long) CINT(aux_2251);
				  }
				  aux_2249 = (aux_2250 & aux_2254);
			       }
			       aux_2246 = (aux_2249 > ((long) 0));
			    }
			 }
		      }
		      return BBOOL(aux_2246);
		   }
		}
	      else
		{
		   {
		      obj_t arg1554_867;
		      arg1554_867 = shape_tools_shape(set_36);
		      return internal_error_43_tools_error(string1827_cfa_set, string1826_cfa_set, arg1554_867);
		   }
		}
	   }
      }
   }
}


/* set-union-2! */ obj_t 
set_union_2__160_cfa_set(obj_t dst_38, obj_t src_39)
{
   {
      {
	 bool_t test_2269;
	 if (STRUCTP(dst_38))
	   {
	      obj_t aux_2274;
	      obj_t aux_2272;
	      aux_2274 = CNST_TABLE_REF(((long) 1));
	      aux_2272 = STRUCT_KEY(dst_38);
	      test_2269 = (aux_2272 == aux_2274);
	   }
	 else
	   {
	      test_2269 = ((bool_t) 0);
	   }
	 if (test_2269)
	   {
	      {
		 bool_t test_2277;
		 if (STRUCTP(src_39))
		   {
		      obj_t aux_2282;
		      obj_t aux_2280;
		      aux_2282 = CNST_TABLE_REF(((long) 1));
		      aux_2280 = STRUCT_KEY(src_39);
		      test_2277 = (aux_2280 == aux_2282);
		   }
		 else
		   {
		      test_2277 = ((bool_t) 0);
		   }
		 if (test_2277)
		   {
		      bool_t aux_2285;
		      {
			 obj_t old_926;
			 old_926 = STRUCT_REF(dst_38, ((long) 0));
			 {
			    obj_t aux_2287;
			    {
			       long aux_2288;
			       {
				  long aux_2291;
				  long aux_2289;
				  {
				     obj_t aux_2292;
				     aux_2292 = STRUCT_REF(src_39, ((long) 0));
				     aux_2291 = (long) CINT(aux_2292);
				  }
				  aux_2289 = (long) CINT(old_926);
				  aux_2288 = (aux_2289 | aux_2291);
			       }
			       aux_2287 = BINT(aux_2288);
			    }
			    STRUCT_SET(dst_38, ((long) 0), aux_2287);
			 }
			 {
			    bool_t test_2298;
			    {
			       obj_t aux_2299;
			       aux_2299 = STRUCT_REF(dst_38, ((long) 0));
			       test_2298 = (old_926 == aux_2299);
			    }
			    if (test_2298)
			      {
				 aux_2285 = ((bool_t) 0);
			      }
			    else
			      {
				 aux_2285 = ((bool_t) 1);
			      }
			 }
		      }
		      return BBOOL(aux_2285);
		   }
		 else
		   {
		      obj_t arg1570_890;
		      arg1570_890 = shape_tools_shape(src_39);
		      return internal_error_43_tools_error(string1828_cfa_set, string1829_cfa_set, arg1570_890);
		   }
	      }
	   }
	 else
	   {
	      bool_t test_2305;
	      if (STRUCTP(dst_38))
		{
		   obj_t aux_2310;
		   obj_t aux_2308;
		   aux_2310 = CNST_TABLE_REF(((long) 2));
		   aux_2308 = STRUCT_KEY(dst_38);
		   test_2305 = (aux_2308 == aux_2310);
		}
	      else
		{
		   test_2305 = ((bool_t) 0);
		}
	      if (test_2305)
		{
		   {
		      bool_t test_2313;
		      if (STRUCTP(src_39))
			{
			   obj_t aux_2318;
			   obj_t aux_2316;
			   aux_2318 = CNST_TABLE_REF(((long) 2));
			   aux_2316 = STRUCT_KEY(src_39);
			   test_2313 = (aux_2316 == aux_2318);
			}
		      else
			{
			   test_2313 = ((bool_t) 0);
			}
		      if (test_2313)
			{
			   bool_t test_2321;
			   {
			      long aux_2326;
			      long aux_2322;
			      {
				 obj_t aux_2327;
				 aux_2327 = STRUCT_REF(src_39, ((long) 0));
				 aux_2326 = STRING_LENGTH(aux_2327);
			      }
			      {
				 obj_t aux_2323;
				 aux_2323 = STRUCT_REF(dst_38, ((long) 0));
				 aux_2322 = STRING_LENGTH(aux_2323);
			      }
			      test_2321 = (aux_2322 == aux_2326);
			   }
			   if (test_2321)
			     {
				bool_t aux_2331;
				{
				   obj_t the_dst_66_908;
				   obj_t the_src_137_909;
				   the_dst_66_908 = STRUCT_REF(dst_38, ((long) 0));
				   the_src_137_909 = STRUCT_REF(src_39, ((long) 0));
				   {
				      long i_910;
				      bool_t res_911;
				      {
					 long aux_2351;
					 {
					    obj_t aux_2352;
					    {
					       obj_t aux_2353;
					       aux_2353 = STRUCT_REF(dst_38, ((long) 1));
					       aux_2352 = STRUCT_REF(aux_2353, ((long) 1));
					    }
					    aux_2351 = (long) CINT(aux_2352);
					 }
					 i_910 = (aux_2351 - ((long) 1));
				      }
				      res_911 = ((bool_t) 0);
				    loop_912:
				      if ((i_910 == ((long) -1)))
					{
					   aux_2331 = res_911;
					}
				      else
					{
					   unsigned char new_919;
					   {
					      unsigned char aux_2338;
					      unsigned char aux_2336;
					      aux_2338 = STRING_REF(the_src_137_909, i_910);
					      aux_2336 = STRING_REF(the_dst_66_908, i_910);
					      new_919 = (aux_2336 | aux_2338);
					   }
					   {
					      bool_t test_2341;
					      {
						 unsigned char aux_2342;
						 aux_2342 = STRING_REF(the_dst_66_908, i_910);
						 test_2341 = (new_919 == aux_2342);
					      }
					      if (test_2341)
						{
						   long i_2345;
						   i_2345 = (i_910 - ((long) 1));
						   i_910 = i_2345;
						   goto loop_912;
						}
					      else
						{
						   STRING_SET(the_dst_66_908, i_910, new_919);
						   {
						      bool_t res_2350;
						      long i_2348;
						      i_2348 = (i_910 - ((long) 1));
						      res_2350 = ((bool_t) 1);
						      res_911 = res_2350;
						      i_910 = i_2348;
						      goto loop_912;
						   }
						}
					   }
					}
				   }
				}
				return BBOOL(aux_2331);
			     }
			   else
			     {
				obj_t arg1580_896;
				arg1580_896 = shape_tools_shape(src_39);
				return internal_error_43_tools_error(string1828_cfa_set, string1829_cfa_set, arg1580_896);
			     }
			}
		      else
			{
			   obj_t arg1587_903;
			   arg1587_903 = shape_tools_shape(src_39);
			   return internal_error_43_tools_error(string1828_cfa_set, string1829_cfa_set, arg1587_903);
			}
		   }
		}
	      else
		{
		   {
		      obj_t arg1592_906;
		      arg1592_906 = shape_tools_shape(dst_38);
		      return internal_error_43_tools_error(string1828_cfa_set, string1826_cfa_set, arg1592_906);
		   }
		}
	   }
      }
   }
}


/* set-union! */ obj_t 
set_union__206_cfa_set(obj_t dst_40, obj_t src__127_41)
{
   if (NULLP(src__127_41))
     {
	return dst_40;
     }
   else
     {
	bool_t test_2367;
	{
	   obj_t aux_2368;
	   aux_2368 = CDR(src__127_41);
	   test_2367 = NULLP(aux_2368);
	}
	if (test_2367)
	  {
	     return set_union_2__160_cfa_set(dst_40, CAR(src__127_41));
	  }
	else
	  {
	     {
		obj_t src__127_937;
		obj_t res_938;
		src__127_937 = src__127_41;
		res_938 = BFALSE;
	      loop_939:
		if (NULLP(src__127_937))
		  {
		     return res_938;
		  }
		else
		  {
		     obj_t arg1620_941;
		     obj_t arg1621_942;
		     arg1620_941 = CDR(src__127_937);
		     {
			obj_t _ortest_1436_943;
			_ortest_1436_943 = set_union_2__160_cfa_set(dst_40, CAR(src__127_937));
			if (CBOOL(_ortest_1436_943))
			  {
			     arg1621_942 = _ortest_1436_943;
			  }
			else
			  {
			     arg1621_942 = res_938;
			  }
		     }
		     {
			obj_t res_2381;
			obj_t src__127_2380;
			src__127_2380 = arg1620_941;
			res_2381 = arg1621_942;
			res_938 = res_2381;
			src__127_937 = src__127_2380;
			goto loop_939;
		     }
		  }
	     }
	  }
     }
}


/* _set-union! */ obj_t 
_set_union__126_cfa_set(obj_t env_1992, obj_t dst_1993, obj_t src__127_1994)
{
   return set_union__206_cfa_set(dst_1993, src__127_1994);
}


/* set-for-each */ obj_t 
set_for_each_94_cfa_set(obj_t proc_44, obj_t set_45)
{
   {
      {
	 bool_t test_2383;
	 if (STRUCTP(set_45))
	   {
	      obj_t aux_2388;
	      obj_t aux_2386;
	      aux_2388 = CNST_TABLE_REF(((long) 1));
	      aux_2386 = STRUCT_KEY(set_45);
	      test_2383 = (aux_2386 == aux_2388);
	   }
	 else
	   {
	      test_2383 = ((bool_t) 0);
	   }
	 if (test_2383)
	   {
	      {
		 bool_t test_2391;
		 {
		    long aux_2392;
		    {
		       obj_t aux_2393;
		       aux_2393 = STRUCT_REF(set_45, ((long) 0));
		       aux_2392 = (long) CINT(aux_2393);
		    }
		    test_2391 = (aux_2392 == ((long) 0));
		 }
		 if (test_2391)
		   {
		      return BUNSPEC;
		   }
		 else
		   {
		      obj_t table_989;
		      {
			 obj_t aux_2397;
			 aux_2397 = STRUCT_REF(set_45, ((long) 1));
			 table_989 = STRUCT_REF(aux_2397, ((long) 0));
		      }
		      {
			 {
			    long i_990;
			    {
			       long aux_2419;
			       aux_2419 = VECTOR_LENGTH(table_989);
			       i_990 = (aux_2419 - ((long) 1));
			    }
			  loop_991:
			    if ((i_990 == ((long) -1)))
			      {
				 return BUNSPEC;
			      }
			    else
			      {
				 bool_t test_2402;
				 {
				    long aux_2403;
				    {
				       long aux_2408;
				       long aux_2404;
				       aux_2408 = (((long) 1) << i_990);
				       {
					  obj_t aux_2405;
					  aux_2405 = STRUCT_REF(set_45, ((long) 0));
					  aux_2404 = (long) CINT(aux_2405);
				       }
				       aux_2403 = (aux_2404 & aux_2408);
				    }
				    test_2402 = (aux_2403 > ((long) 0));
				 }
				 if (test_2402)
				   {
				      PROCEDURE_ENTRY(proc_44) (proc_44, VECTOR_REF(table_989, i_990), BEOA);
				      {
					 long i_2415;
					 i_2415 = (i_990 - ((long) 1));
					 i_990 = i_2415;
					 goto loop_991;
				      }
				   }
				 else
				   {
				      {
					 long i_2417;
					 i_2417 = (i_990 - ((long) 1));
					 i_990 = i_2417;
					 goto loop_991;
				      }
				   }
			      }
			 }
		      }
		   }
	      }
	   }
	 else
	   {
	      bool_t test_2422;
	      if (STRUCTP(set_45))
		{
		   obj_t aux_2427;
		   obj_t aux_2425;
		   aux_2427 = CNST_TABLE_REF(((long) 2));
		   aux_2425 = STRUCT_KEY(set_45);
		   test_2422 = (aux_2425 == aux_2427);
		}
	      else
		{
		   test_2422 = ((bool_t) 0);
		}
	      if (test_2422)
		{
		   {
		      obj_t table_974;
		      {
			 obj_t aux_2430;
			 aux_2430 = STRUCT_REF(set_45, ((long) 1));
			 table_974 = STRUCT_REF(aux_2430, ((long) 0));
		      }
		      {
			 {
			    long i_975;
			    {
			       long aux_2447;
			       aux_2447 = VECTOR_LENGTH(table_974);
			       i_975 = (aux_2447 - ((long) 1));
			    }
			  loop_976:
			    if ((i_975 == ((long) -1)))
			      {
				 return BUNSPEC;
			      }
			    else
			      {
				 bool_t test1654_981;
				 {
				    obj_t aux_2435;
				    aux_2435 = set_member__236_cfa_set(set_45, VECTOR_REF(table_974, i_975));
				    test1654_981 = CBOOL(aux_2435);
				 }
				 if (test1654_981)
				   {
				      PROCEDURE_ENTRY(proc_44) (proc_44, VECTOR_REF(table_974, i_975), BEOA);
				      {
					 long i_2443;
					 i_2443 = (i_975 - ((long) 1));
					 i_975 = i_2443;
					 goto loop_976;
				      }
				   }
				 else
				   {
				      {
					 long i_2445;
					 i_2445 = (i_975 - ((long) 1));
					 i_975 = i_2445;
					 goto loop_976;
				      }
				   }
			      }
			 }
		      }
		   }
		}
	      else
		{
		   {
		      obj_t arg1647_971;
		      arg1647_971 = shape_tools_shape(set_45);
		      return internal_error_43_tools_error(string1830_cfa_set, string1826_cfa_set, arg1647_971);
		   }
		}
	   }
      }
   }
}


/* _set-for-each1820 */ obj_t 
_set_for_each1820_13_cfa_set(obj_t env_1995, obj_t proc_1996, obj_t set_1997)
{
   return set_for_each_94_cfa_set(proc_1996, set_1997);
}


/* set-length */ obj_t 
set_length_165_cfa_set(obj_t set_46)
{
   {
      {
	 bool_t test_2453;
	 if (STRUCTP(set_46))
	   {
	      obj_t aux_2458;
	      obj_t aux_2456;
	      aux_2458 = CNST_TABLE_REF(((long) 1));
	      aux_2456 = STRUCT_KEY(set_46);
	      test_2453 = (aux_2456 == aux_2458);
	   }
	 else
	   {
	      test_2453 = ((bool_t) 0);
	   }
	 if (test_2453)
	   {
	      {
		 long aux_2461;
		 {
		    obj_t the_set_132_1041;
		    long num_1042;
		    the_set_132_1041 = STRUCT_REF(set_46, ((long) 0));
		    num_1042 = ((long) 0);
		  loop_1043:
		    {
		       bool_t test_2462;
		       {
			  long aux_2463;
			  aux_2463 = (long) CINT(the_set_132_1041);
			  test_2462 = (aux_2463 == ((long) 0));
		       }
		       if (test_2462)
			 {
			    aux_2461 = num_1042;
			 }
		       else
			 {
			    {
			       long num_2472;
			       obj_t the_set_132_2466;
			       {
				  long aux_2467;
				  {
				     long aux_2468;
				     aux_2468 = (long) CINT(the_set_132_1041);
				     aux_2467 = (aux_2468 >> ((long) 1));
				  }
				  the_set_132_2466 = BINT(aux_2467);
			       }
			       {
				  long aux_2473;
				  {
				     long aux_2474;
				     aux_2474 = (long) CINT(the_set_132_1041);
				     aux_2473 = (aux_2474 & ((long) 1));
				  }
				  num_2472 = (num_1042 + aux_2473);
			       }
			       num_1042 = num_2472;
			       the_set_132_1041 = the_set_132_2466;
			       goto loop_1043;
			    }
			 }
		    }
		 }
		 return BINT(aux_2461);
	      }
	   }
	 else
	   {
	      bool_t test_2480;
	      if (STRUCTP(set_46))
		{
		   obj_t aux_2485;
		   obj_t aux_2483;
		   aux_2485 = CNST_TABLE_REF(((long) 2));
		   aux_2483 = STRUCT_KEY(set_46);
		   test_2480 = (aux_2483 == aux_2485);
		}
	      else
		{
		   test_2480 = ((bool_t) 0);
		}
	      if (test_2480)
		{
		   {
		      long aux_2488;
		      {
			 obj_t the_set_132_1024;
			 the_set_132_1024 = STRUCT_REF(set_46, ((long) 0));
			 {
			    long the_len_105_1025;
			    the_len_105_1025 = STRING_LENGTH(the_set_132_1024);
			    {
			       {
				  long offset_1026;
				  long num_1027;
				  offset_1026 = ((long) 0);
				  num_1027 = ((long) 0);
				loop_1028:
				  if ((offset_1026 == the_len_105_1025))
				    {
				       aux_2488 = num_1027;
				    }
				  else
				    {
				       long char_1030;
				       long num_1031;
				       {
					  unsigned char aux_2504;
					  aux_2504 = STRING_REF(the_set_132_1024, offset_1026);
					  char_1030 = (aux_2504);
				       }
				       num_1031 = num_1027;
				     liip_1032:
				       if ((char_1030 == ((long) 0)))
					 {
					    {
					       long num_2497;
					       long offset_2495;
					       offset_2495 = (((long) 1) + offset_1026);
					       num_2497 = num_1031;
					       num_1027 = num_2497;
					       offset_1026 = offset_2495;
					       goto loop_1028;
					    }
					 }
				       else
					 {
					    {
					       long num_2500;
					       long char_2498;
					       char_2498 = (char_1030 >> ((long) 1));
					       {
						  long aux_2501;
						  aux_2501 = (char_1030 & ((long) 1));
						  num_2500 = (num_1031 + aux_2501);
					       }
					       num_1031 = num_2500;
					       char_1030 = char_2498;
					       goto liip_1032;
					    }
					 }
				    }
			       }
			    }
			 }
		      }
		      return BINT(aux_2488);
		   }
		}
	      else
		{
		   {
		      obj_t arg1689_1022;
		      arg1689_1022 = shape_tools_shape(set_46);
		      return internal_error_43_tools_error(string1831_cfa_set, string1826_cfa_set, arg1689_1022);
		   }
		}
	   }
      }
   }
}


/* _set-length */ obj_t 
_set_length_66_cfa_set(obj_t env_1998, obj_t set_1999)
{
   return set_length_165_cfa_set(set_1999);
}


/* set->list */ obj_t 
set__list_248_cfa_set(obj_t set_47)
{
   {
      obj_t meta_1052;
      {
	 bool_t test_2511;
	 if (STRUCTP(set_47))
	   {
	      obj_t aux_2516;
	      obj_t aux_2514;
	      aux_2516 = CNST_TABLE_REF(((long) 1));
	      aux_2514 = STRUCT_KEY(set_47);
	      test_2511 = (aux_2514 == aux_2516);
	   }
	 else
	   {
	      test_2511 = ((bool_t) 0);
	   }
	 if (test_2511)
	   {
	      meta_1052 = STRUCT_REF(set_47, ((long) 1));
	   }
	 else
	   {
	      bool_t test_2520;
	      if (STRUCTP(set_47))
		{
		   obj_t aux_2525;
		   obj_t aux_2523;
		   aux_2525 = CNST_TABLE_REF(((long) 2));
		   aux_2523 = STRUCT_KEY(set_47);
		   test_2520 = (aux_2523 == aux_2525);
		}
	      else
		{
		   test_2520 = ((bool_t) 0);
		}
	      if (test_2520)
		{
		   meta_1052 = STRUCT_REF(set_47, ((long) 1));
		}
	      else
		{
		   {
		      obj_t arg1722_1071;
		      arg1722_1071 = shape_tools_shape(set_47);
		      meta_1052 = internal_error_43_tools_error(string1830_cfa_set, string1832_cfa_set, arg1722_1071);
		   }
		}
	   }
      }
      {
	 obj_t table_1053;
	 table_1053 = STRUCT_REF(meta_1052, ((long) 0));
	 {
	    long size_1054;
	    size_1054 = VECTOR_LENGTH(table_1053);
	    {
	       {
		  long i_1055;
		  obj_t l_1056;
		  i_1055 = ((long) 0);
		  l_1056 = BNIL;
		loop_1057:
		  if ((i_1055 == size_1054))
		    {
		       return l_1056;
		    }
		  else
		    {
		       bool_t test1710_1061;
		       {
			  obj_t aux_2535;
			  aux_2535 = set_member__236_cfa_set(set_47, VECTOR_REF(table_1053, i_1055));
			  test1710_1061 = CBOOL(aux_2535);
		       }
		       if (test1710_1061)
			 {
			    {
			       long arg1711_1062;
			       obj_t arg1712_1063;
			       arg1711_1062 = (i_1055 + ((long) 1));
			       {
				  obj_t aux_2541;
				  aux_2541 = VECTOR_REF(table_1053, i_1055);
				  arg1712_1063 = MAKE_PAIR(aux_2541, l_1056);
			       }
			       {
				  obj_t l_2545;
				  long i_2544;
				  i_2544 = arg1711_1062;
				  l_2545 = arg1712_1063;
				  l_1056 = l_2545;
				  i_1055 = i_2544;
				  goto loop_1057;
			       }
			    }
			 }
		       else
			 {
			    {
			       long i_2546;
			       i_2546 = (i_1055 + ((long) 1));
			       i_1055 = i_2546;
			       goto loop_1057;
			    }
			 }
		    }
	       }
	    }
	 }
      }
   }
}


/* _set->list */ obj_t 
_set__list_15_cfa_set(obj_t env_2000, obj_t set_2001)
{
   return set__list_248_cfa_set(set_2001);
}


/* set->vector */ obj_t 
set__vector_66_cfa_set(obj_t set_48)
{
   {
      obj_t arg1723_1979;
      arg1723_1979 = set__list_248_cfa_set(set_48);
      return list__vector_101___r4_vectors_6_8(arg1723_1979);
   }
}


/* _set->vector */ obj_t 
_set__vector_80_cfa_set(obj_t env_2002, obj_t set_2003)
{
   return set__vector_66_cfa_set(set_2003);
}


/* method-init */ obj_t 
method_init_76_cfa_set()
{
   return BUNSPEC;
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_cfa_set()
{
   module_initialization_70_type_type(((long) 0), "CFA_SET");
   module_initialization_70_ast_var(((long) 0), "CFA_SET");
   module_initialization_70_ast_node(((long) 0), "CFA_SET");
   module_initialization_70_tools_shape(((long) 0), "CFA_SET");
   module_initialization_70_tools_error(((long) 0), "CFA_SET");
   return module_initialization_70_cfa_approx(((long) 0), "CFA_SET");
}
