;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cfa/procedure.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 25 12:08:59 1996                          */
;*    Last change :  Sun Nov 29 09:52:52 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The procedure approximation management                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_procedure
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    type_type
	    type_cache
	    ast_var 
	    ast_node
	    cfa_info
	    cfa_loose
	    cfa_setup
	    cfa_approx
	    cfa_cfa
	    cfa_iterate
	    cfa_closure
	    cfa_stack)
   (export  (disable-X-T! approx::approx)))

;*---------------------------------------------------------------------*/
;*    disable-X-T! ...                                                 */
;*---------------------------------------------------------------------*/
(define (disable-X-T! approx)
   (for-each-approx-alloc (lambda (app)
			     (trace (cfa 3)
				    "!!! Je disable X-T pour: " (shape app)
				    #\Newline)
			     (if (make-procedure-app? app)
				 (make-procedure-app-X-T?-set! app #f)))
			  approx))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-make-procedure-app ...                         */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-make-procedure-app)
   (with-access::pre-make-procedure-app node (fun args)
      (add-make-procedure! node)
      (node-setup*! args)
      (let* ((owner (pre-make-procedure-app-owner node))
	     (node  (shrink! node)))
	 (let ((proc-size (get-node-atom-value (caddr args)))
	       (proc      (car args)))
	    (if (and (fixnum? proc-size)
		     (var? proc)
		     (fun? (variable-value (var-variable proc))))
		(let ((node (widen!::make-procedure-app node
			       (owner owner)
			       (approx (make-empty-approx))
	 		       (values-approx-len proc-size)
			       (values-approx (make-empty-approx)))))
		   (trace (cfa 3)
			  " make-procedure-app: " (shape node) #\Newline
			  "          proc-size: " proc-size #\Newline)
		   (make-procedure-app-approx-set! node
						   (make-type-alloc-approx
						    *procedure*
						    node))
		   ;; we mark that first argument (or we set) is
		   ;; bound to a closure
		   (let* ((clo (car (sfun-args
				     (variable-value
				      (var-variable proc)))))
			  (vclo (local-value clo)))
		      (if (svar/Cinfo? vclo)
			  (begin
			     (trace (cfa 2) "Je set un pre-clo-env..."
				    (shape clo) #\Newline)
			     (svar/Cinfo-clo-env?-set! vclo #t))
			  (widen!::pre-clo-env vclo)))
		   ;; we prepare the closure fields approximations
		   (let loop ((i 0))
		      (if (<fx i proc-size)
			  (begin
			     (make-procedure-app-values-approx-set!
			      node
			      i
			      (make-type-approx *obj*))
			     (loop (+fx i 1))))))
		;; if the size is not a fixnum, we treat this make-procedure
		;; as a regular function call
		(call-next-method))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-procedure-ref-app ...                          */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-procedure-ref-app)
   (add-procedure-ref! node)
   (with-access::pre-procedure-ref-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::procedure-ref-app node
	    (approx (make-type-approx *obj*))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-procedure-set!-app ...                         */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-procedure-set!-app)
   (add-procedure-ref! node)
   (with-access::pre-procedure-set!-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::procedure-set!-app node
	    (approx (make-type-approx *unspec*))))))

;*---------------------------------------------------------------------*/
;*    cfa! ::make-procedure-app ...                                    */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::make-procedure-app)
   (with-access::make-procedure-app node (approx args)
      ;; the first argument of the procedure is the
      ;; procedure itself, we set this manually
      (let* ((proc (car args))
	     (fun  (variable-value (var-variable proc)))
	     (env  (car (sfun-args fun))))
	 (trace (cfa 4)
		"make-procedure-app(je set l'env): (union "
		(shape (svar/Cinfo-approx (local-value env)))
		" "
		(shape approx)
		#\Newline)
	 (union-approx! (svar/Cinfo-approx (local-value env)) approx))
      ;; and we process the argument of the make-procedure
      (for-each cfa! args)
      approx))

;*---------------------------------------------------------------------*/
;*    cfa! ::procedure-ref-app ...                                     */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::procedure-ref-app)
   (with-access::procedure-ref-app node (args approx)
      (cfa! (cadr args))
      (let ((proc-approx (cfa! (car args)))
	    (offset      (get-node-atom-value (cadr args))))
	 (trace (cfa 4) " procedure-ref: " (shape node) #\Newline
		"        offset: " offset #\Newline)
	 ;; we check for top
	 (if (approx-top? proc-approx)
	     (approx-set-top! approx))
	 (if (fixnum? offset)
	     ;; if the offset is a fixnum, we compute an accurate approx
	     (for-each-approx-alloc
	      (lambda (app)
		 (if (and (make-procedure-app? app)
			  (<fx offset (make-procedure-app-values-approx-len
				       app)))
		     (union-approx! approx
				    (make-procedure-app-values-approx-ref
				     app
				     offset))
		     ;; We are out the procedure. its an error (or a
		     ;; reference to a generic function).
		     (approx-set-top! approx)))
	      proc-approx)
	     ;; is the offset is not a fixnum, we compute a merging approx
	     (for-each-approx-alloc
	      (lambda (app)
		 (if (make-procedure-app? app)
		     (let ((len (make-procedure-app-values-approx-len app)))
			(let loop ((i 0))
			   (if (<fx i len)
			       (begin
			       (union-approx!
				approx
				(make-procedure-app-values-approx-ref app i)))
			       (loop (+fx i 1)))))))
	      proc-approx))
	 (trace (cfa 4) "  <- " (shape approx) #\Newline)
	 approx)))

;*---------------------------------------------------------------------*/
;*    cfa! ::procedure-set!-app ...                                    */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::procedure-set!-app)
   (with-access::procedure-set!-app node (args approx)
      (cfa! (cadr args))
      (let ((proc-approx (cfa! (car args)))
	    (offset      (get-node-atom-value (cadr args)))
	    (val-approx  (cfa! (caddr args))))
	 (trace (cfa 4) " procedure-set!: " (shape node) #\Newline
		"         offset: " offset #\Newline
		"         val-ap: " (shape val-approx) #\Newline)
	 ;; do we have top in the proc approximation ?
	 (if (approx-top? proc-approx)
	     ;; yes, we have, hence we loose every thing.
	     (loose! val-approx 'all)
	     (if (fixnum? offset)
		 ;; if the offset is a fixnum, we compute an accurate approx
		 (for-each-approx-alloc
		  (lambda (app)
		     (if (and (make-procedure-app? app)
			      (<fx offset (make-procedure-app-values-approx-len
					   app)))
			 (union-approx! (make-procedure-app-values-approx-ref
					 app
					 offset)
					val-approx))) 
		  proc-approx)
		 ;; if the offset is not a fixnum, we compute a merging approx
		 (for-each-approx-alloc
		  (lambda (app)
		     (if (make-procedure-app? app)
			 (let ((len (make-procedure-app-values-approx-len
				     app)))
			    (let loop ((i 0))
			       (if (<fx i len)
				   (begin
				      (union-approx!
				       (make-procedure-app-values-approx-ref
					app i)
				       val-approx)
				      (loop (+fx i 1))))))))
		  proc-approx)))
	 approx)))

;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Loosing a procedure only means that the result of the procedure  */
;*    is lost and all formals can be bound to top. It does not mean    */
;*    anything about the values closed by the procedure (contrarily to */
;*    vectors).                                                        */
;*---------------------------------------------------------------------*/
(define-method (loose-alloc! alloc::make-procedure-app)
     (trace (cfa 4) " *** loose-alloc::make-procedure-app: " *cfa-stamp* " "
	    (shape alloc) #\Newline)
    (with-access::make-procedure-app alloc (lost-stamp)
      (if (=fx lost-stamp *cfa-stamp*)
	  #unspecified
	  (begin
	     (trace (cfa 2) " *** loose: " (shape alloc) #\Newline)
	     (set! lost-stamp *cfa-stamp*)
	     (let* ((callee (car (make-procedure-app-args alloc)))
		    (v      (var-variable callee))
		    (fun    (variable-value v)))
		(cfa-export-var! fun v))))))

;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*    -------------------------------------------------------------    */
;*    Stack loosing a procedure means that all the reachable           */
;*    data structures from this procedure cannot be stack allocate     */
;*    either.                                                          */
;*---------------------------------------------------------------------*/
(define-method (stack-loose-alloc! alloc::make-procedure-app cowner)
   (with-access::make-procedure-app alloc (stack-stamp stackable? owner)
      (trace (cfa 4) " *** stack-loose::make-procedure-app: " *cfa-stamp* " "
	     (shape alloc) " owner: " (shape owner) #\Newline) 
      (if (or (not stackable?) (memq cowner stack-stamp))
	  ;; we have already lost the procedure for this owner
	  #unspecified
	  (begin
	     (set! stack-stamp (cons cowner stack-stamp))
	     (if (or (not (variable? cowner)) (eq? owner cowner))
		 (begin
		    (set! stackable? #f)
		    (stack-loose-procedure-env! alloc 'all))
		 (stack-loose-procedure-env! alloc cowner))
	     ;; we stack loose the result of the function
	     (let* ((callee (car (make-procedure-app-args alloc)))
		    (v      (var-variable callee))
		    (fun    (variable-value v)))
		(cfa-export-var! fun cowner))))))

;*---------------------------------------------------------------------*/
;*    stack-loose-procedure-env! ...                                   */
;*---------------------------------------------------------------------*/
(define (stack-loose-procedure-env! alloc cowner)
   (trace (cfa 4) " *** stack-loose-procedure-env: " *cfa-stamp* " "
	  (shape alloc) " cowner: " (shape cowner) #\Newline)
   ;; we stack loose all the captured values
   (let ((len (make-procedure-app-values-approx-len alloc)))
      (let loop ((i 0))
	 (if (<fx i len)
	     (begin
		(for-each-approx-alloc
		 (lambda (alloc) (stack-loose-alloc! alloc cowner))
		 (make-procedure-app-values-approx-ref alloc i))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    stack! ::make-procedure-app ...                                  */
;*---------------------------------------------------------------------*/
(define-method (stack! node::make-procedure-app)
   (with-access::make-procedure-app node (fun args stackable? lost-stamp)
      (trace (cfa 2)
	     "stack(make-procedure-app): s?: " stackable? #\Newline)
      (stack*! args)
      (node-heap->stack! node (and (=fx lost-stamp -1) stackable?))))


   



