;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Cfa/loose.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 25 12:02:51 1996                          */
;*    Last change :  Wed Sep 10 10:34:49 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Loosing approximations means values are going outside.           */
;*    Toping approximations means add top the sets.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_loose
   (include "Tools/trace.sch")
   (import  type_type
	    tools_shape
	    ast_var
	    ast_node
	    cfa_iterate
	    cfa_set
	    cfa_info
	    cfa_approx
	    cfa_procedure)
   (export  (set-looser! looser)
	    (loose!::approx ::approx ::obj)
	    (generic loose-alloc! ::node)
	    (generic stack-loose-alloc! ::node ::obj)
	    (global-loose! ::global ::approx)
	    (stack-intern-sfun-loose! ::approx ::obj)))
 
;*---------------------------------------------------------------------*/
;*    *looser* ...                                                     */
;*---------------------------------------------------------------------*/
(define *looser* 'cfa)

;*---------------------------------------------------------------------*/
;*    set-looser! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-looser! looser)
   [assert (looser) (memq looser '(cfa stack))]
   (set! *looser* looser))

;*---------------------------------------------------------------------*/
;*    loose! ...                                                       */
;*---------------------------------------------------------------------*/
(define (loose!::approx approx::approx owner)
   (trace (cfa 4) "loose!(" *looser* "): " (shape approx) #\Newline)
   (if (eq? *looser* 'cfa)
       (cfa-loose! approx)
       (stack-loose! approx owner)))

;*---------------------------------------------------------------------*/
;*    cfa-loose! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cfa-loose!::approx approx::approx)
   (with-access::approx approx (lost-stamp)
      (if (<fx lost-stamp *cfa-stamp*)
	  (begin
	     (set! lost-stamp *cfa-stamp*)
	     (for-each-approx-alloc loose-alloc! approx))))
   approx)

;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (loose-alloc! node::node))

;*---------------------------------------------------------------------*/
;*    stack-loose! ...                                                 */
;*---------------------------------------------------------------------*/
(define (stack-loose!::approx approx::approx owner)
   (for-each-approx-alloc (lambda (alloc) (stack-loose-alloc! alloc owner))
			  approx)
   approx)

;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*---------------------------------------------------------------------*/
(define-generic (stack-loose-alloc! node::node owner))

;*---------------------------------------------------------------------*/
;*    global-loose! ...                                                */
;*    -------------------------------------------------------------    */
;*    Global variable are not allowed to hold optimized procedure      */
;*    because due to the module compilation we can ensure that         */
;*    the global variable is initialized and then, we always need      */
;*    to type check it (which cannot be performed with optimized       */
;*    procedures).                                                     */
;*---------------------------------------------------------------------*/
(define (global-loose! global approx)
   (trace (cfa 2)
	  "global-loose!: " (shape global) " " (shape approx) #\Newline)
   (cond
      ((memq (global-import global) '(import export))
       (loose! approx 'all))
      ((eq? *looser* 'stack)
       (disable-X-T! approx)
       (loose! approx 'all))
      (else
       (disable-X-T! approx))))

;*---------------------------------------------------------------------*/
;*    stack-intern-sfun-loose! ...                                     */
;*---------------------------------------------------------------------*/
(define (stack-intern-sfun-loose! approx owner)
   (trace (cfa 4)
	  "stack-intern-sfun-loose!: " (shape owner) " " (shape approx)
	  #\Newline)
   (if (eq? *looser* 'stack)
       (loose! approx owner)))
