;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Cfa/iterate.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Feb 22 18:11:52 1995                          */
;*    Last change :  Wed Sep 10 10:19:30 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    THE control flow analysis engine                                 */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_iterate
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    ast_var
	    ast_node
	    ast_unit
	    cfa_cfa
	    cfa_info
	    cfa_loose
	    cfa_approx)
   (export  (cfa-iterate-to-fixpoint! globals)
	    (cfa-intern-sfun!::approx ::intern-sfun/Cinfo ::obj)
	    (generic cfa-export-var! ::value ::obj)
	    (continue-cfa!)
	    (cfa-iterate! globals)
	    *cfa-stamp*))

;*---------------------------------------------------------------------*/
;*    cfa-iterate-to-fixpoint! ...                                     */
;*---------------------------------------------------------------------*/
(define (cfa-iterate-to-fixpoint! globals)
   ;; we reset the global stamp
   (set! *cfa-stamp* -1)
   ;; we collect all the exported variables (both functions and
   ;; variables). They are the root of the iteration process.
   (let ((glodefs '()))
      (for-each (lambda (g)
		   (if (eq? (global-import g) 'export)
		       (set! glodefs (cons g glodefs))))
		globals)
      ;; we add the top level forms
      (set! glodefs (append (unit-initializers) glodefs))
      ;; and we start iterations
      (continue-cfa!)
      ;; and we do it
      (let loop ()
	 (if (continue-cfa?)
	     (begin
		(cfa-iterate! glodefs)
		(trace cfa "<======= Cfa iteration!: " *cfa-stamp* #\Newline)
		(loop))
	     glodefs))))

;*---------------------------------------------------------------------*/
;*    cfa-iterate! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cfa-iterate! globals)
   (stop-cfa!)
   (set! *cfa-stamp* (+fx 1 *cfa-stamp*))
   (trace cfa #\Newline "=======> Cfa iteration!: " *cfa-stamp* #\Newline)
   (for-each (lambda (g)
		(trace (cfa 2) "Exporting " (shape g) #\: #\Newline)
		(cfa-export-var! (global-value g) g)
		(trace (cfa 2) #\Newline)) 
	     globals)
   (trace cfa #\Newline))

;*---------------------------------------------------------------------*/
;*    cfa-export-var! ...                                              */
;*---------------------------------------------------------------------*/
(define-generic (cfa-export-var! value::value owner))

;*---------------------------------------------------------------------*/
;*    cfa-export-var! ::svar ...                                       */
;*---------------------------------------------------------------------*/
(define-method (cfa-export-var! value::svar/Cinfo owner)
   (with-access::intern-sfun/Cinfo sfun (stamp)
      (trace (cfa 3) "~~~ cfa-export/var!::svar/Cinfo[stamp: " stamp
	     " *cfa-stamp*: " *cfa-stamp*
	     "]" #\Newline)
      (if (=fx stamp *cfa-stamp*)
	  (cfa-variable-value-approx value)
	  (begin
	     (set! stamp *cfa-stamp*)
	     (loose! (cfa-variable-value-approx value) 'all)))))

;*---------------------------------------------------------------------*/
;*    cfa-export-var! ::intern-sfun/Cinfo ...                          */
;*---------------------------------------------------------------------*/
(define-method (cfa-export-var! value::intern-sfun/Cinfo owner)
   (with-access::intern-sfun/Cinfo value (stamp args approx)
      (trace (cfa 3) "~~~ cfa-export-var!::intern-sfun/Cinfo[stamp: " stamp 
	     " *cfa-stamp*: " *cfa-stamp*
	     "]" #\Newline)
      (if (=fx stamp *cfa-stamp*)
	  (begin
	     (set! stamp *cfa-stamp*)
	     approx)
	  (begin
	     ;; for each iteration, we re-loose the approximation of the
	     ;; formal parameters. Doing this, we don't have to take care
	     ;; when we add an approximation of a previous set if this
	     ;; set contains `top' or not.
	     (for-each (lambda (local)
			  (let ((val (local-value local)))
			     (if (not (svar/Cinfo-clo-env? val))
				 (approx-set-top! (svar/Cinfo-approx val)))))
		       args)
	     ;; after the formals, we loose the result.
	     (loose! (cfa-intern-sfun! value owner) 'all)))))
 
;*---------------------------------------------------------------------*/
;*    cfa-intern-sfun! ::intern-sfun/Cinfo ...                         */
;*---------------------------------------------------------------------*/
(define (cfa-intern-sfun!::approx sfun::intern-sfun/Cinfo owner)
   (with-access::intern-sfun/Cinfo sfun (stamp body approx args)
      (trace (cfa 3) "~~~ cfa-intern-sfun!: " (shape body) #\Newline)
      (if (=fx stamp *cfa-stamp*)
	  approx
	  (begin
	     (set! stamp *cfa-stamp*)
	     (union-approx! approx (cfa! body))
	     (stack-intern-sfun-loose! approx owner)
	     approx))))

;*---------------------------------------------------------------------*/
;*    The iteration process control                                    */
;*---------------------------------------------------------------------*/
(define *cfa-continue?* #unspecified)
(define *cfa-stamp*     -1)

;*---------------------------------------------------------------------*/
;*    continue-cfa! ...                                                */
;*---------------------------------------------------------------------*/
(define (continue-cfa!)
   (if (not *cfa-continue?*)
       (trace (cfa 2) "--> continue-cfa!" #\Newline))
   (set! *cfa-continue?* #t))

;*---------------------------------------------------------------------*/
;*    continue-cfa? ...                                                */
;*---------------------------------------------------------------------*/
(define (continue-cfa?)
   *cfa-continue?*)

;*---------------------------------------------------------------------*/
;*    stop-cfa! ...                                                    */
;*---------------------------------------------------------------------*/
(define (stop-cfa!)
   (set! *cfa-continue?* #f))


   

