;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cfa/collect.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 09:06:26 1995                          */
;*    Last change :  Sun Jun 28 16:18:10 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We collect all type and alloc approximations                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_collect
   (include "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    type_cache
	    type_typeof
	    module_module
	    engine_param
	    ast_var
	    ast_node
	    ast_dump
	    ast_env
	    ast_sexp
	    cfa_info
	    cfa_procedure
	    cfa_vector
	    cfa_struct
	    cfa_box
	    cfa_closure)
   (export  (collect-all-approx! globals)
	    (get-allocs)))

;*---------------------------------------------------------------------*/
;*    collect-all-approx! ...                                          */
;*---------------------------------------------------------------------*/
(define (collect-all-approx! globals)
   (for-each (lambda (global) (collect-sfun! (global-value global) global))
	     globals))

;*---------------------------------------------------------------------*/
;*    collect-sfun! ::sfun ...                                         */
;*---------------------------------------------------------------------*/
(define (collect-sfun! value::sfun global::global)
   (node-collect! (sfun-body value) global))

;*---------------------------------------------------------------------*/
;*    node-collect! ...                                                */
;*---------------------------------------------------------------------*/
(define-generic (node-collect! node::node owner::variable))

;*---------------------------------------------------------------------*/
;*    node-collect! ::atom ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::atom owner)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    node-collect! ::kwote ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::kwote owner)
   (let ((value (kwote-value node)))
      (if (and (>=fx *optim* 2) (vector? value))
	  (let ((dummy (top-level-sexp->node
			`(c-make-vector ,(vector-length value)
					,(if (monomorphic-vector? value)
					     (vector-ref value 0)
					     '(pragma::obj "")))
			#f)))
	     (widen!::kwote/node node (node dummy))
	     (node-collect! dummy owner)))))
		    
;*---------------------------------------------------------------------*/
;*    monomorphic-vector? ...                                          */
;*---------------------------------------------------------------------*/
(define (monomorphic-vector? vector)
   (define (get-atype value)
      (cond
	 ((integer? value)
	  'integer)
	 ((char? value)
	  'char)
	 ((boolean? value)
	  'boolean)
	 ((string? value)
	  'string)
	 ((real? value)
	  'real)
	 (else
	  #f)))
   (let ((len (vector-length vector)))
      (if (=fx len 0)
	  #f 
	  (let ((atype (get-atype (vector-ref vector 0))))
	     (let loop ((i 1))
		(cond
		   ((not atype)
		    #f)
		   ((=fx i len)
		    #t)
		   ((eq? (get-atype (vector-ref vector i)) atype)
		    (loop (+fx i 1)))
		   (else
		    #f)))))))
  
;*---------------------------------------------------------------------*/
;*    node-collect! ::var ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::var owner)
   (let ((v (var-variable node)))
      (if (and (global? v)
	       (eq? (global-module v) *module*)
	       (scnst? (global-value v))
	       (not (used-alloc? (scnst-node (global-value v)))))
	  (begin
	     (trace (cfa 2) "Je collecte une scnt: "
		    (shape v) " " (shape (scnst-node (global-value v)))
		    #\Newline)
	     ;; this variable holds a constant
	     (node-collect! (scnst-node (global-value v)) owner))))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    node-collect! ::sequence ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::sequence owner)
   (node-collect*! (sequence-nodes node) owner))

;*---------------------------------------------------------------------*/
;*    node-collect! ::app ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::app owner)
   (with-access::app node (fun args)
      (node-collect*! args owner)
      (node-collect! fun owner) 
      (let ((v (var-variable fun)))
	 (if (and (global? v) (cfun? (variable-value v)))
	     (begin
		;; closure tracing is mandatory otherwise the cfa
		;; approximation are incorrects (because if we don't
		;; trace closure we can possibly never enter some functions).
		(case (global-id v)
		   ((make-fx-procedure)
		    (use-alloc! node)
		    (widen!::pre-make-procedure-app node (owner owner)))
		   ((make-va-procedure)
		    (use-alloc! node)
		    (widen!::pre-make-procedure-app node (owner owner)))
		   ((procedure-ref)
		    (widen!::pre-procedure-ref-app node))
		   ((procedure-set!)
		    (widen!::pre-procedure-set!-app node)))
		(if (>=fx *optim* 2)
		    (case (global-id v)
		       ((c-make-vector)
			(use-alloc! node)
			(widen!::pre-make-vector-app node (owner owner)))
		       ((c-create-vector)
			(use-alloc! node)
			(widen!::pre-create-vector-app node (owner owner)))
		       ((c-vector-ref)
			(widen!::pre-vector-ref-app node))
		       ((c-vector-set!)
			(widen!::pre-vector-set!-app node))
		       ((c-make-struct)
			(use-alloc! node)
			(widen!::pre-make-struct-app node (owner owner)))
		       ((c-struct-ref)
			(widen!::pre-struct-ref-app node))
		       ((c-struct-set!)
			(widen!::pre-struct-set!-app node)))))))))

;*---------------------------------------------------------------------*/
;*    node-collect! ::app-ly ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::app-ly owner)
   (with-access::app-ly node (fun arg)
      (node-collect! fun owner)
      (node-collect! arg owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::funcall ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::funcall owner)
   (add-funcall! node)
   (with-access::funcall node (fun args)
      (node-collect! fun owner)
      (node-collect*! args owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::pragma ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::pragma owner)
   (with-access::pragma node (args)
      (node-collect*! args owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::cast ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::cast owner)
   (with-access::cast node (arg)
      (node-collect! arg owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::setq ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::setq owner)
   (with-access::setq node (type value)
      (node-collect! value owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::conditional ...                                  */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::conditional owner)
   (with-access::conditional node (test true false)
       (node-collect! test owner)
       (node-collect! true owner)
       (node-collect! false owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::fail ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::fail owner)
   (with-access::fail node (type proc msg obj)
      (node-collect! proc owner)
      (node-collect! msg owner)
      (node-collect! obj owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::select ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::select owner)
   (with-access::select node (clauses test)
      (node-collect! test owner)
      (for-each (lambda (clause)
		   (node-collect! (cdr clause) owner))
		clauses)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::let-fun ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::let-fun owner)
   (with-access::let-fun node (body locals)
      (for-each (lambda (l)
		   (let ((f (local-value l)))
		      (node-collect! (sfun-body f) l)))
		locals)
      (node-collect! body owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::let-var ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::let-var owner)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (node-collect! (cdr binding) owner))
		bindings)
      (node-collect! body owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::set-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::set-ex-it owner)
   (with-access::set-ex-it node (var body)
      (node-collect! body owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::jump-ex-it ...                                   */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::jump-ex-it owner)
   (with-access::jump-ex-it node (exit value)
      (node-collect! exit owner) 
      (node-collect! value owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::make-box ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::make-box owner)
   (node-collect! (make-box-value node) owner)
   (if (>=fx *optim* 1)
       (begin
	  (use-alloc! node)
	  (widen!::pre-make-box node))))

;*---------------------------------------------------------------------*/
;*    node-collect! ::box-set! ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::box-set! owner)
   (with-access::box-set! node (var value)
      (node-collect! var owner)
      (node-collect! value owner)))

;*---------------------------------------------------------------------*/
;*    node-collect! ::box-ref ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-collect! node::box-ref owner)
   (with-access::box-ref node (var)
      (node-collect! var owner)))

;*---------------------------------------------------------------------*/
;*    node-collect*! ...                                               */
;*---------------------------------------------------------------------*/
(define (node-collect*! node* owner)
   (for-each (lambda (node) (node-collect! node owner)) node*))

;*---------------------------------------------------------------------*/
;*    *used-alloc* ...                                                 */
;*---------------------------------------------------------------------*/
(define *used-alloc* '())

;*---------------------------------------------------------------------*/
;*    use-alloc! ...                                                   */
;*---------------------------------------------------------------------*/
(define (use-alloc! alloc)
   (set! *used-alloc* (cons alloc *used-alloc*)))

;*---------------------------------------------------------------------*/
;*    used-alloc? ...                                                  */
;*---------------------------------------------------------------------*/
(define (used-alloc? alloc)
   (memq alloc *used-alloc*))

;*---------------------------------------------------------------------*/
;*    get-allocs ...                                                   */
;*---------------------------------------------------------------------*/
(define (get-allocs)
   *used-alloc*)
