/*===========================================================================*/
/*   (Cfa/collect.scm)                                                       */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct ccomp
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t producer;
     obj_t consumer;
     obj_t finalizer;
     obj_t checksummer;
  }
     *ccomp_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;

typedef struct approx
  {
     header_t header;
     obj_t widening;
     struct type *type;
     bool_t type_locked__184;
     obj_t allocs;
     bool_t top__138;
     long lost_stamp_114;
  }
      *approx_t;

typedef struct cfun_cinfo_200
  {
     struct approx *approx;
  }
              *cfun_cinfo_200_t;

typedef struct extern_sfun_cinfo_6
  {
     struct approx *approx;
  }
                   *extern_sfun_cinfo_6_t;

typedef struct intern_sfun_cinfo_192
  {
     struct approx *approx;
     long stamp;
  }
                     *intern_sfun_cinfo_192_t;

typedef struct scnst_cinfo_0
  {
     struct approx *approx;
  }
             *scnst_cinfo_0_t;

typedef struct pre_clo_env_191
  {
     char dummy;
  }
               *pre_clo_env_191_t;

typedef struct svar_cinfo_166
  {
     struct approx *approx;
     bool_t clo_env__87;
  }
              *svar_cinfo_166_t;

typedef struct cvar_cinfo_53
  {
     struct approx *approx;
  }
             *cvar_cinfo_53_t;

typedef struct sexit_cinfo_49
  {
     struct approx *approx;
  }
              *sexit_cinfo_49_t;

typedef struct reshaped_local_224
  {
     obj_t binding_value_3;
  }
                  *reshaped_local_224_t;

typedef struct reshaped_global_160
  {
     char dummy;
  }
                   *reshaped_global_160_t;

typedef struct atom_cinfo_155
  {
     struct approx *approx;
  }
              *atom_cinfo_155_t;

typedef struct kwote_node_102
  {
     struct node *node;
  }
              *kwote_node_102_t;

typedef struct kwote_cinfo_48
  {
     struct approx *approx;
  }
              *kwote_cinfo_48_t;

typedef struct app_ly_cinfo_234
  {
     struct approx *approx;
  }
                *app_ly_cinfo_234_t;

typedef struct funcall_cinfo_75
  {
     struct approx *approx;
     struct approx *va_approx_63;
     bool_t arity_error_noticed__118;
     bool_t type_error_noticed__36;
  }
                *funcall_cinfo_75_t;

typedef struct pragma_cinfo_220
  {
     struct approx *approx;
  }
                *pragma_cinfo_220_t;

typedef struct setq_cinfo_191
  {
     struct approx *approx;
  }
              *setq_cinfo_191_t;

typedef struct conditional_cinfo_212
  {
     struct approx *approx;
  }
                     *conditional_cinfo_212_t;

typedef struct fail_cinfo_75
  {
     struct approx *approx;
  }
             *fail_cinfo_75_t;

typedef struct select_cinfo_150
  {
     struct approx *approx;
  }
                *select_cinfo_150_t;

typedef struct set_ex_it_cinfo_168
  {
     struct approx *approx;
  }
                   *set_ex_it_cinfo_168_t;

typedef struct jump_ex_it_cinfo_139
  {
     struct approx *approx;
  }
                    *jump_ex_it_cinfo_139_t;

typedef struct pre_make_box_186
  {
     char dummy;
  }
                *pre_make_box_186_t;

typedef struct make_box_cinfo_127
  {
     struct approx *approx;
  }
                  *make_box_cinfo_127_t;

typedef struct make_box_o_cinfo_96
  {
     struct approx *approx;
     struct approx *value_approx_19;
  }
                   *make_box_o_cinfo_96_t;

typedef struct box_set__cinfo_94
  {
     struct approx *approx;
  }
                 *box_set__cinfo_94_t;

typedef struct box_ref_cinfo_214
  {
     struct approx *approx;
  }
                 *box_ref_cinfo_214_t;

typedef struct box_set__o_cinfo_6
  {
     struct approx *approx;
  }
                  *box_set__o_cinfo_6_t;

typedef struct box_ref_o_cinfo_98
  {
     struct approx *approx;
  }
                  *box_ref_o_cinfo_98_t;

typedef struct pre_make_procedure_app_60
  {
     struct variable *owner;
  }
                         *pre_make_procedure_app_60_t;

typedef struct pre_procedure_ref_app_85
  {
     char dummy;
  }
                        *pre_procedure_ref_app_85_t;

typedef struct pre_procedure_set__app_208
  {
     char dummy;
  }
                          *pre_procedure_set__app_208_t;

typedef struct make_procedure_app_48
  {
     struct approx *approx;
     long values_approx_len_106;
     struct approx **values_approx_79;
     long lost_stamp_114;
     bool_t x_t__142;
     bool_t x;
     bool_t t;
     struct variable *owner;
     bool_t stackable__42;
     obj_t stack_stamp_31;
  }
                     *make_procedure_app_48_t;

typedef struct procedure_ref_app_49
  {
     struct approx *approx;
  }
                    *procedure_ref_app_49_t;

typedef struct procedure_set__app_32
  {
     struct approx *approx;
  }
                     *procedure_set__app_32_t;

typedef struct pre_make_vector_app_251
  {
     struct variable *owner;
  }
                       *pre_make_vector_app_251_t;

typedef struct pre_create_vector_app_162
  {
     struct variable *owner;
  }
                         *pre_create_vector_app_162_t;

typedef struct pre_vector_ref_app_208
  {
     char dummy;
  }
                      *pre_vector_ref_app_208_t;

typedef struct pre_vector_set__app_211
  {
     char dummy;
  }
                       *pre_vector_set__app_211_t;

typedef struct make_vector_app_205
  {
     struct approx *approx;
     struct approx *value_approx_19;
     long lost_stamp_114;
     struct variable *owner;
     bool_t stackable__42;
     obj_t stack_stamp_31;
     bool_t seen__39;
  }
                   *make_vector_app_205_t;

typedef struct create_vector_app_150
  {
     struct approx *approx;
     struct approx *value_approx_19;
     long lost_stamp_114;
     struct variable *owner;
     bool_t stackable__42;
     obj_t stack_stamp_31;
     bool_t seen__39;
  }
                     *create_vector_app_150_t;

typedef struct vector_ref_app_195
  {
     struct approx *approx;
  }
                  *vector_ref_app_195_t;

typedef struct vector_set__app_21
  {
     struct approx *approx;
  }
                  *vector_set__app_21_t;

typedef struct pre_make_struct_app_218
  {
     struct variable *owner;
  }
                       *pre_make_struct_app_218_t;

typedef struct pre_struct_ref_app_207
  {
     char dummy;
  }
                      *pre_struct_ref_app_207_t;

typedef struct pre_struct_set__app_116
  {
     char dummy;
  }
                       *pre_struct_set__app_116_t;

typedef struct make_struct_app_214
  {
     struct approx *approx;
     struct approx *value_approx_19;
     long lost_stamp_114;
     struct variable *owner;
     bool_t stackable__42;
     obj_t stack_stamp_31;
  }
                   *make_struct_app_214_t;

typedef struct struct_ref_app_73
  {
     struct approx *approx;
  }
                 *struct_ref_app_73_t;

typedef struct struct_set__app_162
  {
     struct approx *approx;
  }
                   *struct_set__app_162_t;


static obj_t method_init_76_cfa_collect();
extern obj_t make_box_202_ast_node;
extern obj_t funcall_ast_node;
extern obj_t _optim__89_engine_param;
static obj_t _node_collect_2580_47_cfa_collect(obj_t, obj_t, obj_t);
extern long add_inlined_method__244___object(obj_t, obj_t, long);
extern obj_t fail_ast_node;
extern obj_t pre_struct_set__app_116_cfa_info;
static bool_t node_collect___108_cfa_collect(obj_t, variable_t);
extern obj_t box_ref_242_ast_node;
extern obj_t pre_make_struct_app_218_cfa_info;
extern obj_t pre_create_vector_app_162_cfa_info;
extern obj_t sequence_ast_node;
extern obj_t let_var_6_ast_node;
extern obj_t var_ast_node;
extern obj_t get_allocs_52_cfa_collect();
extern obj_t global_ast_var;
extern obj_t pragma_ast_node;
extern obj_t pre_procedure_set__app_208_cfa_info;
extern obj_t set_ex_it_116_ast_node;
extern bool_t is_a__118___object(obj_t, obj_t);
static obj_t _node_collect__default2124_211_cfa_collect(obj_t, obj_t, obj_t);
extern obj_t module_initialization_70_cfa_collect(long, char *);
extern obj_t module_initialization_70_tools_trace(long, char *);
extern obj_t module_initialization_70_tools_shape(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_type_cache(long, char *);
extern obj_t module_initialization_70_type_typeof(long, char *);
extern obj_t module_initialization_70_module_module(long, char *);
extern obj_t module_initialization_70_engine_param(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_ast_dump(long, char *);
extern obj_t module_initialization_70_ast_env(long, char *);
extern obj_t module_initialization_70_ast_sexp(long, char *);
extern obj_t module_initialization_70_cfa_info(long, char *);
extern obj_t module_initialization_70_cfa_procedure(long, char *);
extern obj_t module_initialization_70_cfa_vector(long, char *);
extern obj_t module_initialization_70_cfa_struct(long, char *);
extern obj_t module_initialization_70_cfa_box(long, char *);
extern obj_t module_initialization_70_cfa_closure(long, char *);
extern obj_t module_initialization_70___object(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___r4_pairs_and_lists_6_3(long, char *);
extern obj_t pre_struct_ref_app_207_cfa_info;
extern obj_t pre_make_box_186_cfa_info;
extern long class_num_218___object(obj_t);
extern obj_t scnst_ast_var;
extern obj_t pre_make_vector_app_251_cfa_info;
extern obj_t let_fun_218_ast_node;
extern obj_t add_funcall__195_cfa_closure(node_t);
static obj_t imported_modules_init_94_cfa_collect();
static obj_t node_collect__175_cfa_collect(node_t, variable_t);
extern obj_t pre_vector_set__app_211_cfa_info;
static obj_t _get_allocs_32_cfa_collect(obj_t);
extern obj_t app_ly_162_ast_node;
extern obj_t cfun_ast_var;
extern obj_t add_generic__110___object(obj_t, obj_t);
extern obj_t app_ast_node;
extern obj_t pre_make_procedure_app_60_cfa_info;
static obj_t library_modules_init_112_cfa_collect();
extern obj_t kwote_node_102_cfa_info;
extern obj_t atom_ast_node;
extern obj_t cast_ast_node;
static obj_t toplevel_init_63_cfa_collect();
extern obj_t jump_ex_it_184_ast_node;
extern obj_t open_input_string(obj_t);
extern obj_t kwote_ast_node;
extern node_t top_level_sexp__node_204_ast_sexp(obj_t, obj_t);
extern obj_t setq_ast_node;
extern obj_t box_set__221_ast_node;
static obj_t _collect_all_approx__18_cfa_collect(obj_t, obj_t);
static obj_t node_collect__default2124_48_cfa_collect(node_t, variable_t);
extern obj_t memq___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t pre_procedure_ref_app_85_cfa_info;
static bool_t monomorphic_vector__154_cfa_collect(obj_t);
extern obj_t _module__166_module_module;
extern obj_t _classes__134___object;
extern obj_t select_ast_node;
extern obj_t read___reader(obj_t);
extern obj_t pre_vector_ref_app_208_cfa_info;
extern obj_t cons__138___r4_pairs_and_lists_6_3(obj_t, obj_t);
static obj_t get_atype_143_cfa_collect(obj_t);
static obj_t require_initialization_114_cfa_collect = BUNSPEC;
extern obj_t conditional_ast_node;
extern obj_t collect_all_approx__236_cfa_collect(obj_t);
static obj_t _used_alloc__125_cfa_collect = BUNSPEC;
static obj_t cnst_init_137_cfa_collect();
static obj_t __cnst[18];

DEFINE_EXPORT_PROCEDURE(collect_all_approx__env_94_cfa_collect, _collect_all_approx__18_cfa_collect2588, _collect_all_approx__18_cfa_collect, 0L, 1);
DEFINE_STATIC_PROCEDURE(node_collect__default2124_env_164_cfa_collect, _node_collect__default2124_211_cfa_collect2589, _node_collect__default2124_211_cfa_collect, 0L, 2);
DEFINE_EXPORT_PROCEDURE(get_allocs_env_59_cfa_collect, _get_allocs_32_cfa_collect2590, _get_allocs_32_cfa_collect, 0L, 0);
DEFINE_STATIC_GENERIC(node_collect__env_176_cfa_collect, _node_collect_2580_47_cfa_collect2591, _node_collect_2580_47_cfa_collect, 0L, 2);
DEFINE_STRING(string2582_cfa_collect, string2582_cfa_collect2592, "NODE-COLLECT!-DEFAULT2124 C-STRUCT-SET! C-STRUCT-REF C-MAKE-STRUCT C-VECTOR-SET! C-VECTOR-REF C-CREATE-VECTOR PROCEDURE-SET! PROCEDURE-REF MAKE-VA-PROCEDURE MAKE-FX-PROCEDURE (PRAGMA::OBJ \"\") C-MAKE-VECTOR REAL STRING BOOLEAN CHAR INTEGER ", 239);
DEFINE_STRING(string2581_cfa_collect, string2581_cfa_collect2593, "No method for this object", 25);


/* module-initialization */ obj_t 
module_initialization_70_cfa_collect(long checksum_3786, char *from_3787)
{
   if (CBOOL(require_initialization_114_cfa_collect))
     {
	require_initialization_114_cfa_collect = BBOOL(((bool_t) 0));
	library_modules_init_112_cfa_collect();
	cnst_init_137_cfa_collect();
	imported_modules_init_94_cfa_collect();
	method_init_76_cfa_collect();
	toplevel_init_63_cfa_collect();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_cfa_collect()
{
   module_initialization_70___object(((long) 0), "CFA_COLLECT");
   module_initialization_70___r4_pairs_and_lists_6_3(((long) 0), "CFA_COLLECT");
   module_initialization_70___reader(((long) 0), "CFA_COLLECT");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_cfa_collect()
{
   {
      obj_t cnst_port_138_3778;
      cnst_port_138_3778 = open_input_string(string2582_cfa_collect);
      {
	 long i_3779;
	 i_3779 = ((long) 17);
       loop_3780:
	 {
	    bool_t test2583_3781;
	    test2583_3781 = (i_3779 == ((long) -1));
	    if (test2583_3781)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg2584_3782;
		    {
		       obj_t list2585_3783;
		       {
			  obj_t arg2586_3784;
			  arg2586_3784 = BNIL;
			  list2585_3783 = MAKE_PAIR(cnst_port_138_3778, arg2586_3784);
		       }
		       arg2584_3782 = read___reader(list2585_3783);
		    }
		    CNST_TABLE_SET(i_3779, arg2584_3782);
		 }
		 {
		    int aux_3785;
		    {
		       long aux_3805;
		       aux_3805 = (i_3779 - ((long) 1));
		       aux_3785 = (int) (aux_3805);
		    }
		    {
		       long i_3808;
		       i_3808 = (long) (aux_3785);
		       i_3779 = i_3808;
		       goto loop_3780;
		    }
		 }
	      }
	 }
      }
   }
}


/* toplevel-init */ obj_t 
toplevel_init_63_cfa_collect()
{
   return (_used_alloc__125_cfa_collect = BNIL,
      BUNSPEC);
}


/* collect-all-approx! */ obj_t 
collect_all_approx__236_cfa_collect(obj_t globals_1)
{
   {
      obj_t l2085_2157;
      {
	 bool_t aux_3810;
	 l2085_2157 = globals_1;
       lname2086_2158:
	 if (PAIRP(l2085_2157))
	   {
	      {
		 obj_t global_2160;
		 global_2160 = CAR(l2085_2157);
		 {
		    sfun_t value_3181;
		    {
		       value_t aux_3814;
		       {
			  global_t obj_3180;
			  obj_3180 = (global_t) (global_2160);
			  aux_3814 = (((global_t) CREF(obj_3180))->value);
		       }
		       value_3181 = (sfun_t) (aux_3814);
		    }
		    {
		       variable_t aux_3822;
		       node_t aux_3818;
		       {
			  global_t aux_3823;
			  aux_3823 = (global_t) (global_2160);
			  aux_3822 = (variable_t) (aux_3823);
		       }
		       {
			  obj_t aux_3819;
			  aux_3819 = (((sfun_t) CREF(value_3181))->body);
			  aux_3818 = (node_t) (aux_3819);
		       }
		       node_collect__175_cfa_collect(aux_3818, aux_3822);
		    }
		 }
	      }
	      {
		 obj_t l2085_3827;
		 l2085_3827 = CDR(l2085_2157);
		 l2085_2157 = l2085_3827;
		 goto lname2086_2158;
	      }
	   }
	 else
	   {
	      aux_3810 = ((bool_t) 1);
	   }
	 return BBOOL(aux_3810);
      }
   }
}


/* _collect-all-approx! */ obj_t 
_collect_all_approx__18_cfa_collect(obj_t env_3769, obj_t globals_3770)
{
   return collect_all_approx__236_cfa_collect(globals_3770);
}


/* monomorphic-vector? */ bool_t 
monomorphic_vector__154_cfa_collect(obj_t vector_12)
{
   {
      long len_2165;
      len_2165 = VECTOR_LENGTH(vector_12);
      if ((len_2165 == ((long) 0)))
	{
	   return ((bool_t) 0);
	}
      else
	{
	   obj_t atype_2167;
	   atype_2167 = get_atype_143_cfa_collect(VECTOR_REF(vector_12, ((long) 0)));
	   {
	      long i_2168;
	      i_2168 = ((long) 1);
	    loop_2169:
	      if (CBOOL(atype_2167))
		{
		   if ((i_2168 == len_2165))
		     {
			return ((bool_t) 1);
		     }
		   else
		     {
			bool_t test_3840;
			{
			   obj_t aux_3841;
			   aux_3841 = get_atype_143_cfa_collect(VECTOR_REF(vector_12, i_2168));
			   test_3840 = (aux_3841 == atype_2167);
			}
			if (test_3840)
			  {
			     {
				long i_3845;
				i_3845 = (i_2168 + ((long) 1));
				i_2168 = i_3845;
				goto loop_2169;
			     }
			  }
			else
			  {
			     return ((bool_t) 0);
			  }
		     }
		}
	      else
		{
		   return ((bool_t) 0);
		}
	   }
	}
   }
}


/* get-atype */ obj_t 
get_atype_143_cfa_collect(obj_t value_2176)
{
   {
      bool_t test2157_2178;
      test2157_2178 = INTEGERP(value_2176);
      if (test2157_2178)
	{
	   return CNST_TABLE_REF(((long) 0));
	}
      else
	{
	   if (CHARP(value_2176))
	     {
		return CNST_TABLE_REF(((long) 1));
	     }
	   else
	     {
		if (BOOLEANP(value_2176))
		  {
		     return CNST_TABLE_REF(((long) 2));
		  }
		else
		  {
		     if (STRINGP(value_2176))
		       {
			  return CNST_TABLE_REF(((long) 3));
		       }
		     else
		       {
			  bool_t test_3859;
			  if (test2157_2178)
			    {
			       test_3859 = ((bool_t) 1);
			    }
			  else
			    {
			       test_3859 = REALP(value_2176);
			    }
			  if (test_3859)
			    {
			       return CNST_TABLE_REF(((long) 4));
			    }
			  else
			    {
			       return BFALSE;
			    }
		       }
		  }
	     }
	}
   }
}


/* node-collect*! */ bool_t 
node_collect___108_cfa_collect(obj_t node__221_49, variable_t owner_50)
{
   {
      obj_t l2122_2184;
      l2122_2184 = node__221_49;
    lname2123_2185:
      if (PAIRP(l2122_2184))
	{
	   {
	      node_t aux_3865;
	      {
		 obj_t aux_3866;
		 aux_3866 = CAR(l2122_2184);
		 aux_3865 = (node_t) (aux_3866);
	      }
	      node_collect__175_cfa_collect(aux_3865, owner_50);
	   }
	   {
	      obj_t l2122_3870;
	      l2122_3870 = CDR(l2122_2184);
	      l2122_2184 = l2122_3870;
	      goto lname2123_2185;
	   }
	}
      else
	{
	   return ((bool_t) 1);
	}
   }
}


/* get-allocs */ obj_t 
get_allocs_52_cfa_collect()
{
   return _used_alloc__125_cfa_collect;
}


/* _get-allocs */ obj_t 
_get_allocs_32_cfa_collect(obj_t env_3771)
{
   return get_allocs_52_cfa_collect();
}


/* method-init */ obj_t 
method_init_76_cfa_collect()
{
   add_generic__110___object(node_collect__env_176_cfa_collect, node_collect__default2124_env_164_cfa_collect);
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, atom_ast_node, ((long) 0));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, kwote_ast_node, ((long) 1));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, var_ast_node, ((long) 2));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, sequence_ast_node, ((long) 3));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, app_ast_node, ((long) 4));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, app_ly_162_ast_node, ((long) 5));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, funcall_ast_node, ((long) 6));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, pragma_ast_node, ((long) 7));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, cast_ast_node, ((long) 8));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, setq_ast_node, ((long) 9));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, conditional_ast_node, ((long) 10));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, fail_ast_node, ((long) 11));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, select_ast_node, ((long) 12));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, let_fun_218_ast_node, ((long) 13));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, let_var_6_ast_node, ((long) 14));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, set_ex_it_116_ast_node, ((long) 15));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, jump_ex_it_184_ast_node, ((long) 16));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, make_box_202_ast_node, ((long) 17));
   add_inlined_method__244___object(node_collect__env_176_cfa_collect, box_set__221_ast_node, ((long) 18));
   {
      long aux_3893;
      aux_3893 = add_inlined_method__244___object(node_collect__env_176_cfa_collect, box_ref_242_ast_node, ((long) 19));
      return BINT(aux_3893);
   }
}


/* node-collect! */ obj_t 
node_collect__175_cfa_collect(node_t node_4, variable_t owner_5)
{
 node_collect__175_cfa_collect:
   {
      obj_t method2422_2957;
      obj_t class2427_2958;
      {
	 obj_t arg2430_2955;
	 obj_t arg2431_2956;
	 {
	    object_t obj_3560;
	    obj_3560 = (object_t) (node_4);
	    {
	       obj_t pre_method_105_3561;
	       pre_method_105_3561 = PROCEDURE_REF(node_collect__env_176_cfa_collect, ((long) 2));
	       if (INTEGERP(pre_method_105_3561))
		 {
		    PROCEDURE_SET(node_collect__env_176_cfa_collect, ((long) 2), BUNSPEC);
		    arg2430_2955 = pre_method_105_3561;
		 }
	       else
		 {
		    long obj_class_num_177_3566;
		    obj_class_num_177_3566 = TYPE(obj_3560);
		    {
		       obj_t arg1177_3567;
		       arg1177_3567 = PROCEDURE_REF(node_collect__env_176_cfa_collect, ((long) 1));
		       {
			  long arg1178_3571;
			  {
			     long arg1179_3572;
			     arg1179_3572 = OBJECT_TYPE;
			     arg1178_3571 = (obj_class_num_177_3566 - arg1179_3572);
			  }
			  arg2430_2955 = VECTOR_REF(arg1177_3567, arg1178_3571);
		       }
		    }
		 }
	    }
	 }
	 {
	    object_t object_3577;
	    object_3577 = (object_t) (node_4);
	    {
	       long arg1180_3578;
	       {
		  long arg1181_3579;
		  long arg1182_3580;
		  arg1181_3579 = TYPE(object_3577);
		  arg1182_3580 = OBJECT_TYPE;
		  arg1180_3578 = (arg1181_3579 - arg1182_3580);
	       }
	       {
		  obj_t vector_3584;
		  vector_3584 = _classes__134___object;
		  arg2431_2956 = VECTOR_REF(vector_3584, arg1180_3578);
	       }
	    }
	 }
	 method2422_2957 = arg2430_2955;
	 class2427_2958 = arg2431_2956;
	 {
	    if (INTEGERP(method2422_2957))
	      {
		 switch ((long) CINT(method2422_2957))
		   {
		   case ((long) 0):
		      return BUNSPEC;
		      break;
		   case ((long) 1):
		      {
			 kwote_t node_2966;
			 node_2966 = (kwote_t) (node_4);
			 {
			    obj_t value_2968;
			    value_2968 = (((kwote_t) CREF(node_2966))->value);
			    {
			       bool_t test2434_2969;
			       {
				  bool_t test2448_2985;
				  {
				     long n1_3587;
				     n1_3587 = (long) CINT(_optim__89_engine_param);
				     test2448_2985 = (n1_3587 >= ((long) 2));
				  }
				  if (test2448_2985)
				    {
				       test2434_2969 = VECTORP(value_2968);
				    }
				  else
				    {
				       test2434_2969 = ((bool_t) 0);
				    }
			       }
			       if (test2434_2969)
				 {
				    node_t dummy_2970;
				    {
				       obj_t arg2438_2975;
				       {
					  obj_t arg2439_2976;
					  long arg2440_2977;
					  obj_t arg2441_2978;
					  arg2439_2976 = CNST_TABLE_REF(((long) 5));
					  arg2440_2977 = VECTOR_LENGTH(value_2968);
					  if (monomorphic_vector__154_cfa_collect(value_2968))
					    {
					       arg2441_2978 = VECTOR_REF(value_2968, ((long) 0));
					    }
					  else
					    {
					       arg2441_2978 = CNST_TABLE_REF(((long) 6));
					    }
					  {
					     obj_t list2443_2980;
					     {
						obj_t arg2444_2981;
						{
						   obj_t arg2445_2982;
						   arg2445_2982 = MAKE_PAIR(BNIL, BNIL);
						   arg2444_2981 = MAKE_PAIR(arg2441_2978, arg2445_2982);
						}
						{
						   obj_t aux_3928;
						   aux_3928 = BINT(arg2440_2977);
						   list2443_2980 = MAKE_PAIR(aux_3928, arg2444_2981);
						}
					     }
					     arg2438_2975 = cons__138___r4_pairs_and_lists_6_3(arg2439_2976, list2443_2980);
					  }
				       }
				       dummy_2970 = top_level_sexp__node_204_ast_sexp(arg2438_2975, BFALSE);
				    }
				    {
				       kwote_node_102_t obj2087_2971;
				       obj2087_2971 = ((kwote_node_102_t) (node_2966));
				       {
					  kwote_node_102_t arg2435_2972;
					  {
					     kwote_node_102_t res2566_3596;
					     {
						kwote_node_102_t new1627_3594;
						new1627_3594 = ((kwote_node_102_t) BREF(GC_MALLOC(sizeof(struct kwote_node_102))));
						((((kwote_node_102_t) CREF(new1627_3594))->node) = ((node_t) dummy_2970), BUNSPEC);
						res2566_3596 = new1627_3594;
					     }
					     arg2435_2972 = res2566_3596;
					  }
					  {
					     obj_t aux_3938;
					     object_t aux_3936;
					     aux_3938 = (obj_t) (arg2435_2972);
					     aux_3936 = (object_t) (obj2087_2971);
					     OBJECT_WIDENING_SET(aux_3936, aux_3938);
					  }
				       }
				       {
					  long arg2437_2974;
					  arg2437_2974 = class_num_218___object(kwote_node_102_cfa_info);
					  {
					     obj_t obj_3597;
					     obj_3597 = (obj_t) (obj2087_2971);
					     (((obj_t) CREF(obj_3597))->header = MAKE_HEADER(arg2437_2974, 0), BUNSPEC);
					  }
				       }
				       obj2087_2971;
				    }
				    {
				       node_t node_3944;
				       node_3944 = dummy_2970;
				       node_4 = node_3944;
				       goto node_collect__175_cfa_collect;
				    }
				 }
			       else
				 {
				    return BUNSPEC;
				 }
			    }
			 }
		      }
		      break;
		   case ((long) 2):
		      {
			 var_t node_2986;
			 node_2986 = (var_t) (node_4);
			 {
			    variable_t v_2988;
			    v_2988 = (((var_t) CREF(node_2986))->variable);
			    {
			       bool_t test2449_2989;
			       {
				  bool_t test2452_2992;
				  test2452_2992 = is_a__118___object((obj_t) (v_2988), global_ast_var);
				  if (test2452_2992)
				    {
				       bool_t test2453_2993;
				       {
					  obj_t obj2_3603;
					  obj2_3603 = _module__166_module_module;
					  {
					     obj_t aux_3950;
					     {
						global_t obj_3601;
						obj_3601 = (global_t) (v_2988);
						aux_3950 = (((global_t) CREF(obj_3601))->module);
					     }
					     test2453_2993 = (aux_3950 == obj2_3603);
					  }
				       }
				       if (test2453_2993)
					 {
					    bool_t test2454_2994;
					    {
					       obj_t aux_3955;
					       {
						  value_t aux_3956;
						  {
						     global_t obj_3604;
						     obj_3604 = (global_t) (v_2988);
						     aux_3956 = (((global_t) CREF(obj_3604))->value);
						  }
						  aux_3955 = (obj_t) (aux_3956);
					       }
					       test2454_2994 = is_a__118___object(aux_3955, scnst_ast_var);
					    }
					    if (test2454_2994)
					      {
						 bool_t test2455_2995;
						 {
						    obj_t aux_3962;
						    {
						       obj_t aux_3963;
						       {
							  scnst_t obj_3607;
							  {
							     value_t aux_3964;
							     {
								global_t obj_3606;
								obj_3606 = (global_t) (v_2988);
								aux_3964 = (((global_t) CREF(obj_3606))->value);
							     }
							     obj_3607 = (scnst_t) (aux_3964);
							  }
							  aux_3963 = (((scnst_t) CREF(obj_3607))->node);
						       }
						       aux_3962 = memq___r4_pairs_and_lists_6_3(aux_3963, _used_alloc__125_cfa_collect);
						    }
						    test2455_2995 = CBOOL(aux_3962);
						 }
						 if (test2455_2995)
						   {
						      test2449_2989 = ((bool_t) 0);
						   }
						 else
						   {
						      test2449_2989 = ((bool_t) 1);
						   }
					      }
					    else
					      {
						 test2449_2989 = ((bool_t) 0);
					      }
					 }
				       else
					 {
					    test2449_2989 = ((bool_t) 0);
					 }
				    }
				  else
				    {
				       test2449_2989 = ((bool_t) 0);
				    }
			       }
			       if (test2449_2989)
				 {
				    {
				       node_t aux_3973;
				       {
					  obj_t aux_3974;
					  {
					     scnst_t obj_3610;
					     {
						value_t aux_3975;
						{
						   global_t obj_3609;
						   obj_3609 = (global_t) (v_2988);
						   aux_3975 = (((global_t) CREF(obj_3609))->value);
						}
						obj_3610 = (scnst_t) (aux_3975);
					     }
					     aux_3974 = (((scnst_t) CREF(obj_3610))->node);
					  }
					  aux_3973 = (node_t) (aux_3974);
				       }
				       node_collect__175_cfa_collect(aux_3973, owner_5);
				    }
				 }
			       else
				 {
				    BUNSPEC;
				 }
			    }
			 }
			 return BUNSPEC;
		      }
		      break;
		   case ((long) 3):
		      {
			 sequence_t node_3000;
			 node_3000 = (sequence_t) (node_4);
			 {
			    bool_t aux_3983;
			    aux_3983 = node_collect___108_cfa_collect((((sequence_t) CREF(node_3000))->nodes), owner_5);
			    return BBOOL(aux_3983);
			 }
		      }
		      break;
		   case ((long) 4):
		      {
			 app_t node_3003;
			 node_3003 = (app_t) (node_4);
			 node_collect___108_cfa_collect((((app_t) CREF(node_3003))->args), owner_5);
			 {
			    node_t aux_3990;
			    {
			       var_t aux_3991;
			       aux_3991 = (((app_t) CREF(node_3003))->fun);
			       aux_3990 = (node_t) (aux_3991);
			    }
			    node_collect__175_cfa_collect(aux_3990, owner_5);
			 }
			 {
			    variable_t v_3008;
			    {
			       var_t arg2519_3075;
			       arg2519_3075 = (((app_t) CREF(node_3003))->fun);
			       v_3008 = (((var_t) CREF(arg2519_3075))->variable);
			    }
			    {
			       bool_t test2464_3009;
			       {
				  bool_t test2517_3073;
				  test2517_3073 = is_a__118___object((obj_t) (v_3008), global_ast_var);
				  if (test2517_3073)
				    {
				       obj_t aux_4000;
				       {
					  value_t aux_4001;
					  aux_4001 = (((variable_t) CREF(v_3008))->value);
					  aux_4000 = (obj_t) (aux_4001);
				       }
				       test2464_3009 = is_a__118___object(aux_4000, cfun_ast_var);
				    }
				  else
				    {
				       test2464_3009 = ((bool_t) 0);
				    }
			       }
			       if (test2464_3009)
				 {
				    {
				       obj_t case_value_58_3010;
				       {
					  global_t obj_3619;
					  obj_3619 = (global_t) (v_3008);
					  case_value_58_3010 = (((global_t) CREF(obj_3619))->id);
				       }
				       {
					  bool_t test_4008;
					  {
					     obj_t aux_4009;
					     aux_4009 = CNST_TABLE_REF(((long) 7));
					     test_4008 = (case_value_58_3010 == aux_4009);
					  }
					  if (test_4008)
					    {
					       {
						  obj_t obj2_3624;
						  obj2_3624 = _used_alloc__125_cfa_collect;
						  {
						     obj_t aux_4012;
						     aux_4012 = (obj_t) (node_3003);
						     _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4012, obj2_3624);
						  }
					       }
					       {
						  pre_make_procedure_app_60_t obj2089_3012;
						  obj2089_3012 = ((pre_make_procedure_app_60_t) (node_3003));
						  {
						     pre_make_procedure_app_60_t arg2466_3013;
						     {
							pre_make_procedure_app_60_t res2567_3628;
							{
							   pre_make_procedure_app_60_t new1803_3626;
							   new1803_3626 = ((pre_make_procedure_app_60_t) BREF(GC_MALLOC(sizeof(struct pre_make_procedure_app_60))));
							   ((((pre_make_procedure_app_60_t) CREF(new1803_3626))->owner) = ((variable_t) owner_5), BUNSPEC);
							   res2567_3628 = new1803_3626;
							}
							arg2466_3013 = res2567_3628;
						     }
						     {
							obj_t aux_4020;
							object_t aux_4018;
							aux_4020 = (obj_t) (arg2466_3013);
							aux_4018 = (object_t) (obj2089_3012);
							OBJECT_WIDENING_SET(aux_4018, aux_4020);
						     }
						  }
						  {
						     long arg2468_3015;
						     arg2468_3015 = class_num_218___object(pre_make_procedure_app_60_cfa_info);
						     {
							obj_t obj_3629;
							obj_3629 = (obj_t) (obj2089_3012);
							(((obj_t) CREF(obj_3629))->header = MAKE_HEADER(arg2468_3015, 0), BUNSPEC);
						     }
						  }
						  (obj_t) (obj2089_3012);
					       }
					    }
					  else
					    {
					       bool_t test_4027;
					       {
						  obj_t aux_4028;
						  aux_4028 = CNST_TABLE_REF(((long) 8));
						  test_4027 = (case_value_58_3010 == aux_4028);
					       }
					       if (test_4027)
						 {
						    {
						       obj_t obj2_3635;
						       obj2_3635 = _used_alloc__125_cfa_collect;
						       {
							  obj_t aux_4031;
							  aux_4031 = (obj_t) (node_3003);
							  _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4031, obj2_3635);
						       }
						    }
						    {
						       pre_make_procedure_app_60_t obj2090_3017;
						       obj2090_3017 = ((pre_make_procedure_app_60_t) (node_3003));
						       {
							  pre_make_procedure_app_60_t arg2470_3018;
							  {
							     pre_make_procedure_app_60_t res2568_3639;
							     {
								pre_make_procedure_app_60_t new1803_3637;
								new1803_3637 = ((pre_make_procedure_app_60_t) BREF(GC_MALLOC(sizeof(struct pre_make_procedure_app_60))));
								((((pre_make_procedure_app_60_t) CREF(new1803_3637))->owner) = ((variable_t) owner_5), BUNSPEC);
								res2568_3639 = new1803_3637;
							     }
							     arg2470_3018 = res2568_3639;
							  }
							  {
							     obj_t aux_4039;
							     object_t aux_4037;
							     aux_4039 = (obj_t) (arg2470_3018);
							     aux_4037 = (object_t) (obj2090_3017);
							     OBJECT_WIDENING_SET(aux_4037, aux_4039);
							  }
						       }
						       {
							  long arg2472_3020;
							  arg2472_3020 = class_num_218___object(pre_make_procedure_app_60_cfa_info);
							  {
							     obj_t obj_3640;
							     obj_3640 = (obj_t) (obj2090_3017);
							     (((obj_t) CREF(obj_3640))->header = MAKE_HEADER(arg2472_3020, 0), BUNSPEC);
							  }
						       }
						       (obj_t) (obj2090_3017);
						    }
						 }
					       else
						 {
						    bool_t test_4046;
						    {
						       obj_t aux_4047;
						       aux_4047 = CNST_TABLE_REF(((long) 9));
						       test_4046 = (case_value_58_3010 == aux_4047);
						    }
						    if (test_4046)
						      {
							 pre_procedure_ref_app_85_t obj2091_3022;
							 obj2091_3022 = ((pre_procedure_ref_app_85_t) (node_3003));
							 {
							    obj_t aux_4053;
							    object_t aux_4051;
							    {
							       pre_procedure_ref_app_85_t aux_4054;
							       {
								  aux_4054 = ((pre_procedure_ref_app_85_t) BREF(GC_MALLOC(sizeof(struct pre_procedure_ref_app_85))));
							       }
							       aux_4053 = (obj_t) (aux_4054);
							    }
							    aux_4051 = (object_t) (obj2091_3022);
							    OBJECT_WIDENING_SET(aux_4051, aux_4053);
							 }
							 {
							    long arg2475_3024;
							    arg2475_3024 = class_num_218___object(pre_procedure_ref_app_85_cfa_info);
							    {
							       obj_t obj_3646;
							       obj_3646 = (obj_t) (obj2091_3022);
							       (((obj_t) CREF(obj_3646))->header = MAKE_HEADER(arg2475_3024, 0), BUNSPEC);
							    }
							 }
							 (obj_t) (obj2091_3022);
						      }
						    else
						      {
							 bool_t test_4062;
							 {
							    obj_t aux_4063;
							    aux_4063 = CNST_TABLE_REF(((long) 10));
							    test_4062 = (case_value_58_3010 == aux_4063);
							 }
							 if (test_4062)
							   {
							      pre_procedure_set__app_208_t obj2092_3026;
							      obj2092_3026 = ((pre_procedure_set__app_208_t) (node_3003));
							      {
								 obj_t aux_4069;
								 object_t aux_4067;
								 {
								    pre_procedure_set__app_208_t aux_4070;
								    {
								       aux_4070 = ((pre_procedure_set__app_208_t) BREF(GC_MALLOC(sizeof(struct pre_procedure_set__app_208))));
								    }
								    aux_4069 = (obj_t) (aux_4070);
								 }
								 aux_4067 = (object_t) (obj2092_3026);
								 OBJECT_WIDENING_SET(aux_4067, aux_4069);
							      }
							      {
								 long arg2478_3028;
								 arg2478_3028 = class_num_218___object(pre_procedure_set__app_208_cfa_info);
								 {
								    obj_t obj_3652;
								    obj_3652 = (obj_t) (obj2092_3026);
								    (((obj_t) CREF(obj_3652))->header = MAKE_HEADER(arg2478_3028, 0), BUNSPEC);
								 }
							      }
							      (obj_t) (obj2092_3026);
							   }
							 else
							   {
							      BFALSE;
							   }
						      }
						 }
					    }
				       }
				    }
				    {
				       bool_t test2483_3033;
				       {
					  long n1_3654;
					  n1_3654 = (long) CINT(_optim__89_engine_param);
					  test2483_3033 = (n1_3654 >= ((long) 2));
				       }
				       if (test2483_3033)
					 {
					    obj_t case_value_58_3034;
					    {
					       global_t obj_3656;
					       obj_3656 = (global_t) (v_3008);
					       case_value_58_3034 = (((global_t) CREF(obj_3656))->id);
					    }
					    {
					       bool_t test_4083;
					       {
						  obj_t aux_4084;
						  aux_4084 = CNST_TABLE_REF(((long) 5));
						  test_4083 = (case_value_58_3034 == aux_4084);
					       }
					       if (test_4083)
						 {
						    {
						       obj_t obj2_3661;
						       obj2_3661 = _used_alloc__125_cfa_collect;
						       {
							  obj_t aux_4087;
							  aux_4087 = (obj_t) (node_3003);
							  _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4087, obj2_3661);
						       }
						    }
						    {
						       pre_make_vector_app_251_t obj2093_3036;
						       obj2093_3036 = ((pre_make_vector_app_251_t) (node_3003));
						       {
							  pre_make_vector_app_251_t arg2485_3037;
							  {
							     pre_make_vector_app_251_t res2571_3665;
							     {
								pre_make_vector_app_251_t new1890_3663;
								new1890_3663 = ((pre_make_vector_app_251_t) BREF(GC_MALLOC(sizeof(struct pre_make_vector_app_251))));
								((((pre_make_vector_app_251_t) CREF(new1890_3663))->owner) = ((variable_t) owner_5), BUNSPEC);
								res2571_3665 = new1890_3663;
							     }
							     arg2485_3037 = res2571_3665;
							  }
							  {
							     obj_t aux_4095;
							     object_t aux_4093;
							     aux_4095 = (obj_t) (arg2485_3037);
							     aux_4093 = (object_t) (obj2093_3036);
							     OBJECT_WIDENING_SET(aux_4093, aux_4095);
							  }
						       }
						       {
							  long arg2487_3039;
							  arg2487_3039 = class_num_218___object(pre_make_vector_app_251_cfa_info);
							  {
							     obj_t obj_3666;
							     obj_3666 = (obj_t) (obj2093_3036);
							     (((obj_t) CREF(obj_3666))->header = MAKE_HEADER(arg2487_3039, 0), BUNSPEC);
							  }
						       }
						       return (obj_t) (obj2093_3036);
						    }
						 }
					       else
						 {
						    bool_t test_4102;
						    {
						       obj_t aux_4103;
						       aux_4103 = CNST_TABLE_REF(((long) 11));
						       test_4102 = (case_value_58_3034 == aux_4103);
						    }
						    if (test_4102)
						      {
							 {
							    obj_t obj2_3672;
							    obj2_3672 = _used_alloc__125_cfa_collect;
							    {
							       obj_t aux_4106;
							       aux_4106 = (obj_t) (node_3003);
							       _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4106, obj2_3672);
							    }
							 }
							 {
							    pre_create_vector_app_162_t obj2095_3041;
							    obj2095_3041 = ((pre_create_vector_app_162_t) (node_3003));
							    {
							       pre_create_vector_app_162_t arg2489_3042;
							       {
								  pre_create_vector_app_162_t res2572_3676;
								  {
								     pre_create_vector_app_162_t new1902_3674;
								     new1902_3674 = ((pre_create_vector_app_162_t) BREF(GC_MALLOC(sizeof(struct pre_create_vector_app_162))));
								     ((((pre_create_vector_app_162_t) CREF(new1902_3674))->owner) = ((variable_t) owner_5), BUNSPEC);
								     res2572_3676 = new1902_3674;
								  }
								  arg2489_3042 = res2572_3676;
							       }
							       {
								  obj_t aux_4114;
								  object_t aux_4112;
								  aux_4114 = (obj_t) (arg2489_3042);
								  aux_4112 = (object_t) (obj2095_3041);
								  OBJECT_WIDENING_SET(aux_4112, aux_4114);
							       }
							    }
							    {
							       long arg2491_3044;
							       arg2491_3044 = class_num_218___object(pre_create_vector_app_162_cfa_info);
							       {
								  obj_t obj_3677;
								  obj_3677 = (obj_t) (obj2095_3041);
								  (((obj_t) CREF(obj_3677))->header = MAKE_HEADER(arg2491_3044, 0), BUNSPEC);
							       }
							    }
							    return (obj_t) (obj2095_3041);
							 }
						      }
						    else
						      {
							 bool_t test_4121;
							 {
							    obj_t aux_4122;
							    aux_4122 = CNST_TABLE_REF(((long) 12));
							    test_4121 = (case_value_58_3034 == aux_4122);
							 }
							 if (test_4121)
							   {
							      pre_vector_ref_app_208_t obj2096_3046;
							      obj2096_3046 = ((pre_vector_ref_app_208_t) (node_3003));
							      {
								 obj_t aux_4128;
								 object_t aux_4126;
								 {
								    pre_vector_ref_app_208_t aux_4129;
								    {
								       aux_4129 = ((pre_vector_ref_app_208_t) BREF(GC_MALLOC(sizeof(struct pre_vector_ref_app_208))));
								    }
								    aux_4128 = (obj_t) (aux_4129);
								 }
								 aux_4126 = (object_t) (obj2096_3046);
								 OBJECT_WIDENING_SET(aux_4126, aux_4128);
							      }
							      {
								 long arg2494_3048;
								 arg2494_3048 = class_num_218___object(pre_vector_ref_app_208_cfa_info);
								 {
								    obj_t obj_3683;
								    obj_3683 = (obj_t) (obj2096_3046);
								    (((obj_t) CREF(obj_3683))->header = MAKE_HEADER(arg2494_3048, 0), BUNSPEC);
								 }
							      }
							      return (obj_t) (obj2096_3046);
							   }
							 else
							   {
							      bool_t test_4137;
							      {
								 obj_t aux_4138;
								 aux_4138 = CNST_TABLE_REF(((long) 13));
								 test_4137 = (case_value_58_3034 == aux_4138);
							      }
							      if (test_4137)
								{
								   pre_vector_set__app_211_t obj2097_3050;
								   obj2097_3050 = ((pre_vector_set__app_211_t) (node_3003));
								   {
								      obj_t aux_4144;
								      object_t aux_4142;
								      {
									 pre_vector_set__app_211_t aux_4145;
									 {
									    aux_4145 = ((pre_vector_set__app_211_t) BREF(GC_MALLOC(sizeof(struct pre_vector_set__app_211))));
									 }
									 aux_4144 = (obj_t) (aux_4145);
								      }
								      aux_4142 = (object_t) (obj2097_3050);
								      OBJECT_WIDENING_SET(aux_4142, aux_4144);
								   }
								   {
								      long arg2497_3052;
								      arg2497_3052 = class_num_218___object(pre_vector_set__app_211_cfa_info);
								      {
									 obj_t obj_3689;
									 obj_3689 = (obj_t) (obj2097_3050);
									 (((obj_t) CREF(obj_3689))->header = MAKE_HEADER(arg2497_3052, 0), BUNSPEC);
								      }
								   }
								   return (obj_t) (obj2097_3050);
								}
							      else
								{
								   bool_t test_4153;
								   {
								      obj_t aux_4154;
								      aux_4154 = CNST_TABLE_REF(((long) 14));
								      test_4153 = (case_value_58_3034 == aux_4154);
								   }
								   if (test_4153)
								     {
									{
									   obj_t obj2_3695;
									   obj2_3695 = _used_alloc__125_cfa_collect;
									   {
									      obj_t aux_4157;
									      aux_4157 = (obj_t) (node_3003);
									      _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4157, obj2_3695);
									   }
									}
									{
									   pre_make_struct_app_218_t obj2098_3054;
									   obj2098_3054 = ((pre_make_struct_app_218_t) (node_3003));
									   {
									      pre_make_struct_app_218_t arg2499_3055;
									      {
										 pre_make_struct_app_218_t res2575_3699;
										 {
										    pre_make_struct_app_218_t new2006_3697;
										    new2006_3697 = ((pre_make_struct_app_218_t) BREF(GC_MALLOC(sizeof(struct pre_make_struct_app_218))));
										    ((((pre_make_struct_app_218_t) CREF(new2006_3697))->owner) = ((variable_t) owner_5), BUNSPEC);
										    res2575_3699 = new2006_3697;
										 }
										 arg2499_3055 = res2575_3699;
									      }
									      {
										 obj_t aux_4165;
										 object_t aux_4163;
										 aux_4165 = (obj_t) (arg2499_3055);
										 aux_4163 = (object_t) (obj2098_3054);
										 OBJECT_WIDENING_SET(aux_4163, aux_4165);
									      }
									   }
									   {
									      long arg2501_3057;
									      arg2501_3057 = class_num_218___object(pre_make_struct_app_218_cfa_info);
									      {
										 obj_t obj_3700;
										 obj_3700 = (obj_t) (obj2098_3054);
										 (((obj_t) CREF(obj_3700))->header = MAKE_HEADER(arg2501_3057, 0), BUNSPEC);
									      }
									   }
									   return (obj_t) (obj2098_3054);
									}
								     }
								   else
								     {
									bool_t test_4172;
									{
									   obj_t aux_4173;
									   aux_4173 = CNST_TABLE_REF(((long) 15));
									   test_4172 = (case_value_58_3034 == aux_4173);
									}
									if (test_4172)
									  {
									     pre_struct_ref_app_207_t obj2099_3059;
									     obj2099_3059 = ((pre_struct_ref_app_207_t) (node_3003));
									     {
										obj_t aux_4179;
										object_t aux_4177;
										{
										   pre_struct_ref_app_207_t aux_4180;
										   {
										      aux_4180 = ((pre_struct_ref_app_207_t) BREF(GC_MALLOC(sizeof(struct pre_struct_ref_app_207))));
										   }
										   aux_4179 = (obj_t) (aux_4180);
										}
										aux_4177 = (object_t) (obj2099_3059);
										OBJECT_WIDENING_SET(aux_4177, aux_4179);
									     }
									     {
										long arg2504_3061;
										arg2504_3061 = class_num_218___object(pre_struct_ref_app_207_cfa_info);
										{
										   obj_t obj_3706;
										   obj_3706 = (obj_t) (obj2099_3059);
										   (((obj_t) CREF(obj_3706))->header = MAKE_HEADER(arg2504_3061, 0), BUNSPEC);
										}
									     }
									     return (obj_t) (obj2099_3059);
									  }
									else
									  {
									     bool_t test_4188;
									     {
										obj_t aux_4189;
										aux_4189 = CNST_TABLE_REF(((long) 16));
										test_4188 = (case_value_58_3034 == aux_4189);
									     }
									     if (test_4188)
									       {
										  pre_struct_set__app_116_t obj2100_3063;
										  obj2100_3063 = ((pre_struct_set__app_116_t) (node_3003));
										  {
										     obj_t aux_4195;
										     object_t aux_4193;
										     {
											pre_struct_set__app_116_t aux_4196;
											{
											   aux_4196 = ((pre_struct_set__app_116_t) BREF(GC_MALLOC(sizeof(struct pre_struct_set__app_116))));
											}
											aux_4195 = (obj_t) (aux_4196);
										     }
										     aux_4193 = (object_t) (obj2100_3063);
										     OBJECT_WIDENING_SET(aux_4193, aux_4195);
										  }
										  {
										     long arg2507_3065;
										     arg2507_3065 = class_num_218___object(pre_struct_set__app_116_cfa_info);
										     {
											obj_t obj_3712;
											obj_3712 = (obj_t) (obj2100_3063);
											(((obj_t) CREF(obj_3712))->header = MAKE_HEADER(arg2507_3065, 0), BUNSPEC);
										     }
										  }
										  return (obj_t) (obj2100_3063);
									       }
									     else
									       {
										  return BFALSE;
									       }
									  }
								     }
								}
							   }
						      }
						 }
					    }
					 }
				       else
					 {
					    return BUNSPEC;
					 }
				    }
				 }
			       else
				 {
				    return BUNSPEC;
				 }
			    }
			 }
		      }
		      break;
		   case ((long) 5):
		      {
			 app_ly_162_t node_3076;
			 node_3076 = (app_ly_162_t) (node_4);
			 node_collect__175_cfa_collect((((app_ly_162_t) CREF(node_3076))->fun), owner_5);
			 {
			    node_t node_4207;
			    node_4207 = (((app_ly_162_t) CREF(node_3076))->arg);
			    node_4 = node_4207;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 6):
		      {
			 funcall_t node_3081;
			 node_3081 = (funcall_t) (node_4);
			 add_funcall__195_cfa_closure((node_t) (node_3081));
			 node_collect__175_cfa_collect((((funcall_t) CREF(node_3081))->fun), owner_5);
			 {
			    bool_t aux_4214;
			    aux_4214 = node_collect___108_cfa_collect((((funcall_t) CREF(node_3081))->args), owner_5);
			    return BBOOL(aux_4214);
			 }
		      }
		      break;
		   case ((long) 7):
		      {
			 pragma_t node_3086;
			 node_3086 = (pragma_t) (node_4);
			 {
			    bool_t aux_4219;
			    aux_4219 = node_collect___108_cfa_collect((((pragma_t) CREF(node_3086))->args), owner_5);
			    return BBOOL(aux_4219);
			 }
		      }
		      break;
		   case ((long) 8):
		      {
			 cast_t node_3090;
			 node_3090 = (cast_t) (node_4);
			 {
			    node_t node_4224;
			    node_4224 = (((cast_t) CREF(node_3090))->arg);
			    node_4 = node_4224;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 9):
		      {
			 setq_t node_3094;
			 node_3094 = (setq_t) (node_4);
			 {
			    node_t node_4227;
			    node_4227 = (((setq_t) CREF(node_3094))->value);
			    node_4 = node_4227;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 10):
		      {
			 conditional_t node_3098;
			 node_3098 = (conditional_t) (node_4);
			 node_collect__175_cfa_collect((((conditional_t) CREF(node_3098))->test), owner_5);
			 node_collect__175_cfa_collect((((conditional_t) CREF(node_3098))->true), owner_5);
			 {
			    node_t node_4234;
			    node_4234 = (((conditional_t) CREF(node_3098))->false);
			    node_4 = node_4234;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 11):
		      {
			 fail_t node_3104;
			 node_3104 = (fail_t) (node_4);
			 node_collect__175_cfa_collect((((fail_t) CREF(node_3104))->proc), owner_5);
			 node_collect__175_cfa_collect((((fail_t) CREF(node_3104))->msg), owner_5);
			 {
			    node_t node_4241;
			    node_4241 = (((fail_t) CREF(node_3104))->obj);
			    node_4 = node_4241;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 12):
		      {
			 select_t node_3110;
			 node_3110 = (select_t) (node_4);
			 node_collect__175_cfa_collect((((select_t) CREF(node_3110))->test), owner_5);
			 {
			    obj_t l2109_3114;
			    {
			       bool_t aux_4246;
			       l2109_3114 = (((select_t) CREF(node_3110))->clauses);
			     lname2110_3115:
			       if (PAIRP(l2109_3114))
				 {
				    {
				       node_t aux_4249;
				       {
					  obj_t aux_4250;
					  {
					     obj_t aux_4251;
					     aux_4251 = CAR(l2109_3114);
					     aux_4250 = CDR(aux_4251);
					  }
					  aux_4249 = (node_t) (aux_4250);
				       }
				       node_collect__175_cfa_collect(aux_4249, owner_5);
				    }
				    {
				       obj_t l2109_4256;
				       l2109_4256 = CDR(l2109_3114);
				       l2109_3114 = l2109_4256;
				       goto lname2110_3115;
				    }
				 }
			       else
				 {
				    aux_4246 = ((bool_t) 1);
				 }
			       return BBOOL(aux_4246);
			    }
			 }
		      }
		      break;
		   case ((long) 13):
		      {
			 let_fun_218_t node_3121;
			 node_3121 = (let_fun_218_t) (node_4);
			 {
			    obj_t l2112_3124;
			    l2112_3124 = (((let_fun_218_t) CREF(node_3121))->locals);
			  lname2113_3125:
			    if (PAIRP(l2112_3124))
			      {
				 {
				    obj_t l_3128;
				    l_3128 = CAR(l2112_3124);
				    {
				       node_t aux_4264;
				       {
					  obj_t aux_4265;
					  {
					     sfun_t obj_3737;
					     {
						value_t aux_4266;
						{
						   local_t obj_3736;
						   obj_3736 = (local_t) (l_3128);
						   aux_4266 = (((local_t) CREF(obj_3736))->value);
						}
						obj_3737 = (sfun_t) (aux_4266);
					     }
					     aux_4265 = (((sfun_t) CREF(obj_3737))->body);
					  }
					  aux_4264 = (node_t) (aux_4265);
				       }
				       node_collect__175_cfa_collect(aux_4264, (variable_t) (l_3128));
				    }
				 }
				 {
				    obj_t l2112_4274;
				    l2112_4274 = CDR(l2112_3124);
				    l2112_3124 = l2112_4274;
				    goto lname2113_3125;
				 }
			      }
			    else
			      {
				 ((bool_t) 1);
			      }
			 }
			 {
			    node_t node_4277;
			    node_4277 = (((let_fun_218_t) CREF(node_3121))->body);
			    node_4 = node_4277;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 14):
		      {
			 let_var_6_t node_3133;
			 node_3133 = (let_var_6_t) (node_4);
			 {
			    obj_t l2115_3136;
			    l2115_3136 = (((let_var_6_t) CREF(node_3133))->bindings);
			  lname2116_3137:
			    if (PAIRP(l2115_3136))
			      {
				 {
				    node_t aux_4282;
				    {
				       obj_t aux_4283;
				       {
					  obj_t aux_4284;
					  aux_4284 = CAR(l2115_3136);
					  aux_4283 = CDR(aux_4284);
				       }
				       aux_4282 = (node_t) (aux_4283);
				    }
				    node_collect__175_cfa_collect(aux_4282, owner_5);
				 }
				 {
				    obj_t l2115_4289;
				    l2115_4289 = CDR(l2115_3136);
				    l2115_3136 = l2115_4289;
				    goto lname2116_3137;
				 }
			      }
			    else
			      {
				 ((bool_t) 1);
			      }
			 }
			 {
			    node_t node_4292;
			    node_4292 = (((let_var_6_t) CREF(node_3133))->body);
			    node_4 = node_4292;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 15):
		      {
			 set_ex_it_116_t node_3144;
			 node_3144 = (set_ex_it_116_t) (node_4);
			 {
			    node_t node_4295;
			    node_4295 = (((set_ex_it_116_t) CREF(node_3144))->body);
			    node_4 = node_4295;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 16):
		      {
			 jump_ex_it_184_t node_3148;
			 node_3148 = (jump_ex_it_184_t) (node_4);
			 node_collect__175_cfa_collect((((jump_ex_it_184_t) CREF(node_3148))->exit), owner_5);
			 {
			    node_t node_4300;
			    node_4300 = (((jump_ex_it_184_t) CREF(node_3148))->value);
			    node_4 = node_4300;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 17):
		      {
			 make_box_202_t node_3153;
			 node_3153 = (make_box_202_t) (node_4);
			 node_collect__175_cfa_collect((((make_box_202_t) CREF(node_3153))->value), owner_5);
			 {
			    bool_t test2554_3156;
			    {
			       long n1_3750;
			       n1_3750 = (long) CINT(_optim__89_engine_param);
			       test2554_3156 = (n1_3750 >= ((long) 1));
			    }
			    if (test2554_3156)
			      {
				 {
				    obj_t obj2_3754;
				    obj2_3754 = _used_alloc__125_cfa_collect;
				    {
				       obj_t aux_4308;
				       aux_4308 = (obj_t) (node_3153);
				       _used_alloc__125_cfa_collect = MAKE_PAIR(aux_4308, obj2_3754);
				    }
				 }
				 {
				    pre_make_box_186_t obj2119_3157;
				    obj2119_3157 = ((pre_make_box_186_t) (node_3153));
				    {
				       obj_t aux_4314;
				       object_t aux_4312;
				       {
					  pre_make_box_186_t aux_4315;
					  {
					     aux_4315 = ((pre_make_box_186_t) BREF(GC_MALLOC(sizeof(struct pre_make_box_186))));
					  }
					  aux_4314 = (obj_t) (aux_4315);
				       }
				       aux_4312 = (object_t) (obj2119_3157);
				       OBJECT_WIDENING_SET(aux_4312, aux_4314);
				    }
				    {
				       long arg2556_3159;
				       arg2556_3159 = class_num_218___object(pre_make_box_186_cfa_info);
				       {
					  obj_t obj_3757;
					  obj_3757 = (obj_t) (obj2119_3157);
					  (((obj_t) CREF(obj_3757))->header = MAKE_HEADER(arg2556_3159, 0), BUNSPEC);
				       }
				    }
				    return (obj_t) (obj2119_3157);
				 }
			      }
			    else
			      {
				 return BUNSPEC;
			      }
			 }
		      }
		      break;
		   case ((long) 18):
		      {
			 box_set__221_t node_3160;
			 node_3160 = (box_set__221_t) (node_4);
			 {
			    node_t aux_4324;
			    {
			       var_t aux_4325;
			       aux_4325 = (((box_set__221_t) CREF(node_3160))->var);
			       aux_4324 = (node_t) (aux_4325);
			    }
			    node_collect__175_cfa_collect(aux_4324, owner_5);
			 }
			 {
			    node_t node_4329;
			    node_4329 = (((box_set__221_t) CREF(node_3160))->value);
			    node_4 = node_4329;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   case ((long) 19):
		      {
			 box_ref_242_t node_3165;
			 node_3165 = (box_ref_242_t) (node_4);
			 {
			    node_t node_4332;
			    {
			       var_t aux_4333;
			       aux_4333 = (((box_ref_242_t) CREF(node_3165))->var);
			       node_4332 = (node_t) (aux_4333);
			    }
			    node_4 = node_4332;
			    goto node_collect__175_cfa_collect;
			 }
		      }
		      break;
		   default:
		    case_else2428_2961:
		      if (PROCEDUREP(method2422_2957))
			{
			   return PROCEDURE_ENTRY(method2422_2957) (method2422_2957, (obj_t) (node_4), (obj_t) (owner_5), BEOA);
			}
		      else
			{
			   obj_t fun2418_2951;
			   fun2418_2951 = PROCEDURE_REF(node_collect__env_176_cfa_collect, ((long) 0));
			   return PROCEDURE_ENTRY(fun2418_2951) (fun2418_2951, (obj_t) (node_4), (obj_t) (owner_5), BEOA);
			}
		   }
	      }
	    else
	      {
		 goto case_else2428_2961;
	      }
	 }
      }
   }
}


/* _node-collect!2580 */ obj_t 
_node_collect_2580_47_cfa_collect(obj_t env_3772, obj_t node_3773, obj_t owner_3774)
{
   return node_collect__175_cfa_collect((node_t) (node_3773), (variable_t) (owner_3774));
}


/* node-collect!-default2124 */ obj_t 
node_collect__default2124_48_cfa_collect(node_t node_6, variable_t owner_7)
{
   FAILURE(CNST_TABLE_REF(((long) 17)), string2581_cfa_collect, (obj_t) (node_6));
}


/* _node-collect!-default2124 */ obj_t 
_node_collect__default2124_211_cfa_collect(obj_t env_3775, obj_t node_3776, obj_t owner_3777)
{
   return node_collect__default2124_48_cfa_collect((node_t) (node_3776), (variable_t) (owner_3777));
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_cfa_collect()
{
   module_initialization_70_tools_trace(((long) 0), "CFA_COLLECT");
   module_initialization_70_tools_shape(((long) 0), "CFA_COLLECT");
   module_initialization_70_type_type(((long) 0), "CFA_COLLECT");
   module_initialization_70_type_cache(((long) 0), "CFA_COLLECT");
   module_initialization_70_type_typeof(((long) 0), "CFA_COLLECT");
   module_initialization_70_module_module(((long) 0), "CFA_COLLECT");
   module_initialization_70_engine_param(((long) 0), "CFA_COLLECT");
   module_initialization_70_ast_var(((long) 0), "CFA_COLLECT");
   module_initialization_70_ast_node(((long) 0), "CFA_COLLECT");
   module_initialization_70_ast_dump(((long) 0), "CFA_COLLECT");
   module_initialization_70_ast_env(((long) 0), "CFA_COLLECT");
   module_initialization_70_ast_sexp(((long) 0), "CFA_COLLECT");
   module_initialization_70_cfa_info(((long) 0), "CFA_COLLECT");
   module_initialization_70_cfa_procedure(((long) 0), "CFA_COLLECT");
   module_initialization_70_cfa_vector(((long) 0), "CFA_COLLECT");
   module_initialization_70_cfa_struct(((long) 0), "CFA_COLLECT");
   module_initialization_70_cfa_box(((long) 0), "CFA_COLLECT");
   return module_initialization_70_cfa_closure(((long) 0), "CFA_COLLECT");
}
