;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cfa/cinfo.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 24 15:46:49 1996                          */
;*    Last change :  Sun Nov 29 09:15:28 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The cfa's information structures                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_info
   
   (import type_type
	   type_cache
	   ast_var
	   ast_node)
   
   (export ;; the approximations
	   (class approx
	      ;; the type of the approximation. Just one type, we
	      ;; do not compute several types approximation because
	      ;; anything receiving more than one type is of type obj.
	      (type::type (default *_*))
	      ;; A type locked means that the type field can't be changed
	      ;; (e.g. because the type has been set by the user, as for
	      ;; variable).
	      (type-locked?::bool read-only (default #f))
	      ;; its allocations
	      (allocs read-only)
	      ;; or top
	      (top?::bool (default #f))
	      ;; a stamp to avoid useless multiple loose.
	      (lost-stamp::long (default -1)))

	   ;; function extensions
	   (wide-class cfun/Cinfo::cfun (approx::approx read-only))
	   (wide-class extern-sfun/Cinfo::sfun (approx::approx read-only))
	   (wide-class intern-sfun/Cinfo::sfun
	      (approx::approx read-only)
	      (stamp::long (default -1)))

	   ;; cnst extension
	   (wide-class scnst/Cinfo::scnst (approx::approx read-only))
	   
	   ;; var extensions
	   (wide-class pre-clo-env::svar)
	   (wide-class svar/Cinfo::svar
	       (approx::approx read-only)
	       ;; is this variable holding a closure environement
	       ;; (if it is it won't be lost when loosing the
	       ;; function whose's this variable owner).
	       (clo-env?::bool (default #f)))
	   (wide-class cvar/Cinfo::cvar (approx::approx read-only))

	   ;; exit extensions
	   (wide-class sexit/Cinfo::sexit (approx::approx read-only))

	   ;; global and local reshaping
	   (wide-class reshaped-local::local
	      (binding-value read-only (default #f)))
	   (wide-class reshaped-global::global)
	   
	   ;; node extension
	   (wide-class atom/Cinfo::atom (approx::approx read-only))
	   (wide-class kwote/node::kwote (node::node read-only))
	   (wide-class kwote/Cinfo::kwote (approx::approx read-only))
	   (wide-class app-ly/Cinfo::app-ly (approx::approx read-only))
	   (wide-class funcall/Cinfo::funcall
	      (approx::approx read-only)
	      (va-approx::approx read-only)
	      (arity-error-noticed?::bool (default (not *warning*)))
	      (type-error-noticed?::bool (default (not *warning*))))
	   (wide-class pragma/Cinfo::pragma (approx::approx read-only))
	   (wide-class setq/Cinfo::setq (approx::approx read-only))
	   (wide-class conditional/Cinfo::conditional (approx::approx read-only))
	   (wide-class fail/Cinfo::fail (approx::approx read-only))
	   (wide-class select/Cinfo::select (approx::approx read-only))
	   (wide-class set-ex-it/Cinfo::set-ex-it (approx::approx read-only))
	   (wide-class jump-ex-it/Cinfo::jump-ex-it (approx::approx read-only))

	   ;; boxes
	   (wide-class pre-make-box::make-box)
	   (wide-class make-box/Cinfo::make-box (approx::approx read-only))
	   (wide-class make-box/O-Cinfo::make-box
	      approx::approx
	      (value-approx::approx read-only))
	   (wide-class box-set!/Cinfo::box-set! (approx::approx read-only))
	   (wide-class box-ref/Cinfo::box-ref (approx::approx read-only))
	   (wide-class box-set!/O-Cinfo::box-set! (approx::approx read-only))
	   (wide-class box-ref/O-Cinfo::box-ref (approx::approx read-only))

	   ;; procedure
	   (wide-class pre-make-procedure-app::app
	      ;; the allocation owner
	      (owner::variable read-only))
	   (wide-class pre-procedure-ref-app::app)
	   (wide-class pre-procedure-set!-app::app)
	   
	   (wide-class make-procedure-app::app
	      ;; the approx of the make-procedure (i.e. *procedure*)
	      approx::approx
	      ;; the approximations of the values holded by the procedure
	      (* values-approx::approx (default (make-empty-approx)))
	      ;; a stamp to avoid infinit loops when loosing a procedure.
	      ;; This slot also reveals if the procedure has been lost.
	      ;; If the procedure has, lost-stamp > 0.
	      (lost-stamp::long (default -1))
	      ;; the X and T closure property (only used by cfa_closure)
	      (X-T?::bool (default #t))
	      (X::bool (default #f))
	      (T::bool (default #f))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; A procedure can be stack allocate if this field is true
	      ;; and if lost-stamp is -1
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '())))
	   (wide-class procedure-ref-app::app (approx::approx read-only))
	   (wide-class procedure-set!-app::app (approx::approx read-only))

	   ;; vector
	   (wide-class pre-make-vector-app::app
	      ;; the allocation owner
	      (owner::variable read-only))
	   (wide-class pre-create-vector-app::app
	      ;; the allocation owner
	      (owner::variable read-only))
	   (wide-class pre-vector-ref-app::app)
	   (wide-class pre-vector-set!-app::app)
	   
	   (wide-class make-vector-app::app
	      ;; the approx of the make-vector (i.e. *vector*)
	      approx::approx
	      ;; the approximation of the values holded by the vector
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a vector
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this vector (to be use in conjonction
	      ;; with lost-stamp).
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '()))
	      ;; Is the vector subject to a vector-ref or a vector-set?
	      ;; If not, this vector cannot be optimized. This is mandatory
	      ;; otherwise this analysis fails for code like:
	      ;; (let ((v #unspecified))
	      ;;     (set! v (make-vector 10 0.0))
	      ;;     (set! v #f)
	      ;;     ...)
	      ;; A type error is detected because v is given
	      ;; an erroneous type.
	      (seen?::bool (default #f)))
	   (wide-class create-vector-app::app
	      ;; the approx of the make-vector (i.e. *vector*)
	      approx::approx
	      ;; the approximation of the values holded by the vector
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a vector
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this vector (to be use in conjonction
	      ;; with lost-stamp).
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '()))
	      ;; Is the vector subject to a vector-ref or a vector-set?
	      ;; If not, this vector cannot be optimized
	      (seen?::bool (default #f)))
	   (wide-class vector-ref-app::app (approx::approx read-only))
	   (wide-class vector-set!-app::app (approx::approx read-only))
   
	   ;; struct
	   (wide-class pre-make-struct-app::app
	      ;; the allocation owner
	      (owner::variable read-only))
	   (wide-class pre-struct-ref-app::app)
	   (wide-class pre-struct-set!-app::app)
	   
	   (wide-class make-struct-app::app
	      ;; the approx of the make-struct (i.e. *struct*)
	      approx::approx
	      ;; the approximation of the values holded by the struct
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a struct
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this structure (to be use in conjonction
	      ;; with lost-stamp)
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '())))
      
	   (wide-class struct-ref-app::app (approx::approx read-only))
	   (wide-class struct-set!-app::app (approx::approx read-only))))
   
