;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cfa/app.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 24 17:36:29 1996                          */
;*    Last change :  Mon Jul 15 11:02:52 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The cfa on `app' node                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_app
   (include "Tools/trace.sch")
   (import  tools_shape
	    tools_error
	    type_type
	    ast_var
	    ast_node
	    cfa_info
	    cfa_cfa
	    cfa_iterate
	    cfa_loose
	    cfa_approx)
   (export  (generic app!::approx ::fun ::var approx)))

;*---------------------------------------------------------------------*/
;*    cfa! ::app ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::app)
   (trace (cfa 2) " app: " (shape node) #\Newline)
   (with-access::app node (fun args)
      (app! (variable-value (var-variable fun)) fun (map cfa! args))))

;*---------------------------------------------------------------------*/
;*    app! ...                                                         */
;*---------------------------------------------------------------------*/
(define-generic (app!::approx fun::fun var::var args-approx)
   (internal-error "app!"
		   "No method for this function"
		   (cons fun (shape var))))

;*---------------------------------------------------------------------*/
;*    app! ::intern-sfun/Cinfo ...                                     */
;*---------------------------------------------------------------------*/
(define-method (app! fun::intern-sfun/Cinfo var::var args-approx)
   (trace (cfa 3) "  app(intern)!: " (shape var) " " (shape args-approx)
	  #\Newline)
   (with-access::intern-sfun/Cinfo fun (args)
      ;; we set the new formals approximation
      (for-each (lambda (formal approx)
		   (union-approx! (svar/Cinfo-approx (local-value formal))
				  approx))
		args
		args-approx)
      ;; and we jump to the function body
      (cfa-intern-sfun! fun (var-variable var))))
   
;*---------------------------------------------------------------------*/
;*    app! ::extern-sfun ...                                           */
;*---------------------------------------------------------------------*/
(define-method (app! fun::extern-sfun/Cinfo var::var args-approx)
   (trace (cfa 3) "  app(extern)!: " (shape var) " " (shape args-approx)
	  #\Newline)
   (with-access::extern-sfun/Cinfo fun (top? approx)
      ;; we set the new formals approximation
      (if top? (for-each (lambda (a) (loose! a 'all)) args-approx))
      ;; and we return the global approximation
      approx))
   
;*---------------------------------------------------------------------*/
;*    app! ::cfun/Cinfo ...                                            */
;*---------------------------------------------------------------------*/
(define-method (app! fun::cfun/Cinfo var::var args-approx)
   (trace (cfa 3) "  app(cfun)!: " (shape var) #\Newline)
   (with-access::cfun/Cinfo fun (top? approx)
      ;; we set the new formals approximation
      (if top? (for-each (lambda (a) (loose! a 'all)) args-approx))
      ;; and we return the global approximation
      approx))
