;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/ld.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 17 09:37:55 1992                          */
;*    Last change :  Thu Dec  3 16:04:53 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The (system) link.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cc_ld
   (export  (ld name ::bool))
   (extern  (macro shared-library-available?::bool "HAVE_SHARED_LIBRARY")
	    (macro shared-link-option::string "ADDITIONAL_SHARED_LINK_OPTION")
	    (macro static-link-option::string "ADDITIONAL_STATIC_LINK_OPTION"))
   (import  tools_speek
	    tools_error
	    cc_exec
	    engine_param
	    (find-file/path tools_file)))

;*---------------------------------------------------------------------*/
;*    list-of-string->string ...                                       */
;*---------------------------------------------------------------------*/
(define (list-of-string->string l)
   (let loop ((l (reverse l))
	      (r ""))
      (if (null? l)
	  r
	  (loop (cdr l)
		(string-append (car l) " " r)))))

;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*---------------------------------------------------------------------*/
(define (ld name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-ld name need-to-return))
      (else
       (user-error "ld" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    lib+suffix ...                                                   */
;*---------------------------------------------------------------------*/
(define (lib+suffix lib static?)
   (if (or static? *static-bigloo?* (not shared-library-available?))
       (make-static-library-name lib)
       (make-shared-library-name lib)))

;*---------------------------------------------------------------------*/
;*    make-lib-name ...                                                */
;*---------------------------------------------------------------------*/
(define (make-lib-name lib-name static?)
   (let ((name (find-file/path (lib+suffix lib-name static?) *lib-dir*)))
      (if (not (string? name))
	  (error "make-lib-name" "Can't find library" lib-name)
	  name)))

;*---------------------------------------------------------------------*/
;*    select-library ...                                               */
;*---------------------------------------------------------------------*/
(define (select-library lib-name)
   (cond
      (*profile-library*
       (string-append lib-name "_p"))
      (*unsafe-library*
       (string-append lib-name "_u"))
      (else
       lib-name)))
   
;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*    -------------------------------------------------------------    */
;*    Le link se fait avec plusieurs fichiers:                         */
;*       1- Le fichier .o resultat de la compilation courrante         */
;*       2- Tous les .o qui ont ete passes en argument                 */
;*       3- Tous les .o qui correspondent aux fichiers de presents     */
;*          dans les clauses `with' du main.                           */
;*---------------------------------------------------------------------*/
(define (unix-ld name need-to-return)
   (verbose 1 "   . ld (" *cc* ")" #\Newline)
   ;; we add additional, machine specific, link options.
   (let ((static? (string-case *ld-options*
		     ((: (* all) "-static")
		      #t)
		     (else
		      #f))))
      (if static?
	  (set! *ld-options* (string-append static-link-option
					    " " *ld-options*))
	  (set! *ld-options* (string-append shared-link-option
					    " " *ld-options*)))
      (let* ((dest       (if (string? *dest*)
			     *dest*
			     "a.out"))
	     ;; the standard bigloo library
	     (lib-name   (string-append "lib" (select-library *bigloo-lib*)))
	     (bigloo-lib (make-lib-name lib-name static?))
	     ;; the garbarge collector libary
	     (gclib-name (string-append "lib" *gc-lib*))
	     (gc-lib     (make-lib-name gclib-name static?))
	     (bdb-lib    (if (>fx *bdb-debug* 0)
			     (make-lib-name "libbdb" #t)
			     ""))
	     ;; the extra bigloo libraries
	     (add-libs   (let loop ((lib *additional-bigloo-libraries*)
				    (res  ""))
			    (if (null? lib)
				res
				(loop (cdr lib)
				      (string-append (make-lib-name
						      (string-append
						       "lib"
						       (select-library
							(car lib)))
						      static?)
						     " "
						     res)))))
	     ;; the extra user C libraries
	     (other-libs (let loop ((lib *bigloo-user-lib*)
				    (res ""))
			    (if (null? lib)
				res
				(loop (cdr lib)
				      (string-append (car lib)
						     " " res)))))
	     (ld-args    (string-append
			  ;; object file name
			  name ".o" " "
			  ;; to be linked with files
			  (list-of-string->string *with-files*)
			  ;; other object files
			  (list-of-string->string *o-files*)
			  ;; the executable name
			  " -o " dest
			  ;; cc options
			  " "  *cc-options*
			  ;; optional debug option
			  (if (or *c-debug* (>fx *bdb-debug* 0))
			      (string-append " " *c-debug-option*)
			      "")
			  ;; optional executable stripping
			  (if *strip* " -s" "")
			  ;; user ld otions
			  " " *ld-options*
			  ;; the library path
			  (let loop ((path *lib-dir*))
			     (if (null? path)
				 ""
				 (string-append "-L"
						(car path)
						" "
						(loop (cdr path)))))
			  ;; the bdb library
			  " " bdb-lib
			  ;; additional Bigloo libaries
			  " " add-libs
			  ;; standard bigloo library
			  " " bigloo-lib
			  ;; standard GC library
			  " " gc-lib
			  ;; user libraries
			  " " other-libs))
	     (cmd/ld     (string-append *cc* " " ld-args))
	     (cmd        cmd/ld))
	 (verbose 2 "      ["  cmd/ld #\] #\Newline)
	 (exec cmd need-to-return "ld"))))
