;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/indent.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Sep 15 15:49:56 1992                          */
;*    Last change :  Sat Jan 17 10:12:12 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The indentation of the C file                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_indent
   (export  (indent name))
   (import  tools_speek
	    engine_param))

;*---------------------------------------------------------------------*/
;*    indent ...                                                       */
;*---------------------------------------------------------------------*/
(define (indent name)
   (if (and (string? name)
	    (string? *indent*)
	    (>fx (string-length *indent*) 0))
       (begin
	  (verbose 1 "   . indent (" (basename *indent*) ")" #\Newline)
	  (let ((cmd (string-append *indent* " "
					    name ".c > "
					    name ".cc ")))
	     (verbose 2 "      [" cmd #\] #\Newline)
	     (let ((res (system cmd)))
		(if (not (=fx res 0))
		    (warning *indent* "Non nul value returned -- " res)))
	     (if (file-exists? (string-append name ".cc"))
		 (let ((sname (string-append name ".cc"))
		       (dname (string-append name ".c")))
		    (verbose 2 "        mv " sname " " dname #\Newline)
		    (rename-file sname dname)))))))
