;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/exec.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:09:34 1995                          */
;*    Last change :  Tue Jan 20 15:04:08 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    When we don't need to make any action after invoking the C       */
;*    compiler (i.e. when the C compiler is called in a tail           */
;*    call position), rather than invoking it with the `system'        */
;*    we use the `execp' command. This module implements a             */
;*    private version of `exec' which take  parameters that            */
;*    tells if the command must return or not.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_exec
   (include "Tools/trace.sch")
   (foreign (macro int execl (string string string string long) "execl"))
   (import  tools_error
	    engine_param
	    init_main)
   (export  (exec ::bstring ::bool ::bstring)))

;*---------------------------------------------------------------------*/
;*    exec-fname ...                                                   */
;*---------------------------------------------------------------------*/
(define (exec-fname)
   "$myselfx1001")

;*---------------------------------------------------------------------*/
;*    exec ...                                                         */
;*---------------------------------------------------------------------*/
(define (exec cmd flag name)
   (if (or flag (not (string? *shell*)))
       (begin
	  (trace cc "system: " cmd #\Newline)
	  (let ((res (system cmd)))
	     (if (not (=fx res 0))
		 (exit-bigloo 1)
		 res)))
       (begin
	  (trace cc "system/kill: " cmd #\Newline)
	  (system/kill cmd))))

;*---------------------------------------------------------------------*/
;*    system/kill ...                                                  */
;*---------------------------------------------------------------------*/
(define (system/kill cmd)
   (print (execl *shell* *shell* "-c" cmd 0))
   (internal-error "system/kill" "Can't execute cmd" cmd))
 
   


