;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/cc.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:51:32 1995                          */
;*    Last change :  Tue Oct  6 15:06:31 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C compilation                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_cc
   (export  (cc name ::bool))
   (import  tools_speek
	    tools_file
	    tools_error
	    cc_exec
	    engine_param))

;*---------------------------------------------------------------------*/
;*    cc ...                                                           */
;*---------------------------------------------------------------------*/
(define (cc name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-cc name need-to-return))
      (else
       (user-error "cc" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    unix-cc ...                                                      */
;*---------------------------------------------------------------------*/
(define (unix-cc name need-to-return)
   (verbose 1 "   . cc (" *cc* ")" #\Newline)
   (cond
      ((not (string? name))
       (error "cc" "can't process cc on stdout" name))
      (else
       (let ((cc (string-append *cc*
				" "
				*cc-options*
				" -c "
				" -I. "
				(let loop ((path *lib-dir*))
				   (if (null? path)
				       ""
				       (string-append "-I"
						      (car path)
						      " "
						      (loop (cdr path)))))
				(if (or *c-debug* (>fx *bdb-debug* 0))
				    (string-append " " *c-debug-option*)
				    "")
				" " name ".c ")))
	  (verbose 2 "      ["  cc #\] #\Newline)
	  (let* ((basename (basename name))
		 (rm-csrc  (if *rm-c-files*
			       (string-append "&& /bin/rm -f " name ".c ")
			       ""))
		 (pwd      (let ((vpwd (getenv "PWD")))
			      (if (string? vpwd)
				  vpwd
				  (pwd))))
		 (mv-obj   (if (and (not (string=? basename name))
				    (not (string=? pwd (dirname name))))
			       (string-append "&& /bin/mv "
					      basename 
					      ".o "
					      name
					      ".o 2>&1 >/dev/null ")
			       ""))
		 (cmd      (string-append cc mv-obj rm-csrc)))
	     (exec cmd need-to-return "cc"))))))
